/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.launches;

import java.lang.reflect.Constructor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.launches.TestElementLabelDecorator;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EarlyStartup
implements IStartup {
    private static final boolean DECORATE = PropertiesUtil.isProperty((String)"org.eclipse.oomph.launches.TestElementLabelDecorator");
    private static final String JUNIT_PART_NAME = "org.eclipse.jdt.junit.ResultView";
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.addPageListener(EarlyStartup.this.pageListener);
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePageListener(EarlyStartup.this.pageListener);
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };
    private final IPageListener pageListener = new IPageListener(){

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener(EarlyStartup.this.partListener);
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(EarlyStartup.this.partListener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }
    };
    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            try {
                if (EarlyStartup.JUNIT_PART_NAME.equals(part.getSite().getId())) {
                    EarlyStartup.this.handleJUnitView(part);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    };

    public void earlyStartup() {
        if (DECORATE) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IViewReference[] iViewReferenceArray = page.getViewReferences();
                        int n5 = iViewReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IViewPart part;
                            IViewReference viewReference = iViewReferenceArray[n6];
                            if (JUNIT_PART_NAME.equals(viewReference.getId()) && (part = viewReference.getView(true)) != null) {
                                workbench.getDisplay().syncExec(new Runnable((IWorkbenchPart)part){
                                    private final /* synthetic */ IWorkbenchPart val$part;
                                    {
                                        this.val$part = iWorkbenchPart;
                                    }

                                    public void run() {
                                        EarlyStartup.this.handleJUnitView(this.val$part);
                                    }
                                });
                            }
                            ++n6;
                        }
                        page.addPartListener(this.partListener);
                        ++n4;
                    }
                    window.addPageListener(this.pageListener);
                    ++n2;
                }
                workbench.addWindowListener(this.windowListener);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void handleJUnitView(IWorkbenchPart part) {
        try {
            Object fTestViewer = ReflectUtil.getValue((String)"fTestViewer", (Object)part);
            TreeViewer fTreeViewer = (TreeViewer)ReflectUtil.getValue((String)"fTreeViewer", (Object)fTestViewer);
            DelegatingStyledCellLabelProvider.IStyledLabelProvider fTreeLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)ReflectUtil.getValue((String)"fTreeLabelProvider", (Object)fTestViewer);
            IBaseLabelProvider labelProvider = fTreeViewer.getLabelProvider();
            Constructor constructor = ReflectUtil.getConstructor(labelProvider.getClass(), (Class[])new Class[]{DelegatingStyledCellLabelProvider.IStyledLabelProvider.class, ILabelDecorator.class, IDecorationContext.class});
            labelProvider = (IBaseLabelProvider)ReflectUtil.newInstance((Constructor)constructor, (Object[])new Object[]{fTreeLabelProvider, new TestElementLabelDecorator(), null});
            fTreeViewer.setLabelProvider(labelProvider);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

