/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.filters.CustomizationTab;
import org.eclipse.ui.internal.navigator.filters.UserFilter;
import org.eclipse.ui.navigator.CommonViewer;

public class UserFiltersTab
extends CustomizationTab {
    private ArrayList<UserFilter> userFiltersWorkingCopy;

    public UserFiltersTab(Composite parent, CommonViewer commonViewer) {
        super(parent, commonViewer.getNavigatorContentService());
        Object data = commonViewer.getData("resourceRegexpFilters");
        this.userFiltersWorkingCopy = data != null ? new ArrayList((Collection)data) : new ArrayList();
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 64);
        label.setText(CommonNavigatorMessages.CommonFilterSelectionDialog_Set_custom_filters_to_apply);
        label.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        CheckboxTableViewer filtersViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2080);
        filtersViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
        filtersViewer.getTable().setLayout((Layout)tableLayout);
        filtersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn((TableViewer)filtersViewer, 65536, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object o) {
                return ((UserFilter)o).getRegexp();
            }
        });
        UserFilterRegexpEditingSupport editingSupport = new UserFilterRegexpEditingSupport(filtersViewer);
        column.setEditingSupport((EditingSupport)editingSupport);
        filtersViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ((UserFilter)element).isEnabled();
            }
        });
        filtersViewer.addCheckStateListener(event -> ((UserFilter)event.getElement()).setEnabled(event.getChecked()));
        filtersViewer.setInput(this.userFiltersWorkingCopy);
        Composite buttonsComposite = new Composite((Composite)this, 0);
        buttonsComposite.setLayoutData((Object)new GridData(-1, 128, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        Button addButton = new Button(buttonsComposite, 8);
        addButton.setLayoutData((Object)new GridData(4, -1, false, false));
        addButton.setText(CommonNavigatorMessages.CommonFilterSelectionDialog_RegexpFilter_New);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            UserFilter newFilter = new UserFilter();
            this.userFiltersWorkingCopy.add(newFilter);
            filtersViewer.refresh();
            filtersViewer.setSelection((ISelection)new StructuredSelection((Object)newFilter));
            editingSupport.setEditionEnabled(true);
            filtersViewer.editElement((Object)newFilter, 0);
            editingSupport.setEditionEnabled(false);
        }));
        Button editButton = new Button(buttonsComposite, 8);
        editButton.setLayoutData((Object)new GridData(4, -1, false, false));
        editButton.setText(CommonNavigatorMessages.CommonFilterSelectionDialog_RegexpFilter_Edit);
        editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            editingSupport.setEditionEnabled(true);
            filtersViewer.editElement(((IStructuredSelection)filtersViewer.getSelection()).getFirstElement(), 0);
            editingSupport.setEditionEnabled(false);
        }));
        Button removeButton = new Button(buttonsComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, -1, false, false));
        removeButton.setText(CommonNavigatorMessages.CommonFilterSelectionDialog_RegexpFilter_Remove);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            UserFilter filter = (UserFilter)((IStructuredSelection)filtersViewer.getSelection()).getFirstElement();
            this.userFiltersWorkingCopy.remove(filter);
            filtersViewer.refresh();
        }));
        filtersViewer.addSelectionChangedListener(event -> {
            editButton.setEnabled(!event.getSelection().isEmpty());
            removeButton.setEnabled(!event.getSelection().isEmpty());
        });
        filtersViewer.setSelection((ISelection)new StructuredSelection());
    }

    public List<UserFilter> getUserFilters() {
        return this.userFiltersWorkingCopy;
    }

    private static class UserFilterRegexpEditingSupport
    extends EditingSupport {
        private boolean enableEdition = false;

        public UserFilterRegexpEditingSupport(CheckboxTableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        public void setEditionEnabled(boolean enableEdition) {
            this.enableEdition = enableEdition;
        }

        public CheckboxTableViewer getViewer() {
            return (CheckboxTableViewer)super.getViewer();
        }

        protected void setValue(Object element, Object value) {
            ((UserFilter)element).setRegexp((String)value);
            this.getViewer().update(element, null);
        }

        protected Object getValue(Object element) {
            return ((UserFilter)element).getRegexp();
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getTable());
        }

        protected boolean canEdit(Object element) {
            return this.enableEdition;
        }
    }
}

