/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.show;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.show.ShowKeysUI;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class ShowKeysListener
implements IExecutionListener,
IPropertyChangeListener,
IDisposable {
    private IPreferenceStore preferenceStore;
    private IServiceLocator serviceLocator;
    private ShowKeysUI showKeysUI;

    public ShowKeysListener(IServiceLocator serviceLocator, IPreferenceStore preferenceStore) {
        this.serviceLocator = serviceLocator;
        this.preferenceStore = preferenceStore;
        this.showKeysUI = new ShowKeysUI(serviceLocator, preferenceStore);
        if (this.isEnabled()) {
            ICommandService cmdService = this.serviceLocator.getService(ICommandService.class);
            cmdService.addExecutionListener(this);
        }
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void dispose() {
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        ICommandService cmdService = this.serviceLocator.getService(ICommandService.class);
        if (cmdService != null) {
            cmdService.removeExecutionListener(this);
        }
        this.showKeysUI.dispose();
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        if (!this.isEnabled() || "org.eclipse.ui.toggleShowKeys".equals(commandId)) {
            return;
        }
        Display.getDefault().asyncExec(() -> this.showKeysUI.open(commandId, (Event)event.getTrigger()));
    }

    private boolean isEnabled() {
        return this.preferenceStore.getBoolean("showCommandKeys");
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("showCommandKeys".equals(property)) {
            ICommandService cmdService = this.serviceLocator.getService(ICommandService.class);
            if (this.isEnabled()) {
                cmdService.addExecutionListener(this);
            } else {
                cmdService.removeExecutionListener(this);
            }
        }
    }
}

