/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public final class NonLocalUndoUserApprover
implements IOperationApprover {
    private IUndoContext context;
    private IEditorPart part;
    private Object[] elements;
    private Class<?> affectedObjectsClass;
    private ArrayList elementsAndAdapters;

    public NonLocalUndoUserApprover(IUndoContext context, IEditorPart part, Object[] affectedObjects, Class<?> preferredComparisonClass) {
        this.context = context;
        this.part = part;
        this.affectedObjectsClass = preferredComparisonClass;
        this.elements = affectedObjects;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!this.requiresApproval(operation, uiInfo)) {
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)WorkbenchMessages.Operations_nonLocalRedoWarning, (Object)operation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(operation, message, WorkbenchMessages.Operations_discardRedo, WorkbenchMessages.Workbench_redoToolTip);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        if (!this.requiresApproval(operation, uiInfo)) {
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)WorkbenchMessages.Operations_nonLocalUndoWarning, (Object)operation.getLabel(), (Object)this.part.getEditorInput().getName());
        return this.proceedWithOperation(operation, message, WorkbenchMessages.Operations_discardUndo, WorkbenchMessages.Workbench_undoToolTip);
    }

    private IStatus proceedWithOperation(IUndoableOperation operation, String message, String discardButton, String title) {
        boolean local;
        if (!(operation instanceof IAdvancedUndoableOperation)) {
            return Status.OK_STATUS;
        }
        Object[] modifiedElements = ((IAdvancedUndoableOperation)operation).getAffectedObjects();
        if (modifiedElements == null) {
            local = false;
        } else {
            local = true;
            Object[] objectArray = modifiedElements;
            int n = modifiedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object modifiedElement = objectArray[n2];
                if (!this.elementsContains(modifiedElement)) {
                    Object adapter;
                    local = false;
                    if (this.affectedObjectsClass != null && (adapter = Adapters.adapt((Object)modifiedElement, this.affectedObjectsClass)) != null && this.elementsContains(adapter)) {
                        local = true;
                    }
                    if (!local) break;
                }
                ++n2;
            }
        }
        if (local) {
            return Status.OK_STATUS;
        }
        int[] answer = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(this.part.getSite().getShell(), title, null, message, 3, 0, new String[]{IDialogConstants.OK_LABEL, discardButton, IDialogConstants.CANCEL_LABEL});
            nArray[0] = dialog.open();
        });
        switch (answer[0]) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return IOperationHistory.OPERATION_INVALID_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private boolean requiresApproval(IUndoableOperation operation, IAdaptable uiInfo) {
        IUndoContext originatingContext;
        if (!operation.hasContext(this.context)) {
            return false;
        }
        if (operation.getContexts().length == 1) {
            return false;
        }
        return uiInfo == null || (originatingContext = (IUndoContext)Adapters.adapt((Object)uiInfo, IUndoContext.class)) == null || originatingContext.matches(this.context);
    }

    private boolean elementsContains(Object someObject) {
        if (this.elements == null) {
            return false;
        }
        if (this.elementsAndAdapters == null) {
            this.elementsAndAdapters = new ArrayList(this.elements.length);
            Object[] objectArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object adapter;
                Object element = objectArray[n2];
                this.elementsAndAdapters.add(element);
                if (this.affectedObjectsClass != null && !this.affectedObjectsClass.isInstance(element) && (adapter = Adapters.adapt((Object)element, this.affectedObjectsClass)) != null) {
                    this.elementsAndAdapters.add(adapter);
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < this.elementsAndAdapters.size()) {
            if (this.elementsAndAdapters.get(i).equals(someObject)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

