/*
 * Copyright (c) 2014, 2015, 2018 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.setup;

import org.eclipse.oomph.base.ModelElement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Catalog Selection</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.oomph.setup.CatalogSelection#getProductCatalogs <em>Product Catalogs</em>}</li>
 *   <li>{@link org.eclipse.oomph.setup.CatalogSelection#getProjectCatalogs <em>Project Catalogs</em>}</li>
 *   <li>{@link org.eclipse.oomph.setup.CatalogSelection#getDefaultProductVersions <em>Default Product Versions</em>}</li>
 *   <li>{@link org.eclipse.oomph.setup.CatalogSelection#getDefaultStreams <em>Default Streams</em>}</li>
 *   <li>{@link org.eclipse.oomph.setup.CatalogSelection#getSelectedStreams <em>Selected Streams</em>}</li>
 * </ul>
 *
 * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection()
 * @model
 * @generated
 */
public interface CatalogSelection extends ModelElement
{
  /**
   * Returns the value of the '<em><b>Product Catalogs</b></em>' reference list.
   * The list contents are of type {@link org.eclipse.oomph.setup.ProductCatalog}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Product Catalogs</em>' reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Product Catalogs</em>' reference list.
   * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection_ProductCatalogs()
   * @model keys="name"
   *        extendedMetaData="name='productCatalog'"
   * @generated
   */
  EList<ProductCatalog> getProductCatalogs();

  /**
   * Returns the value of the '<em><b>Project Catalogs</b></em>' reference list.
   * The list contents are of type {@link org.eclipse.oomph.setup.ProjectCatalog}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Project Catalogs</em>' reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Project Catalogs</em>' reference list.
   * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection_ProjectCatalogs()
   * @model keys="name"
   *        extendedMetaData="name='projectCatalog'"
   * @generated
   */
  EList<ProjectCatalog> getProjectCatalogs();

  /**
   * Returns the value of the '<em><b>Default Product Versions</b></em>' map.
   * The key is of type {@link org.eclipse.oomph.setup.Product},
   * and the value is of type {@link org.eclipse.oomph.setup.ProductVersion},
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Default Product Versions</em>' map isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Default Product Versions</em>' map.
   * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection_DefaultProductVersions()
   * @model mapType="org.eclipse.oomph.setup.ProductToProductVersionMapEntry&lt;org.eclipse.oomph.setup.Product, org.eclipse.oomph.setup.ProductVersion&gt;"
   *        extendedMetaData="name='defaultProductVersion'"
   * @generated
   */
  EMap<Product, ProductVersion> getDefaultProductVersions();

  /**
   * Returns the value of the '<em><b>Default Streams</b></em>' map.
   * The key is of type {@link org.eclipse.oomph.setup.Project},
   * and the value is of type {@link org.eclipse.oomph.setup.Stream},
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Default Streams</em>' map isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Default Streams</em>' map.
   * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection_DefaultStreams()
   * @model mapType="org.eclipse.oomph.setup.ProjectToStreamMapEntry&lt;org.eclipse.oomph.setup.Project, org.eclipse.oomph.setup.Stream&gt;"
   *        extendedMetaData="name='defaultStream'"
   * @generated
   */
  EMap<Project, Stream> getDefaultStreams();

  /**
   * Returns the value of the '<em><b>Selected Streams</b></em>' reference list.
   * The list contents are of type {@link org.eclipse.oomph.setup.Stream}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Selected Streams</em>' reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Selected Streams</em>' reference list.
   * @see org.eclipse.oomph.setup.SetupPackage#getCatalogSelection_SelectedStreams()
   * @model transient="true" volatile="true" derived="true"
   * @generated
   */
  EList<Stream> getSelectedStreams();

} // CatalogSelection
