/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workingsets.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.setup.workingsets.SetupWorkingSetsPackage;
import org.eclipse.oomph.setup.workingsets.WorkingSetTask;
import org.eclipse.oomph.setup.workingsets.provider.SetupWorkingSetsEditPlugin;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetTaskItemProvider
extends SetupTaskItemProvider {
    public WorkingSetTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPrefixPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPrefixPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_WorkingSetTask_prefix_feature"), this.getString("_UI_WorkingSetTask_prefix_description"), (EStructuralFeature)SetupWorkingSetsPackage.Literals.WORKING_SET_TASK__PREFIX, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupWorkingSetsPackage.Literals.WORKING_SET_TASK__WORKING_SETS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/WorkingSetTask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        WorkingSetTask workingSetTask = (WorkingSetTask)object;
        StringBuilder builder = new StringBuilder();
        HashSet<String> added = new HashSet<String>();
        for (WorkingSet workingSet : workingSetTask.getWorkingSets()) {
            String name = workingSet.getName();
            if (!added.add(name)) continue;
            if (builder.length() != 0) {
                builder.append(" + ");
            }
            builder.append(name);
        }
        String label = this.getString("_UI_WorkingSetTask_type");
        if (builder.length() != 0) {
            label = String.valueOf(label) + " (" + builder + ")";
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(WorkingSetTask.class)) {
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SetupWorkingSetsPackage.Literals.WORKING_SET_TASK__WORKING_SETS, WorkingSetsFactory.eINSTANCE.createWorkingSet()));
    }

    public ResourceLocator getResourceLocator() {
        return SetupWorkingSetsEditPlugin.INSTANCE;
    }
}

