/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

class SelectionChangedListener<S extends ISelectionProvider, D extends IDiff>
extends NativePropertyListener<S, D>
implements ISelectionChangedListener {
    private final boolean isPostSelection;

    SelectionChangedListener(IProperty property, ISimplePropertyListener<S, D> listener, boolean isPostSelection) {
        super(property, listener);
        this.isPostSelection = isPostSelection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireChange((ISelectionProvider)event.getSource(), null);
    }

    public void doAddTo(ISelectionProvider source) {
        if (this.isPostSelection) {
            ((IPostSelectionProvider)source).addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            source.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void doRemoveFrom(ISelectionProvider source) {
        if (this.isPostSelection) {
            ((IPostSelectionProvider)source).removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            source.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

