/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workingsets.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.workingsets.SetupWorkingSetsPackage;
import org.eclipse.oomph.setup.workingsets.WorkingSetTask;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetGroup;
import org.eclipse.oomph.workingsets.util.WorkingSetsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetTaskImpl
extends SetupTaskImpl
implements WorkingSetTask {
    protected EList<WorkingSet> workingSets;

    protected WorkingSetTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupWorkingSetsPackage.Literals.WORKING_SET_TASK;
    }

    @Override
    public EList<WorkingSet> getWorkingSets() {
        if (this.workingSets == null) {
            this.workingSets = new EObjectContainmentEList(WorkingSet.class, (InternalEObject)this, 9);
        }
        return this.workingSets;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getWorkingSets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getWorkingSets();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getWorkingSets().clear();
                this.getWorkingSets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getWorkingSets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.workingSets != null && !this.workingSets.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    private String getWorkingSetPrefix() {
        EObject eContainer = this.eContainer();
        while (eContainer != null) {
            if (eContainer instanceof Scope) {
                Scope scope = (Scope)eContainer;
                return String.valueOf(scope.getQualifiedName().replace(' ', '.')) + '-';
            }
            eContainer = eContainer.eContainer();
        }
        throw new IllegalStateException("The working set task must be indirectly contained by a scope");
    }

    private Map<String, WorkingSet> getExistingWorkingSets(String prefix, EList<WorkingSet> workingSets) {
        HashMap<String, WorkingSet> existingWorkingSets = new HashMap<String, WorkingSet>();
        for (WorkingSet workingSet : workingSets) {
            String id = workingSet.getID();
            if (id == null || !id.startsWith(prefix)) continue;
            existingWorkingSets.put(id, workingSet);
        }
        return existingWorkingSets;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        String prefix = this.getWorkingSetPrefix();
        WorkingSetGroup defaultWorkingSetGroup = WorkingSetsUtil.getWorkingSetGroup();
        Map<String, WorkingSet> existingWorkingSets = this.getExistingWorkingSets(prefix, (EList<WorkingSet>)defaultWorkingSetGroup.getWorkingSets());
        for (WorkingSet workingSet : this.getWorkingSets()) {
            String id = String.valueOf(prefix) + workingSet.getName();
            workingSet.setID(id);
        }
        for (WorkingSet workingSet : this.getWorkingSets()) {
            context.checkCancelation();
            WorkingSet existingWorkingSet = existingWorkingSets.remove(workingSet.getID());
            if (existingWorkingSet != null && EcoreUtil.equals((List)workingSet.getPredicates(), (List)existingWorkingSet.getPredicates())) continue;
            return true;
        }
        return !existingWorkingSets.isEmpty();
    }

    public void perform(SetupTaskContext context) throws Exception {
        String prefix = this.getWorkingSetPrefix();
        WorkingSetGroup defaultWorkingSetGroup = WorkingSetsUtil.getWorkingSetGroup();
        EList workingSets = defaultWorkingSetGroup.getWorkingSets();
        Map<String, WorkingSet> existingWorkingSets = this.getExistingWorkingSets(prefix, (EList<WorkingSet>)workingSets);
        EList<WorkingSet> newWorkingSetGroups = this.getWorkingSets();
        int index = 0;
        for (WorkingSet workingSet : new ArrayList<WorkingSet>((Collection<WorkingSet>)newWorkingSetGroups)) {
            context.checkCancelation();
            String id = workingSet.getID();
            WorkingSet existingWorkingSet = existingWorkingSets.remove(id);
            if (existingWorkingSet == null) {
                workingSets.add(index++, (Object)workingSet);
                continue;
            }
            index = workingSets.indexOf((Object)existingWorkingSet);
            workingSets.set(index, (Object)workingSet);
            ++index;
        }
        workingSets.removeAll(existingWorkingSets.values());
        Resource resource = defaultWorkingSetGroup.eResource();
        resource.save(null);
    }

    public int getPriority() {
        return 600;
    }
}

