/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.markers.internal.DialogMarkerProperties;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DialogTaskProperties
extends DialogMarkerProperties {
    private static final String PRIORITY_HIGH = MarkerMessages.propertiesDialog_priorityHigh;
    private static final String PRIORITY_NORMAL = MarkerMessages.propertiesDialog_priorityNormal;
    private static final String PRIORITY_LOW = MarkerMessages.propertiesDialog_priorityLow;
    protected Combo priorityCombo;
    protected Button completedCheckbox;

    public DialogTaskProperties(Shell parentShell) {
        super(parentShell);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    public DialogTaskProperties(Shell parentShell, String title) {
        super(parentShell, title);
        this.setType("org.eclipse.core.resources.taskmarker");
    }

    @Override
    protected void createAttributesArea(Composite parent) {
        this.createSeperator(parent);
        super.createAttributesArea(parent);
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_priority);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{PRIORITY_HIGH, PRIORITY_NORMAL, PRIORITY_LOW});
        this.priorityCombo.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map<String, Object> initialAttributes = DialogTaskProperties.this.getInitialAttributes();
                    initialAttributes.put("priority", new Integer(DialogTaskProperties.this.getPriorityFromDialog()));
                }
                DialogTaskProperties.this.markDirty();
            }
        });
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setText(MarkerMessages.propertiesDialog_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogTaskProperties.this.getMarker() == null) {
                    Map<String, Object> initialAttributes = DialogTaskProperties.this.getInitialAttributes();
                    initialAttributes.put("done", DialogTaskProperties.this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
                }
                DialogTaskProperties.this.markDirty();
            }
        });
    }

    protected boolean getCompleted() {
        IMarker marker = this.getMarker();
        if (marker == null) {
            Map<String, Object> attributes = this.getInitialAttributes();
            Object done = attributes.get("done");
            return done != null && done instanceof Boolean && (Boolean)done != false;
        }
        return marker.getAttribute("done", false);
    }

    protected int getPriority() {
        IMarker marker = this.getMarker();
        int priority = 1;
        if (marker == null) {
            Map<String, Object> attributes = this.getInitialAttributes();
            Object priorityObj = attributes.get("priority");
            if (priorityObj != null && priorityObj instanceof Integer) {
                priority = (Integer)priorityObj;
            }
        } else {
            priority = marker.getAttribute("priority", 1);
        }
        return priority;
    }

    @Override
    protected void updateEnablement() {
        super.updateEnablement();
        this.priorityCombo.setEnabled(this.isEditable());
        this.completedCheckbox.setEnabled(this.isEditable());
    }

    @Override
    protected void updateDialogForNewMarker() {
        Map<String, Object> initialAttributes = this.getInitialAttributes();
        int priority = this.getPriority();
        initialAttributes.put("priority", new Integer(priority));
        if (priority == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (priority == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean completed = this.getCompleted();
        initialAttributes.put("done", completed ? Boolean.TRUE : Boolean.FALSE);
        this.completedCheckbox.setSelection(completed);
        super.updateDialogForNewMarker();
    }

    @Override
    protected void updateDialogFromMarker() {
        Map<String, Object> initialAttributes = this.getInitialAttributes();
        int priority = this.getPriority();
        initialAttributes.put("priority", new Integer(priority));
        if (priority == 2) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_HIGH));
        } else if (priority == 0) {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_LOW));
        } else {
            this.priorityCombo.select(this.priorityCombo.indexOf(PRIORITY_NORMAL));
        }
        boolean completed = this.getCompleted();
        initialAttributes.put("done", completed ? Boolean.TRUE : Boolean.FALSE);
        this.completedCheckbox.setSelection(completed);
        super.updateDialogFromMarker();
    }

    private int getPriorityFromDialog() {
        int priority = 1;
        if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_HIGH)) {
            priority = 2;
        } else if (this.priorityCombo.getSelectionIndex() == this.priorityCombo.indexOf(PRIORITY_LOW)) {
            priority = 0;
        }
        return priority;
    }

    @Override
    protected Map<String, Object> getMarkerAttributes() {
        Map<String, Object> attrs = super.getMarkerAttributes();
        attrs.put("priority", new Integer(this.getPriorityFromDialog()));
        attrs.put("done", this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
        Object userEditable = attrs.get("userEditable");
        if (userEditable == null || !(userEditable instanceof Boolean)) {
            attrs.put("userEditable", Boolean.TRUE);
        }
        return attrs;
    }

    @Override
    protected String getModifyOperationTitle() {
        return MarkerMessages.modifyTask_title;
    }

    @Override
    protected String getCreateOperationTitle() {
        return MarkerMessages.DialogTaskProperties_CreateTask;
    }
}

