/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.BasicDescription;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeBuilder;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeMatcher;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LazyInputStream;
import org.eclipse.core.internal.content.LazyReader;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.debug.DebugOptions;

public class ContentTypeManager
extends ContentTypeMatcher
implements IContentTypeManager,
IRegistryChangeListener {
    public static final int BLOCK_SIZE = 1024;
    public static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String OPTION_DEBUG_CONTENT_TYPES = "org.eclipse.core.contenttype/debug";
    static boolean DEBUGGING = false;
    private ContentTypeCatalog catalog;
    private int catalogGeneration;
    protected final ListenerList contentTypeListeners = new ListenerList();

    public void setExtensionRegistry(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.core.runtime");
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.core.contenttype");
    }

    public void unsetExtensionRegistry(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        this.invalidate();
        registry.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? "" : fileName.substring(dotPosition + 1);
    }

    protected static ILazySource readBuffer(InputStream contents) {
        return new LazyInputStream(contents, 1024);
    }

    protected static ILazySource readBuffer(Reader contents) {
        return new LazyReader(contents, 1024);
    }

    public ContentTypeManager() {
        super(null, InstanceScope.INSTANCE);
    }

    protected ContentTypeBuilder createBuilder(ContentTypeCatalog newCatalog) {
        return new ContentTypeBuilder(newCatalog);
    }

    @Override
    public IContentType[] getAllContentTypes() {
        ContentTypeCatalog currentCatalog = this.getCatalog();
        IContentType[] types = currentCatalog.getAllContentTypes();
        IContentType[] result = new IContentType[types.length];
        int generation = currentCatalog.getGeneration();
        int i = 0;
        while (i < result.length) {
            result[i] = new ContentTypeHandler(this, (ContentType)types[i], generation);
            ++i;
        }
        return result;
    }

    protected synchronized ContentTypeCatalog getCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        ContentTypeCatalog newCatalog = new ContentTypeCatalog(this, this.catalogGeneration++);
        ContentTypeBuilder builder = this.createBuilder(newCatalog);
        try {
            builder.buildCatalog();
            this.catalog = newCatalog;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
        newCatalog.organize();
        return newCatalog;
    }

    @Override
    public IContentType getContentType(String contentTypeIdentifier) {
        ContentTypeCatalog currentCatalog = this.getCatalog();
        ContentType type = currentCatalog.getContentType(contentTypeIdentifier);
        return type == null ? null : new ContentTypeHandler(this, type, currentCatalog.getGeneration());
    }

    @Override
    public IContentTypeMatcher getMatcher(IContentTypeManager.ISelectionPolicy customPolicy, IScopeContext context) {
        return new ContentTypeMatcher(this, customPolicy, context == null ? this.getContext() : context);
    }

    IEclipsePreferences getPreferences() {
        return this.getPreferences(this.getContext());
    }

    IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode(CONTENT_TYPE_PREF_NODE);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        if (event.getExtensionDeltas("org.eclipse.core.runtime", "contentTypes").length == 0 && event.getExtensionDeltas("org.eclipse.core.contenttype", "contentTypes").length == 0) {
            return;
        }
        this.invalidate();
    }

    synchronized void invalidate() {
        if (DEBUGGING && this.catalog != null) {
            ContentMessages.message("Registry discarded");
        }
        this.catalog = null;
    }

    @Override
    public void addContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.add((Object)listener);
    }

    @Override
    public void removeContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.remove((Object)listener);
    }

    public void fireContentTypeChangeEvent(ContentType type) {
        Object[] listeners = this.contentTypeListeners.getListeners();
        ContentTypeHandler eventObject = new ContentTypeHandler(this, type, type.getCatalog().getGeneration());
        int i = 0;
        while (i < listeners.length) {
            final IContentTypeManager.ContentTypeChangeEvent event = new IContentTypeManager.ContentTypeChangeEvent(eventObject);
            final IContentTypeManager.IContentTypeChangeListener listener = (IContentTypeManager.IContentTypeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.contentTypeChanged(event);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    @Override
    public IContentDescription getSpecificDescription(BasicDescription description) {
        return description;
    }

    void setDebugOptions(DebugOptions options) {
        DEBUGGING = options == null ? false : options.getBooleanOption(OPTION_DEBUG_CONTENT_TYPES, false);
    }

    void unsetDebugOptions(DebugOptions options) {
        DEBUGGING = false;
    }
}

