/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ProductCatalogsDialog
extends AbstractSetupDialog {
    public static final String TITLE = "Product Catalogs";
    public static final String DESCRIPTION = "Select the product catalogs to use";
    private CatalogManager catalogManager;
    private CheckboxTableViewer catalogViewer;
    private boolean product;

    public ProductCatalogsDialog(Shell parentShell, CatalogManager catalogManager, boolean product) {
        super(parentShell, TITLE, 450, 300, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.catalogManager = catalogManager;
        this.product = product;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return "Select the product catalogs to use.";
    }

    protected void createUI(Composite parent) {
        this.catalogViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.catalogViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.catalogViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof CatalogManager)) {
                    throw new IllegalArgumentException("input must be a CatalogManager");
                }
                return ProductCatalogsDialog.this.catalogManager.getCatalogs(ProductCatalogsDialog.this.product).toArray();
            }
        });
        this.catalogViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Scope && !"self".equals(((Scope)element).getName());
            }
        });
        this.catalogViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return SetupCoreUtil.getLabel((Scope)((Scope)element));
            }
        });
        this.catalogViewer.setInput((Object)this.catalogManager);
        this.catalogViewer.setCheckedElements(this.catalogManager.getSelectedCatalogs(this.product).toArray());
    }

    protected void okPressed() {
        List<Object> checkedElements = Arrays.asList(this.catalogViewer.getCheckedElements());
        for (Scope scope : this.catalogManager.getCatalogs(this.product)) {
            this.catalogManager.selectCatalog(this.product, scope, checkedElements.contains(scope));
        }
        super.okPressed();
    }
}

