/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.internal.adaptor.ConsoleManager;
import org.eclipse.core.runtime.internal.adaptor.DefaultStartupMonitor;
import org.eclipse.core.runtime.internal.adaptor.EclipseAppLauncher;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.storage.url.reference.Handler;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseStarter {
    private static BundleContext context;
    private static boolean initialize;
    public static boolean debug;
    private static boolean running;
    private static ServiceRegistration<?> defaultMonitorRegistration;
    private static ServiceRegistration<?> appLauncherRegistration;
    private static ServiceRegistration<?> splashStreamRegistration;
    private static final String CLEAN = "-clean";
    private static final String CONSOLE = "-console";
    private static final String CONSOLE_LOG = "-consoleLog";
    private static final String DEBUG = "-debug";
    private static final String INITIALIZE = "-initialize";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String NL_EXTENSIONS = "-nlExtensions";
    private static final String CONFIGURATION = "-configuration";
    private static final String USER = "-user";
    private static final String NOEXIT = "-noExit";
    private static final String LAUNCHER = "-launcher";
    private static final String DATA = "-data";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_INITIAL_STARTLEVEL = "osgi.startLevel";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    private static final String PROP_NL_EXTENSIONS = "osgi.nl.extensions";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_LOGFILE = "osgi.logfile";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    public static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_IGNOREAPP = "eclipse.ignoreApp";
    public static final String PROP_REFRESH_BUNDLES = "eclipse.refreshBundles";
    private static final String PROP_ALLOW_APPRELAUNCH = "eclipse.allowAppRelaunch";
    private static final String PROP_APPLICATION_LAUNCHDEFAULT = "eclipse.application.launchDefault";
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    private static final int DEFAULT_INITIAL_STARTLEVEL = 6;
    private static final String DEFAULT_BUNDLES_STARTLEVEL = "4";
    private static FrameworkLog log;
    private static Map<String, String[]> searchCandidates;
    private static EclipseAppLauncher appLauncher;
    private static List<Runnable> shutdownHandlers;
    private static ConsoleManager consoleMgr;
    private static Map<String, String> configuration;
    private static Framework framework;
    private static EquinoxConfiguration equinoxConfig;
    private static String[] allArgs;
    private static String[] frameworkArgs;
    private static String[] appArgs;

    static {
        initialize = false;
        debug = false;
        running = false;
        defaultMonitorRegistration = null;
        appLauncherRegistration = null;
        splashStreamRegistration = null;
        searchCandidates = new HashMap<String, String[]>(4);
        consoleMgr = null;
        configuration = null;
        framework = null;
        allArgs = null;
        frameworkArgs = null;
        appArgs = null;
    }

    private static synchronized String getProperty(String key) {
        if (equinoxConfig != null) {
            return equinoxConfig.getConfiguration(key);
        }
        return EclipseStarter.getConfiguration().get(key);
    }

    private static synchronized String getProperty(String key, String dft) {
        if (equinoxConfig != null) {
            return equinoxConfig.getConfiguration(key, dft);
        }
        String result = EclipseStarter.getConfiguration().get(key);
        return result == null ? dft : result;
    }

    private static synchronized Object setProperty(String key, String value) {
        if (equinoxConfig != null) {
            return equinoxConfig.setProperty(key, value);
        }
        if ("true".equals(EclipseStarter.getConfiguration().get("osgi.framework.useSystemProperties"))) {
            System.setProperty(key, value);
        }
        return EclipseStarter.getConfiguration().put(key, value);
    }

    private static synchronized Object clearProperty(String key) {
        if (equinoxConfig != null) {
            return equinoxConfig.clearConfiguration(key);
        }
        return EclipseStarter.getConfiguration().remove(key);
    }

    private static synchronized Map<String, String> getConfiguration() {
        if (configuration == null) {
            configuration = new HashMap<String, String>();
            configuration.put("osgi.framework.useSystemProperties", System.getProperty("osgi.framework.useSystemProperties", "true"));
            String systemCompatibilityBoot = System.getProperty("osgi.compatibility.bootdelegation");
            if (systemCompatibilityBoot != null) {
                configuration.put("osgi.compatibility.bootdelegation", systemCompatibilityBoot);
            } else {
                configuration.put("osgi.compatibility.bootdelegation.default", "true");
            }
        }
        return configuration;
    }

    public static void main(String[] args) throws Exception {
        Object result;
        if (EclipseStarter.getProperty("eclipse.startTime") == null) {
            EclipseStarter.setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        }
        if (EclipseStarter.getProperty(PROP_NOSHUTDOWN) == null) {
            EclipseStarter.setProperty(PROP_NOSHUTDOWN, "true");
        }
        if (EclipseStarter.getProperty("osgi.compatibility.bootdelegation") == null) {
            EclipseStarter.setProperty("osgi.compatibility.bootdelegation", "false");
        }
        if ((result = EclipseStarter.run(args, null)) instanceof Integer && !Boolean.valueOf(EclipseStarter.getProperty(PROP_NOSHUTDOWN)).booleanValue()) {
            System.exit((Integer)result);
        }
    }

    public static Object run(String[] args, Runnable endSplashHandler) throws Exception {
        if (running) {
            throw new IllegalStateException(Msg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        boolean startupFailed = true;
        try {
            EclipseStarter.startup(args, endSplashHandler);
            startupFailed = false;
            if (Boolean.valueOf(EclipseStarter.getProperty(PROP_IGNOREAPP)).booleanValue() || EclipseStarter.isForcedRestart()) {
                return null;
            }
            Object object = EclipseStarter.run(null);
            return object;
        }
        catch (Throwable e) {
            if (endSplashHandler != null) {
                endSplashHandler.run();
            }
            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, startupFailed ? Msg.ECLIPSE_STARTUP_STARTUP_ERROR : Msg.ECLIPSE_STARTUP_APP_ERROR, 1, e, null);
            if (log != null) {
                log.log(logEntry);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (EclipseStarter.isForcedRestart()) {
                    EclipseStarter.setProperty(PROP_EXITCODE, "23");
                }
                if (!Boolean.valueOf(EclipseStarter.getProperty(PROP_NOSHUTDOWN)).booleanValue()) {
                    EclipseStarter.shutdown();
                }
            }
            catch (Throwable e) {
                FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, Msg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e, null);
                if (log != null) {
                    log.log(logEntry);
                }
                e.printStackTrace();
            }
        }
        if (EclipseStarter.getProperty(PROP_EXITCODE) == null) {
            EclipseStarter.setProperty(PROP_EXITCODE, "13");
            EclipseStarter.setProperty(PROP_EXITDATA, NLS.bind(Msg.ECLIPSE_STARTUP_ERROR_CHECK_LOG, log == null ? null : log.getFile().getPath()));
        }
        return null;
    }

    public static boolean isRunning() {
        return running;
    }

    public static BundleContext startup(String[] args, Runnable endSplashHandler) throws Exception {
        if (running) {
            throw new IllegalStateException(Msg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        EclipseStarter.processCommandLine(args);
        framework = new Equinox(EclipseStarter.getConfiguration());
        framework.init();
        context = framework.getBundleContext();
        ServiceReference<FrameworkLog> logRef = context.getServiceReference(FrameworkLog.class);
        log = context.getService(logRef);
        ServiceReference<EnvironmentInfo> configRef = context.getServiceReference(EnvironmentInfo.class);
        equinoxConfig = (EquinoxConfiguration)context.getService(configRef);
        equinoxConfig.setAllArgs(allArgs);
        equinoxConfig.setFrameworkArgs(frameworkArgs);
        equinoxConfig.setAppArgs(appArgs);
        EclipseStarter.registerFrameworkShutdownHandlers();
        EclipseStarter.publishSplashScreen(endSplashHandler);
        consoleMgr = ConsoleManager.startConsole(context, equinoxConfig);
        Bundle[] startBundles = EclipseStarter.loadBasicBundles();
        if (startBundles == null || "true".equals(EclipseStarter.getProperty(PROP_REFRESH_BUNDLES)) && EclipseStarter.refreshPackages(EclipseStarter.getCurrentBundles(false))) {
            EclipseStarter.waitForShutdown();
            return context;
        }
        framework.start();
        if (EclipseStarter.isForcedRestart()) {
            return context;
        }
        EclipseStarter.setStartLevel(EclipseStarter.getStartLevel());
        EclipseStarter.ensureBundlesActive(startBundles);
        try {
            consoleMgr.checkForConsoleBundle();
        }
        catch (BundleException e) {
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, e.getMessage(), 0, e, null);
            log.log(entry);
        }
        running = true;
        return context;
    }

    private static int getStartLevel() {
        block3: {
            String level = EclipseStarter.getProperty(PROP_INITIAL_STARTLEVEL);
            if (level != null) {
                try {
                    return Integer.parseInt(level);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debug) break block3;
                    Debug.println("Start level = " + level + "  parsed. Using hardcoded default: 6");
                }
            }
        }
        return 6;
    }

    /*
     * Unable to fully structure code
     */
    public static Object run(Object argument) throws Exception {
        block6: {
            if (!EclipseStarter.running) {
                throw new IllegalStateException(Msg.ECLIPSE_STARTUP_NOT_RUNNING);
            }
            if (EclipseStarter.initialize) {
                return new Integer(0);
            }
            try {
                if (EclipseStarter.appLauncher == null) {
                    launchDefault = Boolean.valueOf(EclipseStarter.getProperty("eclipse.application.launchDefault", "true"));
                    EclipseStarter.appLauncher = new EclipseAppLauncher(EclipseStarter.context, Boolean.valueOf(EclipseStarter.getProperty("eclipse.allowAppRelaunch")), launchDefault, EclipseStarter.log, EclipseStarter.equinoxConfig);
                    EclipseStarter.appLauncherRegistration = EclipseStarter.context.registerService(ApplicationLauncher.class.getName(), (Object)EclipseStarter.appLauncher, null);
                    return EclipseStarter.appLauncher.start(argument);
                }
                return EclipseStarter.appLauncher.reStart(argument);
            }
            catch (Exception e) {
                if (EclipseStarter.log == null || EclipseStarter.context == null) break block6;
                report = EclipseStarter.context.getBundle().adapt(Module.class).getContainer().resolve(null, false);
                ** for (unresolved : report.getEntries().keySet())
            }
lbl-1000:
            // 1 sources

            {
                bsn = ((ModuleRevision)unresolved).getSymbolicName();
                logEntry = new FrameworkLogEntry(bsn != null ? bsn : "org.eclipse.osgi", 2, 0, String.valueOf(Msg.Module_ResolveError) + report.getResolutionReportMessage(unresolved), 1, null, null);
                EclipseStarter.log.log(logEntry);
                continue;
            }
        }
        throw e;
    }

    public static void shutdown() throws Exception {
        if (!running || framework == null) {
            return;
        }
        if (framework.getState() == 32) {
            if (appLauncherRegistration != null) {
                appLauncherRegistration.unregister();
            }
            if (splashStreamRegistration != null) {
                splashStreamRegistration.unregister();
            }
            if (defaultMonitorRegistration != null) {
                defaultMonitorRegistration.unregister();
            }
        }
        if (appLauncher != null) {
            appLauncher.shutdown();
        }
        appLauncherRegistration = null;
        appLauncher = null;
        splashStreamRegistration = null;
        defaultMonitorRegistration = null;
        if (consoleMgr != null) {
            consoleMgr.stopConsole();
            consoleMgr = null;
        }
        if (framework.getState() == 32) {
            framework.stop();
            framework.waitForStop(0L);
            framework = null;
        }
        configuration = null;
        equinoxConfig = null;
        context = null;
        running = false;
    }

    private static void ensureBundlesActive(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getState() != 32) {
                if (bundles[i].getState() == 2) {
                    log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundles[i].getLocation()), 0, null, null));
                } else {
                    FrameworkStartLevel fwStartLevel = context.getBundle().adapt(FrameworkStartLevel.class);
                    BundleStartLevel bundleStartLevel = bundles[i].adapt(BundleStartLevel.class);
                    if (fwStartLevel != null && bundleStartLevel.getStartLevel() <= fwStartLevel.getStartLevel()) {
                        log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_ACTIVE, bundles[i]), 0, null, null));
                    }
                }
            }
            ++i;
        }
    }

    private static void publishSplashScreen(Runnable endSplashHandler) {
        if (endSplashHandler == null) {
            return;
        }
        try {
            Method method = endSplashHandler.getClass().getMethod("getOutputStream", new Class[0]);
            Object outputStream = method.invoke((Object)endSplashHandler, new Object[0]);
            if (outputStream instanceof OutputStream) {
                Hashtable<String, String> osProperties = new Hashtable<String, String>();
                ((Dictionary)osProperties).put("name", "splashstream");
                splashStreamRegistration = context.registerService(OutputStream.class.getName(), outputStream, osProperties);
            }
        }
        catch (Exception exception) {}
        try {
            Hashtable<String, Integer> monitorProps = new Hashtable<String, Integer>();
            ((Dictionary)monitorProps).put("service.ranking", new Integer(Integer.MIN_VALUE));
            defaultMonitorRegistration = context.registerService(StartupMonitor.class.getName(), (Object)new DefaultStartupMonitor(endSplashHandler, equinoxConfig), monitorProps);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private static URL searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            EclipseStarter.createURL(name);
            url = EclipseStarter.createURL(new File(parent).toURL(), name);
        }
        catch (MalformedURLException malformedURLException) {
            File child = new File(name);
            fileLocation = child.isAbsolute() ? child : new File(parent, name);
            url = EclipseStarter.createURL(REFERENCE_PROTOCOL, null, fileLocation.toURL().toExternalForm());
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith(FILE_SCHEME) ? ((child = new File(baseSpec.substring(5))).isAbsolute() ? child.toURL() : new File(parent, child.getPath()).toURL()) : EclipseStarter.createURL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = EclipseStarter.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (result != null) {
                url = EclipseStarter.createURL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)result);
            } else {
                return null;
            }
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Bundle[] loadBasicBundles() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        String osgiBundles = EclipseStarter.getProperty(PROP_BUNDLES);
        String osgiExtensions = EclipseStarter.getProperty(PROP_EXTENSIONS);
        if (osgiExtensions != null && osgiExtensions.length() > 0) {
            osgiBundles = String.valueOf(osgiExtensions) + ',' + osgiBundles;
            EclipseStarter.setProperty(PROP_BUNDLES, osgiBundles);
        }
        String[] installEntries = EclipseStarter.getArrayFromList(osgiBundles, ",");
        InitialBundle[] initialBundles = EclipseStarter.getInitialBundles(installEntries);
        Bundle[] curInitBundles = EclipseStarter.getCurrentBundles(true);
        ArrayList<Bundle> toRefresh = new ArrayList<Bundle>(curInitBundles.length);
        EclipseStarter.uninstallBundles(curInitBundles, initialBundles, toRefresh);
        ArrayList<Bundle> startBundles = new ArrayList<Bundle>(installEntries.length);
        ArrayList<Bundle> lazyActivationBundles = new ArrayList<Bundle>(installEntries.length);
        EclipseStarter.installBundles(initialBundles, curInitBundles, startBundles, lazyActivationBundles, toRefresh);
        if (!toRefresh.isEmpty() && EclipseStarter.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]))) {
            return null;
        }
        Bundle[] startInitBundles = startBundles.toArray(new Bundle[startBundles.size()]);
        Bundle[] lazyInitBundles = lazyActivationBundles.toArray(new Bundle[lazyActivationBundles.size()]);
        EclipseStarter.startBundles(startInitBundles, lazyInitBundles);
        if (debug) {
            Debug.println("Time to load bundles: " + (System.currentTimeMillis() - startTime));
        }
        return startInitBundles;
    }

    private static InitialBundle[] getInitialBundles(String[] installEntries) {
        Location installLocation;
        Collection<ServiceReference<Location>> installLocRef;
        searchCandidates.clear();
        ArrayList<InitialBundle> result = new ArrayList<InitialBundle>(installEntries.length);
        int defaultStartLevel = Integer.parseInt(EclipseStarter.getProperty(PROP_BUNDLES_STARTLEVEL, DEFAULT_BUNDLES_STARTLEVEL));
        String syspath = EclipseStarter.getSysPath();
        try {
            syspath = new File(syspath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        try {
            installLocRef = context.getServiceReferences(Location.class, Location.INSTALL_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        Location location = installLocation = installLocRef == null ? null : context.getService(installLocRef.iterator().next());
        if (installLocation == null) {
            throw new IllegalStateException(Msg.EclipseStarter_InstallLocation);
        }
        int i = 0;
        while (i < installEntries.length) {
            String name = installEntries[i];
            int level = defaultStartLevel;
            boolean start = false;
            int index = name.lastIndexOf(64);
            if (index >= 0) {
                String[] attributes = EclipseStarter.getArrayFromList(name.substring(index + 1, name.length()), ":");
                int j = 0;
                while (j < attributes.length) {
                    String attribute = attributes[j];
                    if (attribute.equals("start")) {
                        start = true;
                    } else {
                        try {
                            level = Integer.parseInt(attribute);
                        }
                        catch (NumberFormatException numberFormatException) {
                            index = name.length();
                        }
                    }
                    ++j;
                }
                name = name.substring(0, index);
            }
            try {
                URL location2 = EclipseStarter.searchForBundle(name, syspath);
                if (location2 == null) {
                    FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, installEntries[i]), 0, null, null);
                    log.log(entry);
                } else {
                    location2 = EclipseStarter.makeRelative(installLocation.getURL(), location2);
                    String locationString = INITIAL_LOCATION + location2.toExternalForm();
                    result.add(new InitialBundle(locationString, location2, level, start));
                }
            }
            catch (IOException e) {
                log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, e.getMessage(), 0, e, null));
            }
            ++i;
        }
        return result.toArray(new InitialBundle[result.size()]);
    }

    private static boolean refreshPackages(Bundle[] bundles) throws InterruptedException {
        FrameworkWiring frameworkWiring = context.getBundle().adapt(FrameworkWiring.class);
        if (frameworkWiring == null) {
            return false;
        }
        Semaphore semaphore = new Semaphore(0);
        StartupEventListener listener = new StartupEventListener(semaphore, 4);
        context.addBundleListener(listener);
        frameworkWiring.refreshBundles(Arrays.asList(bundles), listener);
        EclipseStarter.updateSplash(semaphore, listener);
        return EclipseStarter.isForcedRestart();
    }

    private static void waitForShutdown() {
        try {
            framework.waitForStop(0L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    private static void processCommandLine(String[] args) throws Exception {
        allArgs = args;
        if (args.length == 0) {
            frameworkArgs = args;
            return;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                EclipseStarter.setProperty(PROP_DEBUG, "");
                debug = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                EclipseStarter.setProperty(PROP_DEV, "");
                found = true;
            }
            if (args[i].equalsIgnoreCase(INITIALIZE)) {
                initialize = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CLEAN)) {
                EclipseStarter.setProperty(PROP_CLEAN, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE_LOG)) {
                EclipseStarter.setProperty(PROP_CONSOLE_LOG, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                EclipseStarter.setProperty(PROP_CONSOLE, "");
                found = true;
            }
            if (args[i].equalsIgnoreCase(NOEXIT)) {
                EclipseStarter.setProperty(PROP_NOSHUTDOWN, "true");
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(CONSOLE)) {
                    EclipseStarter.setProperty(PROP_CONSOLE, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                    EclipseStarter.setProperty("osgi.configuration.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DATA)) {
                    EclipseStarter.setProperty("osgi.instance.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(USER)) {
                    EclipseStarter.setProperty("osgi.user.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(LAUNCHER)) {
                    EclipseStarter.setProperty("eclipse.launcher", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    EclipseStarter.setProperty(PROP_DEV, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEBUG)) {
                    EclipseStarter.setProperty(PROP_DEBUG, arg);
                    debug = true;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(WS)) {
                    EclipseStarter.setProperty(PROP_WS, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(OS)) {
                    EclipseStarter.setProperty(PROP_OS, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(ARCH)) {
                    EclipseStarter.setProperty(PROP_ARCH, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(NL)) {
                    EclipseStarter.setProperty(PROP_NL, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(NL_EXTENSIONS)) {
                    EclipseStarter.setProperty(PROP_NL_EXTENSIONS, arg);
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            frameworkArgs = new String[0];
            appArgs = args;
            return;
        }
        appArgs = new String[args.length - configArgIndex];
        frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                EclipseStarter.frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                EclipseStarter.appArgs[j++] = args[i2];
            }
            ++i2;
        }
    }

    private static String[] getArrayFromList(String prop, String separator) {
        return ManifestElement.getArrayFromList(prop, separator);
    }

    protected static String getSysPath() {
        String result = EclipseStarter.getProperty(PROP_SYSPATH);
        if (result != null) {
            return result;
        }
        result = EclipseStarter.getSysPathFromURL(EclipseStarter.getProperty(PROP_FRAMEWORK));
        if (result == null) {
            result = EclipseStarter.getSysPathFromCodeSource();
        }
        if (result == null) {
            throw new IllegalStateException("Can not find the system path.");
        }
        if (Character.isUpperCase(result.charAt(0))) {
            char[] chars = result.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        EclipseStarter.setProperty(PROP_SYSPATH, result);
        return result;
    }

    private static String getSysPathFromURL(String urlSpec) {
        if (urlSpec == null) {
            return null;
        }
        URL url = LocationHelper.buildURL(urlSpec, false);
        if (url == null) {
            return null;
        }
        File fwkFile = new File(url.getFile());
        fwkFile = new File(fwkFile.getAbsolutePath());
        fwkFile = new File(fwkFile.getParent());
        return fwkFile.getAbsolutePath();
    }

    private static String getSysPathFromCodeSource() {
        ProtectionDomain pd = EclipseStarter.class.getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            return null;
        }
        String result = url.getFile();
        if (File.separatorChar == '\\') {
            result = result.replace('\\', '/');
        }
        if (result.endsWith(".jar")) {
            result = result.substring(0, result.lastIndexOf(47));
            if ("folder".equals(EclipseStarter.getProperty(PROP_FRAMEWORK_SHAPE))) {
                result = result.substring(0, result.lastIndexOf(47));
            }
        } else {
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            result = result.substring(0, result.lastIndexOf(47));
            result = result.substring(0, result.lastIndexOf(47));
        }
        return result;
    }

    private static Bundle[] getCurrentBundles(boolean includeInitial) {
        Bundle[] installed = context.getBundles();
        ArrayList<Bundle> initial = new ArrayList<Bundle>();
        int i = 0;
        while (i < installed.length) {
            Bundle bundle = installed[i];
            if (bundle.getLocation().startsWith(INITIAL_LOCATION)) {
                if (includeInitial) {
                    initial.add(bundle);
                }
            } else if (!includeInitial && bundle.getBundleId() != 0L) {
                initial.add(bundle);
            }
            ++i;
        }
        return initial.toArray(new Bundle[initial.size()]);
    }

    private static Bundle getBundleByLocation(String location, Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if (location.equalsIgnoreCase(bundle.getLocation())) {
                return bundle;
            }
            ++i;
        }
        return null;
    }

    private static void uninstallBundles(Bundle[] curInitBundles, InitialBundle[] newInitBundles, List<Bundle> toRefresh) {
        int i = 0;
        while (i < curInitBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < newInitBundles.length) {
                if (curInitBundles[i].getLocation().equalsIgnoreCase(newInitBundles[j].locationString)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                try {
                    curInitBundles[i].uninstall();
                    toRefresh.add(curInitBundles[i]);
                }
                catch (BundleException e) {
                    FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_FAILED_UNINSTALL, curInitBundles[i].getLocation()), 0, e, null);
                    log.log(entry);
                }
            }
            ++i;
        }
    }

    private static void installBundles(InitialBundle[] initialBundles, Bundle[] curInitBundles, List<Bundle> startBundles, List<Bundle> lazyActivationBundles, List<Bundle> toRefresh) {
        int i = 0;
        while (i < initialBundles.length) {
            block12: {
                FrameworkLogEntry entry;
                Bundle osgiBundle = EclipseStarter.getBundleByLocation(initialBundles[i].locationString, curInitBundles);
                try {
                    if (osgiBundle == null) {
                        InputStream in = initialBundles[i].location.openStream();
                        try {
                            osgiBundle = context.installBundle(initialBundles[i].locationString, in);
                        }
                        catch (BundleException e) {
                            if (e.getType() != 9) {
                                throw e;
                            }
                            break block12;
                        }
                        if (!initialBundles[i].start && EclipseStarter.hasLazyActivationPolicy(osgiBundle)) {
                            lazyActivationBundles.add(osgiBundle);
                        }
                    }
                    if ((osgiBundle.getState() & 1) == 0 && initialBundles[i].level >= 0) {
                        osgiBundle.adapt(BundleStartLevel.class).setStartLevel(initialBundles[i].level);
                    }
                    if (initialBundles[i].start) {
                        startBundles.add(osgiBundle);
                    }
                    if ((osgiBundle.getState() & 2) != 0) {
                        toRefresh.add(osgiBundle);
                    }
                }
                catch (BundleException e) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i].location), 0, e, null);
                    log.log(entry);
                }
                catch (IOException e) {
                    entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i].location), 0, e, null);
                    log.log(entry);
                }
            }
            ++i;
        }
    }

    private static boolean hasLazyActivationPolicy(Bundle target) {
        block9: {
            ManifestElement[] elements;
            block10: {
                Dictionary<String, String> headers;
                block8: {
                    headers = target.getHeaders("");
                    String fragmentHost = headers.get("Fragment-Host");
                    if (fragmentHost != null) {
                        return false;
                    }
                    String activationPolicy = headers.get("Bundle-ActivationPolicy");
                    try {
                        if (activationPolicy == null) break block8;
                        ManifestElement[] elements2 = ManifestElement.parseHeader("Bundle-ActivationPolicy", activationPolicy);
                        if (elements2 != null && elements2.length > 0 && "lazy".equals(elements2[0].getValue())) {
                            return true;
                        }
                        break block9;
                    }
                    catch (BundleException bundleException) {}
                }
                String eclipseLazyStart = headers.get("Eclipse-LazyStart");
                if (eclipseLazyStart == null) {
                    eclipseLazyStart = headers.get("Eclipse-AutoStart");
                }
                if ((elements = ManifestElement.parseHeader("Eclipse-AutoStart", eclipseLazyStart)) == null || elements.length <= 0) break block9;
                if (!"true".equals(elements[0].getValue())) break block10;
                return true;
            }
            if (elements[0].getDirective("exceptions") != null) {
                return true;
            }
        }
        return false;
    }

    private static void startBundles(Bundle[] startBundles, Bundle[] lazyBundles) {
        int i = 0;
        while (i < startBundles.length) {
            EclipseStarter.startBundle(startBundles[i], 0);
            ++i;
        }
        i = 0;
        while (i < lazyBundles.length) {
            EclipseStarter.startBundle(lazyBundles[i], 2);
            ++i;
        }
    }

    private static void startBundle(Bundle bundle, int options) {
        block2: {
            try {
                bundle.start(options);
            }
            catch (BundleException e) {
                if ((bundle.getState() & 4) == 0) break block2;
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(Msg.ECLIPSE_STARTUP_FAILED_START, bundle.getLocation()), 0, e, null);
                log.log(entry);
            }
        }
    }

    private static URL makeRelative(URL base, URL location) throws MalformedURLException {
        if (base == null) {
            return location;
        }
        if (!"file".equals(base.getProtocol())) {
            return location;
        }
        if (!location.getProtocol().equals(REFERENCE_PROTOCOL)) {
            return location;
        }
        URL nonReferenceLocation = EclipseStarter.createURL(location.getPath());
        if (!base.getProtocol().equals(nonReferenceLocation.getProtocol())) {
            return location;
        }
        File locationPath = new File(nonReferenceLocation.getPath());
        if (!locationPath.isAbsolute()) {
            return location;
        }
        File relativePath = EclipseStarter.makeRelative(new File(base.getPath()), locationPath);
        String urlPath = relativePath.getPath();
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace(File.separatorChar, '/');
        }
        if (nonReferenceLocation.getPath().endsWith("/")) {
            urlPath = String.valueOf(urlPath) + '/';
        }
        URL relativeURL = EclipseStarter.createURL(base.getProtocol(), base.getHost(), base.getPort(), urlPath);
        relativeURL = EclipseStarter.createURL(REFERENCE_SCHEME + relativeURL.toExternalForm());
        return relativeURL;
    }

    private static URL createURL(String spec) throws MalformedURLException {
        return EclipseStarter.createURL(null, spec);
    }

    private static URL createURL(URL urlContext, String spec) throws MalformedURLException {
        if (context != null && spec.startsWith(REFERENCE_SCHEME)) {
            return new URL(urlContext, spec, new Handler(context.getProperty(PROP_INSTALL_AREA)));
        }
        return new URL(urlContext, spec);
    }

    private static URL createURL(String protocol, String host, String file) throws MalformedURLException {
        return EclipseStarter.createURL(protocol, host, -1, file);
    }

    private static URL createURL(String protocol, String host, int port, String file) throws MalformedURLException {
        if (context != null && REFERENCE_PROTOCOL.equalsIgnoreCase(protocol)) {
            return new URL(protocol, host, port, file, new Handler(context.getProperty(PROP_INSTALL_AREA)));
        }
        return new URL(protocol, host, port, file);
    }

    private static File makeRelative(File base, File location) {
        if (!location.isAbsolute()) {
            return location;
        }
        File relative = new File(new FilePath(base).makeRelative(new FilePath(location)));
        return relative;
    }

    private static void setStartLevel(int value) throws InterruptedException {
        FrameworkStartLevel fwkStartLevel = context.getBundle().adapt(FrameworkStartLevel.class);
        Semaphore semaphore = new Semaphore(0);
        StartupEventListener listener = new StartupEventListener(semaphore, 8);
        context.addBundleListener(listener);
        fwkStartLevel.setStartLevel(value, listener);
        EclipseStarter.updateSplash(semaphore, listener);
    }

    private static void updateSplash(Semaphore semaphore, StartupEventListener listener) throws InterruptedException {
        ServiceTracker monitorTracker = new ServiceTracker(context, StartupMonitor.class.getName(), null);
        try {
            monitorTracker.open();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        try {
            do {
                StartupMonitor monitor;
                if ((monitor = (StartupMonitor)monitorTracker.getService()) == null) continue;
                try {
                    monitor.update();
                }
                catch (Throwable throwable) {}
            } while (!semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS));
        }
        catch (Throwable throwable) {
            if (listener != null) {
                try {
                    context.removeBundleListener(listener);
                    monitorTracker.close();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            throw throwable;
        }
        if (listener != null) {
            try {
                context.removeBundleListener(listener);
                monitorTracker.close();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private static String searchFor(String target, String start) {
        String[] candidates = searchCandidates.get(start);
        if (candidates == null) {
            String decodePath;
            File f;
            File startFile = new File(start);
            if (!startFile.exists() && start.indexOf(37) >= 0 && (f = new File(decodePath = EquinoxConfiguration.decode(start))).exists()) {
                startFile = f;
            }
            if ((candidates = startFile.list()) != null) {
                searchCandidates.put(start, candidates);
            }
        }
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        boolean resultIsFile = false;
        int i = 0;
        while (i < candidates.length) {
            block11: {
                String version;
                Object[] currentVersion;
                char versionSep;
                boolean simpleJar;
                String candidateName;
                block12: {
                    candidateName = candidates[i];
                    if (!candidateName.startsWith(target)) break block11;
                    simpleJar = false;
                    char c = versionSep = candidateName.length() > target.length() ? candidateName.charAt(target.length()) : (char)'\u0000';
                    if (candidateName.length() <= target.length() || versionSep == '_' || versionSep == '-') break block12;
                    if (candidateName.length() != 4 + target.length() || !candidateName.endsWith(".jar")) break block11;
                    simpleJar = true;
                }
                if ((currentVersion = EclipseStarter.getVersionElements(version = candidateName.length() > target.length() + 1 && (versionSep == '_' || versionSep == '-') ? candidateName.substring(target.length() + 1) : "")) != null && EclipseStarter.compareVersion(maxVersion, currentVersion) < 0) {
                    File candidate = new File(start, candidateName);
                    boolean candidateIsFile = candidate.isFile();
                    if (!simpleJar || candidateIsFile) {
                        result = candidate.getAbsolutePath();
                        resultIsFile = candidateIsFile;
                        maxVersion = currentVersion;
                    }
                }
            }
            ++i;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + (resultIsFile ? "" : "/");
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(-1), new Integer(-1), new Integer(-1), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i] = new Integer(token);
                }
                catch (Exception exception) {
                    if (i != 0) break;
                    return null;
                }
            } else {
                result[i] = token;
            }
            ++i;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        if (left == null) {
            return -1;
        }
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    public static void setInitialProperties(Map<String, String> initialProperties) {
        if (initialProperties == null || initialProperties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : initialProperties.entrySet()) {
            if (entry.getValue() != null) {
                EclipseStarter.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            EclipseStarter.clearProperty(entry.getKey());
        }
    }

    public static BundleContext getSystemBundleContext() {
        if (context == null || !running) {
            return null;
        }
        return context.getBundle().getBundleContext();
    }

    private static boolean isForcedRestart() {
        return Boolean.valueOf(EclipseStarter.getProperty("osgi.forcedRestart"));
    }

    static void internalAddFrameworkShutdownHandler(Runnable handler) {
        if (running) {
            throw new IllegalStateException(Msg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        if (shutdownHandlers == null) {
            shutdownHandlers = new ArrayList<Runnable>();
        }
        shutdownHandlers.add(handler);
    }

    static void internalRemoveFrameworkShutdownHandler(Runnable handler) {
        if (running) {
            throw new IllegalStateException(Msg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        if (shutdownHandlers != null) {
            shutdownHandlers.remove(handler);
        }
    }

    private static void registerFrameworkShutdownHandlers() {
        if (shutdownHandlers == null) {
            return;
        }
        final Bundle systemBundle = context.getBundle();
        for (final Runnable handler : shutdownHandlers) {
            BundleListener listener = new BundleListener(){

                @Override
                public void bundleChanged(BundleEvent event) {
                    if (event.getBundle() == systemBundle && event.getType() == 4) {
                        handler.run();
                    }
                }
            };
            context.addBundleListener(listener);
        }
    }

    private static class InitialBundle {
        public final String locationString;
        public final URL location;
        public final int level;
        public final boolean start;

        InitialBundle(String locationString, URL location, int level, boolean start) {
            this.locationString = locationString;
            this.location = location;
            this.level = level;
            this.start = start;
        }
    }

    static class StartupEventListener
    implements SynchronousBundleListener,
    FrameworkListener {
        private final Semaphore semaphore;
        private final int frameworkEventType;

        public StartupEventListener(Semaphore semaphore, int frameworkEventType) {
            this.semaphore = semaphore;
            this.frameworkEventType = frameworkEventType;
        }

        @Override
        public void bundleChanged(BundleEvent event) {
            if (event.getBundle().getBundleId() == 0L && event.getType() == 256) {
                this.semaphore.release();
            }
        }

        @Override
        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == this.frameworkEventType) {
                this.semaphore.release();
            }
        }
    }
}

