/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.tests.AbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class StringExpanderTests
extends AbstractTest {
    private final StringExpander expander = new WindowsStringExpander();

    @Test
    public void testNull() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString(null), (Matcher)StringExpanderTests.isNull());
    }

    @Test
    public void testVariable() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariableSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariableSlashSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path//}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\\\END"));
    }

    @Test
    public void testVariableSlashPipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/|}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariablePipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePipePipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path||}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePipeSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|/}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariableFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latestEND"));
    }

    @Test
    public void testVariableUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|unknown}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testVariableFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|property/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\wsEND"));
    }

    @Test
    public void testVariableUnresolvedFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|unknown/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testVariablePathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testVariablePathUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|unknown}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testUnresolvedVariable() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path}END"));
    }

    @Test
    public void testUnresolvedVariableFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|property}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|property}END"));
    }

    @Test
    public void testUnresolvedVariableUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|unknown}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|unknown}END"));
    }

    @Test
    public void testUnresolvedVariablePath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path/ws}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path/ws}END"));
    }

    @Test
    public void testUnresolvedVariableFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|property/ws}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|property/ws}END"));
    }

    @Test
    public void testUnresolvedVariablePathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path/ws|property}END"));
    }

    @Test
    public void testTwice() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testTwiceWithText() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}MIDDLE${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsMIDDLEC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testDollar() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$END"), (Matcher)StringExpanderTests.is((Object)"START$END"));
        MatcherAssert.assertThat((Object)this.expander.expandString("START$$END"), (Matcher)StringExpanderTests.is((Object)"START$END"));
    }

    @Test
    public void testEscaped() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path}END"));
    }

    @Test
    public void testEscaped_Bug473706() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${windows.path}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${windows.path}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>${}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$$$$${maven.build.timestamp}</timestamp>"));
    }

    @Test
    public void testEscapedPathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path/ws|property}END"));
    }

    @Test
    public void testEscapedPathFilterUnescaped() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path/ws|property}${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path/ws|property}C:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    private static final class WindowsStringExpander
    extends StringExpander {
        private final Map<String, String> variables = new HashMap<String, String>();

        public WindowsStringExpander() {
            this.variables.put("windows.path", "C:\\develop\\java-latest");
            this.variables.put("unix.path", "/develop/java-latest");
            this.variables.put("user.name", "stepper");
        }

        protected String getFileSeparator() {
            return "\\";
        }

        protected String resolve(String key) {
            return this.variables.get(key);
        }

        protected boolean isUnexpanded(String key) {
            return !this.variables.containsKey(key);
        }

        protected String filter(String value, String filterName) {
            if ("property".equals(filterName)) {
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
            return value;
        }
    }
}

