/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SyncActionType implements Enumerator
{
    NONE(0, "None", "None"),
    SET_LOCAL(1, "SetLocal", "SetLocal"),
    SET_REMOTE(2, "SetRemote", "SetRemote"),
    REMOVE(3, "Remove", "Remove"),
    CONFLICT(4, "Conflict", "Conflict"),
    EXCLUDE(5, "Exclude", "Exclude");

    public static final int NONE_VALUE = 0;
    public static final int SET_LOCAL_VALUE = 1;
    public static final int SET_REMOTE_VALUE = 2;
    public static final int REMOVE_VALUE = 3;
    public static final int CONFLICT_VALUE = 4;
    public static final int EXCLUDE_VALUE = 5;
    private static final SyncActionType[] VALUES_ARRAY;
    public static final List<SyncActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SyncActionType[]{NONE, SET_LOCAL, SET_REMOTE, REMOVE, CONFLICT, EXCLUDE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SyncActionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncActionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncActionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncActionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncActionType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SET_LOCAL;
            }
            case 2: {
                return SET_REMOTE;
            }
            case 3: {
                return REMOVE;
            }
            case 4: {
                return CONFLICT;
            }
            case 5: {
                return EXCLUDE;
            }
        }
        return null;
    }

    private SyncActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

