/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.predicates.PredicatesFactory;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsFactory;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;
import org.eclipse.oomph.workingsets.provider.WorkingSetsEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetItemProvider
extends ModelElementItemProvider {
    public WorkingSetItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addIDPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_WorkingSet_name_feature"), this.getString("_UI_WorkingSet_name_description"), (EStructuralFeature)WorkingSetsPackage.Literals.WORKING_SET__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_WorkingSet_iD_feature"), this.getString("_UI_WorkingSet_iD_description"), (EStructuralFeature)WorkingSetsPackage.Literals.WORKING_SET__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/WorkingSet"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((WorkingSet)object).getName();
        return label == null ? "" : label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(WorkingSet.class)) {
            case 1: {
                EObject notifier = (EObject)notification.getNotifier();
                TreeIterator it = EcoreUtil.getRootContainer((EObject)notifier).eAllContents();
                while (it.hasNext()) {
                    EObject child = (EObject)it.next();
                    for (EObject reference : child.eCrossReferences()) {
                        if (reference != notifier) continue;
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)child, false, true));
                    }
                }
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)notifier, false, true));
                return;
            }
            case 3: {
                Object notifier = notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notifier, false, true));
                return;
            }
            case 2: {
                Object notifier = notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notifier, true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, WorkingSetsFactory.eINSTANCE.createInclusionPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, WorkingSetsFactory.eINSTANCE.createExclusionPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createNamePredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createCommentPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createLocationPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createRepositoryPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createAndPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createOrPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createNotPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createNaturePredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createBuilderPredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createFilePredicate()));
        newChildDescriptors.add(this.createChildParameter(WorkingSetsPackage.Literals.WORKING_SET__PREDICATES, PredicatesFactory.eINSTANCE.createImportedPredicate()));
    }

    public ResourceLocator getResourceLocator() {
        return WorkingSetsEditPlugin.INSTANCE;
    }
}

