/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.oomph.version.ui.Activator;
import org.eclipse.oomph.version.ui.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction<ARGS>
implements IObjectActionDelegate {
    protected Shell shell;
    protected ISelection selection;
    private String jobName;

    public AbstractAction(String jobName) {
        this.jobName = jobName;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        try {
            final ARGS arguments = this.promptArguments();
            if (arguments != null) {
                new Job(this.jobName){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                public void run(IProgressMonitor monitor) throws CoreException {
                                    AbstractAction.this.runWithArguments(arguments);
                                }
                            }, monitor);
                            return Status.OK_STATUS;
                        }
                        catch (CoreException ex) {
                            return ex.getStatus();
                        }
                    }
                }.schedule();
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
            MessageDialog.openError((Shell)this.shell, (String)Messages.AbstractAction_error_title, (String)Messages.AbstractAction_error_message);
        }
    }

    protected abstract ARGS promptArguments();

    protected abstract void runWithArguments(ARGS var1) throws CoreException;
}

