/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.impl;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.oomph.internal.resources.ExternalProject;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.resources.ResourcesPackage;
import org.eclipse.oomph.resources.XMLProjectFactory;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.impl.Messages;
import org.eclipse.oomph.resources.impl.ProjectFactoryImpl;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public abstract class XMLProjectFactoryImpl
extends ProjectFactoryImpl
implements XMLProjectFactory {
    protected XMLProjectFactoryImpl() {
    }

    protected EClass eStaticClass() {
        return ResourcesPackage.Literals.XML_PROJECT_FACTORY;
    }

    public final IProject doCreateProject(BackendContainer rootContainer, BackendContainer backendContainer, IProgressMonitor monitor) {
        Path xmlFilePath = new Path(this.getXMLFileName());
        BackendFile xmlFile = null;
        try {
            xmlFile = backendContainer.getFile((IPath)xmlFilePath);
            byte[] bytes = xmlFile.getContentBytes(monitor);
            if (bytes.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)bais);
                ExternalProject.Description description = new ExternalProject.Description(backendContainer);
                this.fillDescription(description, rootElement);
                return new ExternalProject(backendContainer, description);
            }
        }
        catch (FileNotFoundException bytes) {
        }
        catch (Exception ex) {
            String message = NLS.bind((String)Messages.XMLProjectFactoryImpl_ProblemParsing_exception, (Object)(xmlFile != null ? xmlFile : xmlFilePath));
            ResourcesPlugin.INSTANCE.log(new Exception(message, ex));
        }
        return null;
    }

    protected abstract String getXMLFileName();

    protected abstract void fillDescription(ExternalProject.Description var1, Element var2) throws Exception;
}

