/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.text.CollationKey;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class DeltaMarkerEntry
extends MarkerEntry {
    private IMarkerDelta markerDelta;

    public DeltaMarkerEntry(IMarkerDelta markerDelta) {
        super(markerDelta.getMarker());
        this.markerDelta = markerDelta;
    }

    @Override
    Object getAttributeValue(String attribute) {
        Object value = this.getCache().get(attribute);
        if (value == null && (value = this.markerDelta.getAttribute(attribute)) != null) {
            this.getCache().put(attribute, value);
        }
        if (value instanceof CollationKey) {
            return ((CollationKey)value).getSourceString();
        }
        return value;
    }

    @Override
    long getCreationTime() {
        return super.getCreationTime();
    }

    @Override
    long getID() {
        return this.markerDelta.getId();
    }

    @Override
    String getMarkerTypeName() {
        return MarkerTypesModel.getInstance().getType(this.markerDelta.getType()).getLabel();
    }

    @Override
    public String getPath() {
        String folder = this.getAttributeValue("org.eclipse.ui.views.markers.path", null);
        if (folder != null) {
            return folder;
        }
        IPath path = this.markerDelta.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return super.getPath();
        }
        folder = path.removeLastSegments(1).removeTrailingSeparator().toString();
        this.getCache().put("org.eclipse.ui.views.markers.path", folder);
        return folder;
    }
}

