/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleTranslationProvider {
    private ResourceBundle resourceBundle;

    public ResourceBundleTranslationProvider(ResourceBundle resourceBundle) {
        this.setResourceBundle(resourceBundle);
    }

    public String translate(String key) {
        String result = this.translate_rec(key);
        if (result != null) {
            return result;
        }
        return "!" + key + "!";
    }

    private String translate_rec(String key) {
        String result;
        block4: {
            result = null;
            try {
                if (this.resourceBundle != null) {
                    result = this.resourceBundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (key.matches(".*[A-Z].*")) {
                    result = this.translate_rec(ResourceBundleTranslationProvider.underscorify(key));
                }
                if (result != null || !key.contains("_")) break block4;
                result = this.translate_rec(key.replace('_', '.'));
            }
        }
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static String underscorify(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < key.length()) {
            if (Character.isUpperCase(key.charAt(i))) {
                result.append("_").append(Character.toLowerCase(key.charAt(i)));
            } else {
                result.append(key.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }
}

