/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumUtilities;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public class RecreateRepositoryApplication
extends AbstractApplication {
    private static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private URI repoLocation;
    private String repoName = null;
    boolean removeArtifactRepo = true;
    private Map<String, String> repoProperties = null;
    private Map<IArtifactKey, IArtifactDescriptor[]> repoMap = null;

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        try {
            IArtifactRepository repository = this.initialize(monitor);
            this.removeRepository(repository, monitor);
            this.recreateRepository(monitor);
        }
        finally {
            if (this.removeArtifactRepo) {
                IArtifactRepositoryManager repositoryManager = this.getArtifactRepositoryManager();
                repositoryManager.removeRepository(this.repoLocation);
            }
        }
        return Status.OK_STATUS;
    }

    public void setArtifactRepository(URI repository) {
        this.repoLocation = repository;
    }

    private IArtifactRepository initialize(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager repositoryManager = this.getArtifactRepositoryManager();
        this.removeArtifactRepo = !repositoryManager.contains(this.repoLocation);
        IArtifactRepository repository = repositoryManager.loadRepository(this.repoLocation, 1, monitor);
        if (repository == null || !repository.isModifiable()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_destinationNotModifiable, (Object)repository.getLocation()));
        }
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        this.repoName = repository.getName();
        this.repoProperties = repository.getProperties();
        this.repoMap = new HashMap<IArtifactKey, IArtifactDescriptor[]>();
        IQueryResult keys = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(key);
            this.repoMap.put(key, descriptors);
        }
        return repository;
    }

    private void removeRepository(IArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
        manager.removeRepository(repository.getLocation());
        boolean compressed = Boolean.parseBoolean(this.repoProperties.get("p2.compressed"));
        URI realLocation = SimpleArtifactRepository.getActualLocation((URI)repository.getLocation(), (boolean)compressed);
        File realFile = URIUtil.toFile((URI)realLocation);
        if (!realFile.exists() || !realFile.delete()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_unableToRemoveRepo, (Object)realFile.toString()));
        }
    }

    private void recreateRepository(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
        HashMap<String, String> newProperties = new HashMap<String, String>(this.repoProperties);
        newProperties.put(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
        IArtifactRepository repository = manager.createRepository(this.repoLocation, this.repoName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", newProperties);
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        IFileArtifactRepository simple = (IFileArtifactRepository)repository;
        for (IArtifactKey key : this.repoMap.keySet()) {
            IArtifactDescriptor[] descriptors = this.repoMap.get(key);
            String unpackedSize = null;
            File packFile = null;
            HashSet<File> files = new HashSet<File>();
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                File artifactFile = simple.getArtifactFile(descriptor);
                files.add(artifactFile);
                String size = Long.toString(artifactFile.length());
                ArtifactDescriptor newDescriptor = new ArtifactDescriptor(descriptor);
                newDescriptor.setProperty("artifact.size", size);
                newDescriptor.setProperty("download.size", size);
                HashMap checksums = new HashMap();
                List checksumsToSkip = Collections.emptyList();
                IStatus status = ChecksumUtilities.calculateChecksums((File)artifactFile, checksums, checksumsToSkip);
                if (!status.isOK()) {
                    LogHelper.log((IStatus)status);
                }
                Map checksumsToProperties = ChecksumUtilities.checksumsToProperties((String)"download.checksum", checksums);
                newDescriptor.addProperties(checksumsToProperties);
                File temp = new File(artifactFile.getParentFile(), String.valueOf(artifactFile.getName()) + ".pack.gz");
                if (temp.exists()) {
                    packFile = temp;
                    unpackedSize = size;
                }
                repository.addDescriptor((IArtifactDescriptor)newDescriptor, null);
                ++n2;
            }
            if (packFile == null || files.contains(packFile) || packFile.length() <= 0L) continue;
            ArtifactDescriptor packDescriptor = this.createPack200ArtifactDescriptor(key, packFile, unpackedSize);
            repository.addDescriptor((IArtifactDescriptor)packDescriptor, null);
        }
    }

    @Deprecated(forRemoval=true, since="2.3.0")
    private ArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File packFile, String installSize) {
        if (packFile != null && packFile.exists()) {
            ArtifactDescriptor result = new ArtifactDescriptor(key);
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(packFile.length()));
            IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
            result.setProcessingSteps(steps);
            result.setProperty("format", "packed");
            return result;
        }
        return null;
    }
}

