/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.DelegatingLabelDecorator;
import org.eclipse.oomph.ui.LabelDecorator;
import org.eclipse.oomph.ui.Messages;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PropertiesViewer
extends TableViewer {
    private TableColumn propertyColumn;
    private TableColumn valueColumn;
    private ControlAdapter columnResizer;
    private DelegatingLabelDecorator labelDecorator = new DelegatingLabelDecorator();

    public PropertiesViewer(Composite parent, int style) {
        this(parent, style, (AdapterFactory)BaseEditUtil.createAdapterFactory());
    }

    public PropertiesViewer(Composite parent, int style, AdapterFactory adapterFactory) {
        super(parent, style | 0x100 | 0x200 | 0x10000);
        final Table table = this.getTable();
        UIUtil.applyGridData((Control)table).heightHint = 64;
        this.setLabelProvider((IBaseLabelProvider)new DecoratingPropertiesLabelProvider(new PropertiesLabelProvider(), this.labelDecorator, (Control)table));
        this.setContentProvider((IContentProvider)new PropertiesContentProvider(adapterFactory));
        this.propertyColumn = new TableColumn(table, 0);
        this.propertyColumn.setText(Messages.PropertiesViewer_propertyColumn);
        this.propertyColumn.setWidth(200);
        this.propertyColumn.setResizable(false);
        this.valueColumn = new TableColumn(table, 0);
        this.valueColumn.setText(Messages.PropertiesViewer_valueColumn);
        this.valueColumn.setWidth(400);
        this.valueColumn.setResizable(false);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.columnResizer = new ControlAdapter(){
            private boolean resizing;

            public void controlResized(ControlEvent e) {
                if (!this.resizing) {
                    try {
                        table.setRedraw(false);
                        this.resizing = true;
                        Rectangle clientArea = table.getClientArea();
                        int clientWidth = clientArea.width - clientArea.x;
                        TableItem[] items = table.getItems();
                        if (items.length == 0) {
                            PropertiesViewer.this.propertyColumn.setWidth(clientWidth / 2);
                            PropertiesViewer.this.valueColumn.setWidth(clientWidth - clientWidth / 2);
                        } else {
                            PropertiesViewer.this.propertyColumn.pack();
                            int propertyColumnWidth = PropertiesViewer.this.propertyColumn.getWidth();
                            PropertiesViewer.this.propertyColumn.setWidth(propertyColumnWidth += 20);
                            PropertiesViewer.this.valueColumn.pack();
                            int valueColumnWidth = PropertiesViewer.this.valueColumn.getWidth();
                            if (propertyColumnWidth + valueColumnWidth < clientWidth) {
                                PropertiesViewer.this.valueColumn.setWidth(clientWidth - propertyColumnWidth);
                            }
                        }
                    }
                    finally {
                        table.setRedraw(true);
                        this.resizing = false;
                    }
                }
            }
        };
        table.addControlListener((ControlListener)this.columnResizer);
        UIUtil.asyncExec((Control)table, new Runnable(){

            @Override
            public void run() {
                PropertiesViewer.this.columnResizer.controlResized(null);
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                final Object[] element = (Object[])selection.getFirstElement();
                if (element != null && (element[5] != null || element[1] != null)) {
                    final String value = (String)(element[5] == null ? element[1] : element[5]);
                    UIUtil.asyncExec((Control)table, new Runnable(){

                        @Override
                        public void run() {
                            InformationPopupDialog popupDialog = new InformationPopupDialog(table.getShell(), (String)element[0], value);
                            popupDialog.open();
                        }
                    });
                }
            }
        });
    }

    public DelegatingLabelDecorator getDelegatingLabelDecorator() {
        return this.labelDecorator;
    }

    private final class DecoratingPropertiesLabelProvider
    extends DecoratingColumLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private PropertiesLabelProvider propertiesLabelProvider;
        private LabelDecorator labelDecorator;
        private Control control;

        public DecoratingPropertiesLabelProvider(PropertiesLabelProvider labelProvider, LabelDecorator labelDecorator, Control control) {
            super((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator);
            this.propertiesLabelProvider = labelProvider;
            this.labelDecorator = labelDecorator;
            this.control = control;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.propertiesLabelProvider.getColumnImage(element, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.propertiesLabelProvider.getColumnText(element, columnIndex);
        }

        public Font getFont(Object element, int columnIndex) {
            return this.labelDecorator.decorateFont(this.control.getFont(), ((Object[])element)[4]);
        }

        public Color getForeground(Object element, int columnIndex) {
            return this.labelDecorator.decorateForeground(this.control.getForeground(), ((Object[])element)[4]);
        }

        public Color getBackground(Object element, int columnIndex) {
            return this.labelDecorator.decorateBackground(this.control.getBackground(), ((Object[])element)[4]);
        }
    }

    private final class InformationPopupDialog
    extends PopupDialog {
        private final String content;

        public InformationPopupDialog(Shell parent, String titleText, String content) {
            super(parent, 16, true, true, true, true, false, titleText, null);
            this.content = content;
        }

        protected void showDialogMenu() {
            super.showDialogMenu();
            if (Util.isGtk()) {
                UIUtil.asyncExec((Control)this.getShell(), new Runnable(){

                    @Override
                    public void run() {
                        ReflectUtil.setValue((String)"listenToDeactivate", (Object)((Object)InformationPopupDialog.this), (Object)true);
                    }
                });
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            StyledText text = new StyledText(composite, 778);
            text.setAlwaysShowScrollBars(false);
            Dialog.applyDialogFont((Control)text);
            StringBuilder minimalText = new StringBuilder();
            int i = 0;
            while (i < 6) {
                int j = 0;
                while (j < 30) {
                    minimalText.append('M');
                    ++j;
                }
                minimalText.append('\n');
                ++i;
            }
            text.setText(minimalText.toString());
            Point size = text.computeSize(-1, -1);
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = size.x;
            data.heightHint = size.y;
            text.setLayoutData((Object)data);
            text.setText(this.content);
            return composite;
        }

        protected IDialogSettings getDialogSettings() {
            return UIPlugin.INSTANCE.getDialogSettings("InformationPopup");
        }
    }

    private final class PropertiesContentProvider
    implements IStructuredContentProvider {
        private final AdapterFactory adapterFactory;
        private final AdapterFactoryItemDelegator itemDelegator;

        public PropertiesContentProvider(AdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
            this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
        }

        public void dispose() {
            if (this.adapterFactory instanceof IDisposable) {
                ((IDisposable)this.adapterFactory).dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            UIUtil.asyncExec(viewer.getControl(), new Runnable(){

                @Override
                public void run() {
                    ((PropertiesContentProvider)PropertiesContentProvider.this).PropertiesViewer.this.columnResizer.controlResized(null);
                }
            });
        }

        public Object[] getElements(Object element) {
            ArrayList<Object> properties = new ArrayList<Object>();
            ArrayList<Object[]> expertProperties = new ArrayList<Object[]>();
            List propertyDescriptors = this.itemDelegator.getPropertyDescriptors(element);
            if (propertyDescriptors != null) {
                for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Object propertyValue;
                    String displayName = propertyDescriptor.getDisplayName(element);
                    IItemLabelProvider propertyLabelProvider = propertyDescriptor.getLabelProvider(element);
                    Object imageURL = propertyLabelProvider.getImage(propertyValue = this.itemDelegator.getEditableValue(propertyDescriptor.getPropertyValue(element)));
                    Image image = imageURL == null ? null : ExtendedImageRegistry.INSTANCE.getImage(imageURL);
                    String valueText = propertyLabelProvider.getText(propertyValue);
                    if (StringUtil.isEmpty((String)valueText)) {
                        valueText = "";
                    }
                    EStructuralFeature.Setting setting = null;
                    String fullValueText = null;
                    Object feature = propertyDescriptor.getFeature(element);
                    if (feature instanceof EStructuralFeature) {
                        EAttribute eAttribute;
                        EDataType eDataType;
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)feature;
                        Object object = AdapterFactoryEditingDomain.unwrap((Object)element);
                        if (object instanceof EObject) {
                            setting = ((InternalEObject)object).eSetting(eStructuralFeature);
                        }
                        if (propertyValue != null && eStructuralFeature instanceof EAttribute && (eDataType = (eAttribute = (EAttribute)eStructuralFeature).getEAttributeType()).isSerializable()) {
                            if (eAttribute.isMany()) {
                                List values = (List)propertyValue;
                                StringBuilder result = new StringBuilder();
                                for (Object item : values) {
                                    String stringValue = EcoreUtil.convertToString((EDataType)eDataType, item);
                                    if (stringValue == null) continue;
                                    if (result.length() != 0) {
                                        result.append(StringUtil.NL);
                                    }
                                    result.append(stringValue);
                                }
                                fullValueText = result.toString();
                            } else {
                                fullValueText = EcoreUtil.convertToString((EDataType)eDataType, (Object)propertyValue);
                            }
                        }
                    }
                    if (this.isExpertProperty(propertyDescriptor, element)) {
                        expertProperties.add(new Object[]{displayName, valueText, image, true, setting, fullValueText});
                        continue;
                    }
                    properties.add(new Object[]{displayName, valueText, image, false, setting, fullValueText});
                }
            }
            properties.addAll(expertProperties);
            return properties.toArray();
        }

        private boolean isExpertProperty(IItemPropertyDescriptor propertyDescriptor, Object element) {
            String[] filterFlags = propertyDescriptor.getFilterFlags(element);
            if (filterFlags != null) {
                String[] stringArray = filterFlags;
                int n = filterFlags.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterFlag = stringArray[n2];
                    if (PropertiesUtil.EXPERT_FILTER[0].equals(filterFlag)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private final class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return (Image)((Object[])element)[2];
            }
            return null;
        }
    }
}

