/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.provider.P2EditPlugin;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PatternFilter;

public class OpenDiscoveredType
extends OomphDialog {
    public static final String TITLE = Messages.OpenDiscoveredType_title;
    public static final String MESSAGE = Messages.OpenDiscoveredType_message;
    private static final String GIT_INDICES = PropertiesUtil.getProperty((String)"oomph.git.index", (String)"https://download.eclipse.org/oomph/git/git-index.zip");
    private final DockableDialog.Dockable dockable = new DockableDialog.Dockable((Dialog)this);
    private final IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
    private Item selectedItem;
    private String selectedLink;
    private ExtendedFilteredTree filteredTree;
    private TreeViewer masterViewer;
    private TreeViewer detailsViewer;
    private Job detailsLoadJob;
    private Map<String, URI> repositoryProjectSetups;
    private final ItemFilter filter = new ItemFilter();

    public OpenDiscoveredType(Shell parentShell) {
        super(parentShell, TITLE, 700, 500, (OomphUIPlugin)SetupEditorPlugin.INSTANCE, true);
        this.setShellStyle(this.getShellStyle() ^ 0x10000 | 0x10 | 0x400 | (OS.INSTANCE.isWin() ? 128 : 0));
        this.setBlockOnOpen(false);
    }

    public String getHelpPath() {
        return String.valueOf(SetupEditorPlugin.INSTANCE.getSymbolicName()) + "/html/OpenInTypeBrowserHelp.html";
    }

    public DockableDialog.Dockable getDockable() {
        return this.dockable;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return String.valueOf(MESSAGE) + ".";
    }

    protected String getImagePath() {
        return "full/wizban/BrowseType";
    }

    protected int getContainerMargin() {
        return 10;
    }

    private void setSelectedLink(String selectedLink) {
        Button button = this.getButton(0);
        button.setEnabled(selectedLink != null);
        this.selectedLink = selectedLink;
    }

    private void setSelectedItem(Item item) {
        this.selectedItem = item;
        this.setSelectedLink(item != null && item.getName() != null && item.getName().startsWith("http") ? item.getName() : null);
    }

    protected void createUI(Composite composite) {
        this.getShell().setImage(SetupEditorPlugin.INSTANCE.getSWTImage("BrowseType"));
        SashForm sashForm = new SashForm(composite, 66048);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite treeComposite = new Composite((Composite)sashForm, 0);
        treeComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Composite filterComposite = new Composite(treeComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText(Messages.OpenDiscoveredType_collapseAllButton_tooltip);
        collapseAllButton.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("collapse-all"));
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenDiscoveredType.this.masterViewer.collapseAll();
            }
        });
        this.filter.setIncludeLeadingWildcard(true);
        this.filteredTree = new ExtendedFilteredTree(treeComposite, 2048, this.filter, this.filter);
        this.filteredTree.setExpansionCount(100);
        Control filterControl = this.filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        this.masterViewer = this.filteredTree.getViewer();
        ColumnViewerInformationControlToolTipSupport toolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.masterViewer, (LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (event.location != null && !event.location.startsWith("about:")) {
                    event.doit = false;
                    OpenDiscoveredType.this.openProjectImporter(URI.createURI((String)event.location));
                }
            }
        });
        this.masterViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.masterViewer, toolTipSupport)));
        this.masterViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.masterViewer.setUseHashlookup(true);
        Tree masterTree = this.masterViewer.getTree();
        masterTree.setLayoutData((Object)new GridData(1808));
        this.masterViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OpenDiscoveredType.this.masterViewer.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                boolean expanded = OpenDiscoveredType.this.masterViewer.getExpandedState((Object)item);
                OpenDiscoveredType.this.masterViewer.setExpandedState((Object)item, !expanded);
                if (item.getType() == Item.Type.PACKAGE) {
                    block0: while (item != null) {
                        for (Item child : item.getItems()) {
                            if (!OpenDiscoveredType.this.filter.isElementVisible((Viewer)OpenDiscoveredType.this.masterViewer, (Object)child)) continue;
                            item = child;
                            if (child.getType() == Item.Type.CLASS) break block0;
                            OpenDiscoveredType.this.masterViewer.setExpandedState((Object)child, true);
                            continue block0;
                        }
                    }
                    OpenDiscoveredType.this.masterViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                }
            }
        });
        this.masterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                OpenDiscoveredType.this.loadDetails(item);
                OpenDiscoveredType.this.setSelectedItem(null);
            }
        });
        Composite detailsComposite = new Composite((Composite)sashForm, 0);
        detailsComposite.setLayout((Layout)new FillLayout());
        detailsComposite.setForeground(masterTree.getForeground());
        detailsComposite.setBackground(masterTree.getBackground());
        this.detailsViewer = new TreeViewer(detailsComposite);
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.detailsViewer, null)));
        this.detailsViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                OpenDiscoveredType.this.setSelectedItem(item);
            }
        });
        this.detailsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (OpenDiscoveredType.this.selectedLink != null) {
                    OpenDiscoveredType.this.openURL(OpenDiscoveredType.this.getOpenLinkStyle());
                }
            }
        });
        List<OomphTransferDelegate> dndDelegates = Arrays.asList(new OomphTransferDelegate.URLTransferDelegate(), new OomphTransferDelegate.TextTransferDelegate());
        Transfer[] dndTransfers = new Transfer[]{dndDelegates.get(0).getTransfer(), dndDelegates.get(1).getTransfer()};
        this.detailsViewer.addDragSupport(7, dndTransfers, (DragSourceListener)new GeneralDragAdapter((Viewer)this.detailsViewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item;
                    String name;
                    Object object = objectArray[n2];
                    if (object instanceof Item && (name = (item = (Item)((Object)object)).getName()) != null && name.startsWith("http")) {
                        result.add(name);
                    }
                    ++n2;
                }
                return result;
            }
        }, dndDelegates));
        Menu menu = this.detailsViewer.getControl().getMenu();
        MenuManager contextMenu = (MenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey");
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                if (OpenDiscoveredType.this.selectedLink != null) {
                    boolean internalWebBrowserAvailable = OpenDiscoveredType.this.browserSupport.isInternalWebBrowserAvailable();
                    OpenLinkStyle openLinkStyle = OpenDiscoveredType.this.getOpenLinkStyle();
                    manager.add((IAction)new Action(Messages.OpenDiscoveredType_action_openInExtBrowser, internalWebBrowserAvailable, openLinkStyle){
                        {
                            if (bl) {
                                this.setChecked(openLinkStyle == OpenLinkStyle.EXTERNAL);
                            }
                        }

                        public void run() {
                            OpenDiscoveredType.this.openURL(OpenLinkStyle.EXTERNAL);
                        }
                    });
                    if (internalWebBrowserAvailable) {
                        manager.add((IAction)new Action(Messages.OpenDiscoveredType_action_openInEditor, openLinkStyle){
                            {
                                this.setChecked(openLinkStyle == OpenLinkStyle.EDITOR);
                            }

                            public void run() {
                                OpenDiscoveredType.this.openURL(OpenLinkStyle.EDITOR);
                            }
                        });
                        manager.add((IAction)new Action(Messages.OpenDiscoveredType_action_openInView, openLinkStyle){
                            {
                                this.setChecked(openLinkStyle == OpenLinkStyle.VIEW);
                            }

                            public void run() {
                                OpenDiscoveredType.this.openURL(OpenLinkStyle.VIEW);
                            }
                        });
                    }
                    if (OpenDiscoveredType.this.selectedItem.rawLinks != null && OpenDiscoveredType.this.selectedItem.rawLinks.get(OpenDiscoveredType.this.selectedLink) != null) {
                        manager.add((IAction)new Action(Messages.OpenDiscoveredType_action_openInJavaEditor, openLinkStyle){
                            {
                                this.setChecked(openLinkStyle == OpenLinkStyle.JAVA);
                            }

                            public void run() {
                                OpenDiscoveredType.this.openURL(OpenLinkStyle.JAVA);
                            }
                        });
                    }
                    if (OpenDiscoveredType.this.repositoryProjectSetups != null) {
                        manager.add((IContributionItem)new Separator());
                        for (final URI projectSetupURI : OpenDiscoveredType.this.getProjectSetups(OpenDiscoveredType.this.selectedItem)) {
                            manager.add((IAction)new Action(NLS.bind((String)Messages.OpenDiscoveredType_action_openInImportProjectsWizard, (Object)projectSetupURI.lastSegment())){

                                public void run() {
                                    OpenDiscoveredType.this.openProjectImporter(projectSetupURI);
                                }
                            });
                        }
                    }
                }
            }
        });
        sashForm.setWeights(new int[]{14, 5});
        UIUtil.asyncExec((Control)composite, (Runnable)new Runnable(){

            @Override
            public void run() {
                OpenDiscoveredType.this.setSelectedItem(null);
            }
        });
        this.loadModel();
    }

    private void openProjectImporter(URI projectSetupURI) {
        SetupWizard.Importer wizard = new SetupWizard.Importer();
        wizard.setProject(projectSetupURI);
        wizard.openDialog(this.getParentShell());
    }

    private List<URI> getProjectSetups(Item item) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (this.repositoryProjectSetups != null) {
            for (String repo : item.getRepos()) {
                URI uri = this.repositoryProjectSetups.get(repo);
                if (uri == null && repo.endsWith(".git")) {
                    uri = this.repositoryProjectSetups.get(repo.substring(0, repo.length() - 4));
                }
                if (uri == null || result.contains(uri)) continue;
                result.add(uri);
            }
        }
        return result;
    }

    private void decorate(Item item) {
        EList<Item> items = item.getItems();
        HashSet<String> decorations = new HashSet<String>();
        ArrayList<Item> visibleChildren = new ArrayList<Item>();
        for (Item child : items) {
            if (!this.filter.isElementVisible((Viewer)this.masterViewer, (Object)child)) continue;
            visibleChildren.add(child);
            this.decorate(child);
            decorations.add(child.getDecoration());
        }
        if (visibleChildren.isEmpty()) {
            LinkedHashSet<String> labels = new LinkedHashSet<String>();
            for (URI projectSetupURI : this.getProjectSetups(item)) {
                labels.add(projectSetupURI.lastSegment());
            }
            if (!labels.isEmpty()) {
                StringBuilder decoration = new StringBuilder();
                for (String label : labels) {
                    if (decoration.length() != 0) {
                        decoration.append(' ');
                    }
                    decoration.append(label);
                }
                item.setDecoration(decoration.toString());
            } else {
                item.setDecoration(null);
            }
        } else if (decorations.size() == 1 && !decorations.contains(null)) {
            if (item.getType() != Item.Type.ROOT) {
                item.setDecoration((String)decorations.iterator().next());
                for (Item child : visibleChildren) {
                    child.setDecoration(null);
                }
            }
        } else {
            item.setDecoration(null);
        }
    }

    protected void loadModel() {
        Item root = Item.createRootItem();
        root.getChildren().add((Object)Item.createPlaceholderItem());
        this.masterViewer.setInput((Object)root);
        Job job = new Job(Messages.OpenDiscoveredType_gitIndexLoaderJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                final Item root = Item.createRootItem();
                Item packageItem = null;
                SegmentSequence qualifiedName = null;
                ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                for (String gitIndex : StringUtil.explode((String)GIT_INDICES, (String)" ", (char)'\u0000')) {
                    ZipInputStream zipInputStream = null;
                    try {
                        String link = null;
                        String rawLink = null;
                        String repo = null;
                        String repoLink = null;
                        String rawRepoLink = null;
                        String sourceFolder = null;
                        String sourceFolderLink = null;
                        String rawSourceFolderLink = null;
                        String packageName = null;
                        String className = null;
                        zipInputStream = new ZipInputStream(resourceSet.getURIConverter().createInputStream(URI.createURI((String)gitIndex)));
                        if (zipInputStream.getNextEntry() == null) continue;
                        List lines = IOUtil.readLines((InputStream)zipInputStream, (String)"UTF-8");
                        for (String line : lines) {
                            if (line.startsWith("    ")) {
                                className = line.trim();
                                Item classItem = packageItem.getItem(className);
                                if (classItem == null) {
                                    classItem = Item.create(Item.Type.CLASS, qualifiedName.append(className).toString());
                                    classItem.itemFilter = OpenDiscoveredType.this.filter;
                                    packageItem.getChildren().add((Object)classItem);
                                }
                                classItem.addLink(rawSourceFolderLink, sourceFolderLink, repo, repoLink);
                                continue;
                            }
                            if (line.startsWith("   ")) {
                                packageName = line.trim();
                                SegmentSequence segments = SegmentSequence.create((String)".", (String)packageName);
                                qualifiedName = SegmentSequence.create((String)".");
                                Item item = root;
                                String[] stringArray = segments.segments();
                                int n = stringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String segment = stringArray[n2];
                                    qualifiedName = qualifiedName.append(segment);
                                    packageItem = item.getItem(segment);
                                    if (packageItem == null) {
                                        packageItem = Item.create(Item.Type.PACKAGE, qualifiedName.toString());
                                        packageItem.itemFilter = OpenDiscoveredType.this.filter;
                                        item.getChildren().add((Object)packageItem);
                                    }
                                    packageItem.addLink(sourceFolderLink, repo, repoLink);
                                    item = packageItem;
                                    ++n2;
                                }
                                continue;
                            }
                            if (line.startsWith("  ")) {
                                sourceFolder = line.trim();
                                sourceFolderLink = repoLink.replace("${1}", String.valueOf(sourceFolder) + "/${1}");
                                if (rawRepoLink == null) {
                                    rawSourceFolderLink = null;
                                    continue;
                                }
                                rawSourceFolderLink = rawRepoLink.replace("${1}", String.valueOf(sourceFolder) + "/${1}");
                                continue;
                            }
                            if (line.startsWith(" ")) {
                                repo = line.trim();
                                repoLink = link.replace("${0}", repo);
                                if (rawLink == null) {
                                    rawRepoLink = null;
                                    continue;
                                }
                                rawRepoLink = rawLink.replace("${0}", repo);
                                continue;
                            }
                            List links = StringUtil.explode((String)line, (String)" ", (char)'\u0000');
                            link = (String)links.get(0);
                            rawLink = links.size() > 1 ? (String)links.get(1) : null;
                        }
                    }
                    catch (Exception ex) {
                        IOUtil.close(zipInputStream);
                    }
                }
                root.sort();
                UIUtil.asyncExec((Control)OpenDiscoveredType.this.masterViewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).OpenDiscoveredType.this.masterViewer.setInput((Object)root);
                        (this).OpenDiscoveredType.this.filteredTree.textChanged();
                    }
                });
                HashMap<String, URI> remoteURIs = new HashMap<String, URI>();
                Resource resource = resourceSet.getResource(SetupContext.INDEX_SETUP_URI, true);
                TreeIterator it = resource.getAllContents();
                while (it.hasNext()) {
                    URI uri;
                    URI oldURI;
                    String remoteURI;
                    EStructuralFeature eStructuralFeature;
                    EObject eObject = (EObject)it.next();
                    EClass eClass = eObject.eClass();
                    if (!"GitCloneTask".equals(eClass.getName()) || (eStructuralFeature = eClass.getEStructuralFeature("remoteURI")) == null || (remoteURI = (String)eObject.eGet(eStructuralFeature)) == null) continue;
                    Scope scope = ((SetupTask)eObject).getScope();
                    if (scope instanceof Stream) {
                        scope = scope.getParentScope();
                    }
                    if (!(scope instanceof Project) || (oldURI = remoteURIs.put(remoteURI, uri = EcoreUtil.getURI((EObject)scope))) == null) continue;
                    if (oldURI.toString().contains(remoteURI)) {
                        remoteURIs.put(remoteURI, oldURI);
                        continue;
                    }
                    int index = remoteURI.indexOf("/");
                    if (index == -1 || !oldURI.toString().toLowerCase().contains(remoteURI.substring(0, index).toLowerCase())) continue;
                    remoteURIs.put(remoteURI, oldURI);
                }
                OpenDiscoveredType.this.repositoryProjectSetups = remoteURIs;
                if (!OpenDiscoveredType.this.masterViewer.getControl().isDisposed()) {
                    try {
                        OpenDiscoveredType.this.decorate(root);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                UIUtil.asyncExec((Control)OpenDiscoveredType.this.masterViewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).OpenDiscoveredType.this.masterViewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void loadDetails(final Item item) {
        if (this.detailsLoadJob != null) {
            this.detailsLoadJob.cancel();
        }
        if (item == null) {
            this.detailsViewer.setInput(null);
        } else {
            Item root = Item.createRootItem();
            root.getChildren().add((Object)Item.createPlaceholderItem());
            this.detailsViewer.setInput((Object)root);
        }
        this.detailsLoadJob = new Job(Messages.OpenDiscoveredType_detailLoaderJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                if (item != null) {
                    final Item input = Item.createRootItem();
                    Item javaItem = Item.create(item.getType(), item.getName());
                    input.getChildren().add((Object)javaItem);
                    HashMap<String, Set<String>> unfilteredGroups = new HashMap<String, Set<String>>();
                    this.collectUnfilteredGroups(unfilteredGroups, item);
                    EList children = javaItem.getChildren();
                    Item.Type type = item.getType();
                    Item.Type linkType = type == Item.Type.CLASS ? Item.Type.CLASS_LINK : Item.Type.PACKAGE_LINK;
                    int count = 0;
                    HashMap<String, String> rawLinks = type == Item.Type.CLASS ? new HashMap<String, String>() : null;
                    Map<String, Map<String, Set<String>>> groupLinks = item.getGroupLinks(unfilteredGroups, rawLinks);
                    for (Map.Entry<String, Map<String, Set<String>>> groupEntry : groupLinks.entrySet()) {
                        String repoLink = groupEntry.getKey();
                        Item groupLinkItem = Item.create(Item.Type.FOLDER_LINK, repoLink);
                        ++count;
                        children.add((Object)groupLinkItem);
                        EList<Item> groupChildren = groupLinkItem.getItems();
                        Map<String, Set<String>> links = groupEntry.getValue();
                        for (Map.Entry<String, Set<String>> entry : links.entrySet()) {
                            String link = entry.getKey();
                            Item linkItem = Item.create(linkType, link);
                            linkItem.setText(link.replace(repoLink, ""));
                            ++count;
                            groupChildren.add((Object)linkItem);
                            for (String repo : entry.getValue()) {
                                linkItem.addLink(repo, repo, "");
                                groupLinkItem.addLink(repo, repo, "");
                                linkItem.rawLinks = rawLinks;
                            }
                        }
                        OpenDiscoveredType.this.decorate(groupLinkItem);
                        if (monitor.isCanceled()) break;
                    }
                    if (!monitor.isCanceled()) {
                        input.sort();
                        final int limit = count;
                        UIUtil.asyncExec((Control)OpenDiscoveredType.this.detailsViewer.getControl(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                (this).OpenDiscoveredType.this.detailsViewer.setInput((Object)input);
                                (this).OpenDiscoveredType.this.detailsViewer.expandToLevel(limit > 1000 ? 2 : 3);
                            }
                        });
                    }
                }
                if (!OpenDiscoveredType.this.masterViewer.getControl().isDisposed()) {
                    try {
                        Item root = (Item)((Object)OpenDiscoveredType.this.masterViewer.getInput());
                        OpenDiscoveredType.this.decorate(root);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                UIUtil.asyncExec((Control)OpenDiscoveredType.this.masterViewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).OpenDiscoveredType.this.masterViewer.refresh(true);
                    }
                });
                return Status.OK_STATUS;
            }

            public void collectUnfilteredGroups(Map<String, Set<String>> groups, Item item2) {
                boolean hasVisibleChildren = false;
                for (Item child : item2.getItems()) {
                    if (!OpenDiscoveredType.this.filter.select((Viewer)OpenDiscoveredType.this.detailsViewer, (Object)item2, (Object)child)) continue;
                    hasVisibleChildren = true;
                    this.collectUnfilteredGroups(groups, child);
                }
                if (!hasVisibleChildren) {
                    for (Map.Entry<String, Map<String, Set<String>>> entry : item2.groupLinks.entrySet()) {
                        CollectionUtil.addAll(groups, (Object)entry.getKey(), entry.getValue().keySet());
                    }
                }
            }
        };
        this.detailsLoadJob.setSystem(true);
        this.detailsLoadJob.schedule();
    }

    protected void okPressed() {
        super.okPressed();
        this.openURL(this.getOpenLinkStyle());
    }

    private void setOpenLinkStyle(OpenLinkStyle style) {
        OomphPlugin.Preference instancePreference = SetupEditorPlugin.INSTANCE.getInstancePreference((Object)((Object)this.selectedItem.getType()) + ".open.style");
        instancePreference.set(style.name());
    }

    private OpenLinkStyle getOpenLinkStyle() {
        OomphPlugin.Preference instancePreference = SetupEditorPlugin.INSTANCE.getInstancePreference((Object)((Object)this.selectedItem.getType()) + ".open.style");
        String name = instancePreference.get("VIEW");
        try {
            return OpenLinkStyle.valueOf(OpenLinkStyle.class, name);
        }
        catch (Exception ex) {
            return OpenLinkStyle.VIEW;
        }
    }

    private void openURL(OpenLinkStyle openLinkStyle) {
        try {
            this.setOpenLinkStyle(openLinkStyle);
            String id = "org.eclipse.oomph.setup.type.browser";
            int style = 0;
            switch (openLinkStyle) {
                case EDITOR: {
                    id = String.valueOf(id) + ".editor";
                    style = 32;
                    break;
                }
                case EXTERNAL: {
                    style = 128;
                    id = String.valueOf(id) + ".external";
                    break;
                }
                case VIEW: {
                    style = 64;
                    id = String.valueOf(id) + ".view";
                    break;
                }
                case JAVA: {
                    String rawLink = this.selectedItem.rawLinks.get(this.selectedLink);
                    class OpenJavaEditorJob
                    extends Job {
                        private IOException ioException;
                        private byte[] bytes;
                        private final /* synthetic */ String val$rawLink;

                        public OpenJavaEditorJob(String string) {
                            this.val$rawLink = string;
                            super(NLS.bind((String)Messages.OpenDiscoveredType_openJavaEditorJob_name, (Object)string));
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            block5: {
                                InputStream in = null;
                                try {
                                    try {
                                        URL url = new URL(this.val$rawLink);
                                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                                        in = url.openStream();
                                        IOUtil.copy((InputStream)in, (OutputStream)out);
                                        this.bytes = out.toByteArray();
                                    }
                                    catch (IOException ex) {
                                        this.ioException = ex;
                                        IOUtil.closeSilent(in);
                                        break block5;
                                    }
                                }
                                catch (Throwable throwable) {
                                    IOUtil.closeSilent(in);
                                    throw throwable;
                                }
                                IOUtil.closeSilent((Closeable)in);
                            }
                            UIUtil.asyncExec((Control)OpenDiscoveredType.this.getShell(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        class StorageEditorInput
                                        implements IStorageEditorInput {
                                            private final /* synthetic */ String val$rawLink;

                                            StorageEditorInput(String string) {
                                                this.val$rawLink = string;
                                            }

                                            public Object getAdapter(Class adapter) {
                                                return null;
                                            }

                                            public String getToolTipText() {
                                                return this.val$rawLink;
                                            }

                                            public IPersistableElement getPersistable() {
                                                return null;
                                            }

                                            public String getName() {
                                                return URI.createURI((String)this.val$rawLink).lastSegment();
                                            }

                                            public ImageDescriptor getImageDescriptor() {
                                                return null;
                                            }

                                            public boolean exists() {
                                                return true;
                                            }

                                            public IStorage getStorage() throws CoreException {
                                                return new IStorage(){

                                                    public Object getAdapter(Class adapter) {
                                                        return null;
                                                    }

                                                    public boolean isReadOnly() {
                                                        return true;
                                                    }

                                                    public String getName() {
                                                        return URI.createURI((String)val$rawLink).lastSegment();
                                                    }

                                                    public IPath getFullPath() {
                                                        return new Path(val$rawLink);
                                                    }

                                                    public InputStream getContents() throws CoreException {
                                                        if (ioException != null) {
                                                            SetupUIPlugin.INSTANCE.coreException((Throwable)ioException);
                                                            return null;
                                                        }
                                                        return new ByteArrayInputStream(bytes);
                                                    }
                                                };
                                            }
                                        }
                                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                                        int n = iEditorReferenceArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IEditorPart editor;
                                            IEditorReference editorReference = iEditorReferenceArray[n2];
                                            IEditorInput editorInput = editorReference.getEditorInput();
                                            if (editorInput instanceof StorageEditorInput && val$rawLink.equals(((StorageEditorInput)editorInput).getToolTipText()) && (editor = editorReference.getEditor(true)) != null) {
                                                page.activate((IWorkbenchPart)editor);
                                                return;
                                            }
                                            ++n2;
                                        }
                                        page.openEditor((IEditorInput)new StorageEditorInput(val$rawLink), "org.eclipse.jdt.ui.CompilationUnitEditor", true, 3);
                                    }
                                    catch (PartInitException ex) {
                                        SetupEditorPlugin.INSTANCE.log(ex);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    }
                    new OpenJavaEditorJob(rawLink).schedule();
                    return;
                }
            }
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = support.createBrowser(style | 2 | 4, id, this.selectedLink, this.selectedLink);
            browser.openURL(new URL(this.selectedLink));
        }
        catch (Exception ex) {
            SetupEditorPlugin.INSTANCE.log(ex);
        }
    }

    public static OpenDiscoveredType getFor(IWorkbenchWindow workbenchWindow) {
        return (OpenDiscoveredType)DockableDialog.getFor(OpenDiscoveredType.class, (IWorkbenchWindow)workbenchWindow);
    }

    public static void closeFor(IWorkbenchWindow workbenchWindow) {
        DockableDialog.closeFor(OpenDiscoveredType.class, (IWorkbenchWindow)workbenchWindow);
    }

    public static OpenDiscoveredType openFor(IWorkbenchWindow workbenchWindow) {
        DockableDialog.Factory<OpenDiscoveredType> factory = new DockableDialog.Factory<OpenDiscoveredType>(){

            public OpenDiscoveredType create(IWorkbenchWindow workbenchWindow) {
                return new OpenDiscoveredType(workbenchWindow.getShell());
            }
        };
        return (OpenDiscoveredType)DockableDialog.openFor(OpenDiscoveredType.class, (DockableDialog.Factory)factory, (IWorkbenchWindow)workbenchWindow);
    }

    private final class ExtendedFilteredTree
    extends FilteredTreeWithoutWorkbench {
        private ExtendedFilteredTree(Composite parent, int style, PatternFilter patternFilter, FilteredTreeWithoutWorkbench.ExpansionFilter expansionFilter) {
            super(parent, style, patternFilter, expansionFilter);
        }

        protected void refreshed() {
            OpenDiscoveredType.this.masterViewer.setSelection(OpenDiscoveredType.this.masterViewer.getSelection());
        }

        public void textChanged() {
            super.textChanged();
        }
    }

    private static class Item
    extends ItemProvider {
        private static final StyledString.Style BOLD_STYLER = StyledString.Style.newBuilder().setFont(IItemFontProvider.BOLD_FONT).toStyle();
        private static final Comparator<String> STRING_COMPARATOR = CommonPlugin.INSTANCE.getComparator();
        private static final Comparator<Item> COMPARATOR = new Comparator<Item>(){

            @Override
            public int compare(Item item1, Item item2) {
                int result = item1.getType().compareTo(item2.getType());
                return result == 0 ? STRING_COMPARATOR.compare(item1.getText(), item2.getText()) : result;
            }
        };
        private static final Image FOLDER_IMAGE = SetupEditorPlugin.INSTANCE.getSWTImage("obj16/folder");
        private static final Image JAVA_CLASS_IMAGE = SetupEditorPlugin.INSTANCE.getSWTImage("full/obj16/JavaCompilationUnit");
        private static final Image JAVA_PACKAGE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Package"));
        private static final Image SETUP_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(SetupEditorPlugin.INSTANCE.getImage("full/obj16/SetupModelFile"));
        private Type type;
        private String name;
        private String decoration;
        private Map<String, Map<String, Set<String>>> groupLinks = new TreeMap<String, Map<String, Set<String>>>();
        private Map<String, String> rawLinks;
        private ItemFilter itemFilter;

        private Item(Type type, String name) {
            super(type.getText(name), (Object)Item.getImage(type));
            this.type = type;
            this.name = name;
        }

        public String getDecoration() {
            return this.decoration;
        }

        public void setDecoration(String decoration) {
            this.decoration = decoration;
        }

        public void addLink(String rawSourceFolderLink, String sourceFolderLink, String gitRepo, String repoLink) {
            if (rawSourceFolderLink != null) {
                if (this.rawLinks == null) {
                    this.rawLinks = new HashMap<String, String>();
                }
                this.rawLinks.put(sourceFolderLink, rawSourceFolderLink);
            }
            this.addLink(sourceFolderLink, gitRepo, repoLink);
        }

        public void addLink(String sourceFolderLink, String gitRepo, String repoLink) {
            Map<String, Set<String>> map = this.groupLinks.get(repoLink);
            if (map == null) {
                map = new TreeMap<String, Set<String>>();
                this.groupLinks.put(repoLink, map);
            }
            CollectionUtil.add(map, (Object)sourceFolderLink, (Object)gitRepo);
        }

        public Map<String, Map<String, Set<String>>> getGroupLinks(Map<String, Set<String>> filter, Map<String, String> rawLinks) {
            LinkedHashMap<String, Map<String, Set<String>>> result = new LinkedHashMap<String, Map<String, Set<String>>>();
            for (Map.Entry<String, Map<String, Set<String>>> groupEntry : this.groupLinks.entrySet()) {
                String key = groupEntry.getKey();
                Set<String> sourceLinks = filter.get(key);
                if (sourceLinks == null) continue;
                LinkedHashMap<String, Set<String>> links = new LinkedHashMap<String, Set<String>>();
                String path = this.type == Type.CLASS ? String.valueOf(this.name.replace('.', '/')) + ".java" : this.name.replace('.', '/');
                for (Map.Entry<String, Set<String>> entry : groupEntry.getValue().entrySet()) {
                    String rawLink;
                    String link = entry.getKey();
                    if (!sourceLinks.contains(link)) continue;
                    String javaLink = link.replace("${1}", path);
                    links.put(javaLink, entry.getValue());
                    if (rawLinks == null || this.rawLinks == null || (rawLink = this.rawLinks.get(link)) == null) continue;
                    String rawJavaLink = rawLink.replace("${1}", path);
                    rawLinks.put(javaLink, rawJavaLink);
                }
                if (links.isEmpty()) continue;
                String repoLink = key.replace("${1}", "/").replace("://", ":////").replace("//", "/");
                result.put(repoLink, links);
            }
            return result;
        }

        public Set<String> getRepos() {
            TreeSet<String> result = new TreeSet<String>();
            for (Map.Entry<String, Map<String, Set<String>>> groupEntry : this.groupLinks.entrySet()) {
                for (Map.Entry<String, Set<String>> entry : groupEntry.getValue().entrySet()) {
                    result.addAll((Collection<String>)entry.getValue());
                }
            }
            return result;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public static Item create(Type type, String name) {
            return new Item(type, name);
        }

        public static Item createRootItem() {
            return new Item(Type.ROOT, Messages.OpenDiscoveredType_rootItem_name);
        }

        public static Item createPlaceholderItem() {
            return new Item(Type.PLACEHOLDER, Messages.OpenDiscoveredType_placeHolderItem_name);
        }

        public Object getStyledText(Object object) {
            if (this.itemFilter != null && this.itemFilter.pattern != null) {
                Matcher matcher = this.itemFilter.pattern.matcher(this.name);
                boolean patternMatches = matcher.matches();
                if (!patternMatches && this.type == Type.PACKAGE && this.itemFilter.packagePattern != null) {
                    matcher = this.itemFilter.packagePattern.matcher(this.name);
                    patternMatches = matcher.matches();
                }
                if (patternMatches) {
                    StyledString styledLabel = new StyledString();
                    int groupCount = matcher.groupCount();
                    StringBuilder styleRun = null;
                    boolean previousMatches = false;
                    int i = this.name.length() - this.text.length();
                    while (i < this.name.length()) {
                        boolean matches = false;
                        int j = 1;
                        while (j <= groupCount) {
                            int start = matcher.start(j);
                            int end = matcher.end(j);
                            if (i >= start && i < end) {
                                matches = true;
                                break;
                            }
                            ++j;
                        }
                        if (previousMatches != matches) {
                            if (styleRun != null) {
                                if (previousMatches) {
                                    styledLabel.append(styleRun.toString(), BOLD_STYLER);
                                } else {
                                    styledLabel.append(styleRun.toString());
                                }
                                styleRun = null;
                            }
                            previousMatches = matches;
                        }
                        if (styleRun == null) {
                            styleRun = new StringBuilder();
                        }
                        styleRun.append(this.name.charAt(i));
                        ++i;
                    }
                    if (styleRun != null) {
                        if (previousMatches) {
                            styledLabel.append(styleRun.toString(), BOLD_STYLER);
                        } else {
                            styledLabel.append(styleRun.toString());
                        }
                    }
                    if (this.decoration != null) {
                        styledLabel.append(" - " + this.decoration, StyledString.Style.DECORATIONS_STYLER);
                    }
                    return styledLabel;
                }
            }
            if (this.decoration != null) {
                StyledString styledLabel = new StyledString();
                styledLabel.append(this.getText());
                styledLabel.append(" - " + this.decoration, StyledString.Style.DECORATIONS_STYLER);
                return styledLabel;
            }
            return super.getStyledText(object);
        }

        public Item getParent() {
            return (Item)((Object)super.getParent());
        }

        public EList<Item> getItems() {
            EList children = this.getChildren();
            return children;
        }

        public Item getItem(String text) {
            for (Item item : this.getItems()) {
                if (!text.equals(item.getText())) continue;
                return item;
            }
            return null;
        }

        public void sort() {
            EList<Item> children = this.getItems();
            ECollections.sort(children, COMPARATOR);
            for (Item child : children) {
                child.sort();
            }
        }

        private static Image getImage(Type type) {
            switch (type) {
                case CLASS: 
                case CLASS_LINK: {
                    return JAVA_CLASS_IMAGE;
                }
                case FOLDER_LINK: {
                    return FOLDER_IMAGE;
                }
                case PACKAGE: 
                case PACKAGE_LINK: {
                    return JAVA_PACKAGE_IMAGE;
                }
            }
            return null;
        }

        private static enum Type {
            PLACEHOLDER,
            ROOT,
            PACKAGE{

                @Override
                public String getText(String name) {
                    int index = name.lastIndexOf(46);
                    return index == -1 ? name : name.substring(index + 1);
                }
            }
            ,
            CLASS{

                @Override
                public String getText(String name) {
                    int index = name.lastIndexOf(46);
                    return index == -1 ? name : name.substring(index + 1);
                }
            }
            ,
            FOLDER_LINK,
            PACKAGE_LINK,
            CLASS_LINK;


            public String getText(String name) {
                return name;
            }
        }
    }

    private final class ItemFilter
    extends PatternFilter
    implements FilteredTreeWithoutWorkbench.ExpansionFilter {
        private Pattern pattern;
        private Pattern packagePattern;

        private ItemFilter() {
        }

        public void setPattern(String patternString) {
            if (OpenDiscoveredType.this.detailsLoadJob != null) {
                OpenDiscoveredType.this.detailsLoadJob.cancel();
                int i = 0;
                while (i < 100 && OpenDiscoveredType.this.detailsLoadJob.getState() != 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            super.setPattern(patternString);
            if (patternString == null) {
                this.pattern = null;
            } else {
                StringBuilder patternLiteral = new StringBuilder();
                if (StringUtil.trimLeft((String)patternString).equals(patternString)) {
                    patternLiteral.append(".*?");
                }
                ArrayList<Integer> packageIndices = new ArrayList<Integer>();
                boolean previousUpperCase = false;
                boolean grouped = false;
                int i = Character.offsetByCodePoints(patternString, 0, 0);
                int length = patternString.length();
                while (i < length) {
                    int codePoint = patternString.codePointAt(i);
                    if (Character.isJavaIdentifierStart(codePoint) || Character.isJavaIdentifierPart(codePoint)) {
                        boolean bothUpperCase;
                        boolean upperCase = Character.isUpperCase(codePoint);
                        boolean bl = bothUpperCase = previousUpperCase && upperCase;
                        if (bothUpperCase) {
                            if (grouped) {
                                patternLiteral.append(')');
                            }
                            int lowerCaseCodePoint = Character.toLowerCase(codePoint);
                            patternLiteral.append("(?:[^\\p{Lu}&&[^").appendCodePoint(lowerCaseCodePoint).append("]]*(").appendCodePoint(codePoint).append(")|(").appendCodePoint(lowerCaseCodePoint).append("))");
                            if (grouped) {
                                patternLiteral.append('(');
                            }
                        }
                        if (!grouped) {
                            grouped = true;
                            patternLiteral.append('(');
                        }
                        if (!bothUpperCase) {
                            patternLiteral.appendCodePoint(codePoint);
                        }
                        previousUpperCase = upperCase;
                    } else if (codePoint == 42) {
                        if (i != 0) {
                            if (grouped) {
                                patternLiteral.append(").*?(");
                            } else {
                                patternLiteral.append(".*?");
                            }
                            previousUpperCase = false;
                        }
                    } else if (codePoint == 63) {
                        if (grouped) {
                            patternLiteral.append(").(");
                        } else {
                            patternLiteral.append(".");
                        }
                        previousUpperCase = false;
                    } else if (!Character.isWhitespace(codePoint)) {
                        if (grouped) {
                            patternLiteral.append(')');
                            packageIndices.add(patternLiteral.length());
                            patternLiteral.append('(');
                        }
                        patternLiteral.append(Pattern.quote(new String(Character.toChars(codePoint))));
                        if (!grouped) {
                            grouped = true;
                            patternLiteral.append('(');
                        }
                        previousUpperCase = false;
                    } else if (i + 1 != length) {
                        previousUpperCase = false;
                    }
                    i = Character.offsetByCodePoints(patternString, i, 1);
                }
                if (grouped) {
                    patternLiteral.append(')');
                }
                if (previousUpperCase) {
                    patternLiteral.append("[^\\p{Lu}]*");
                }
                if (StringUtil.trimRight((String)patternString).equals(patternString)) {
                    patternLiteral.append(".*");
                } else {
                    patternLiteral.append('$');
                }
                this.pattern = Pattern.compile(patternLiteral.toString());
                if (!packageIndices.isEmpty()) {
                    int last = packageIndices.size() - 1;
                    patternLiteral.delete((Integer)packageIndices.get(last), patternLiteral.length());
                    int i2 = last;
                    while (i2 > 0) {
                        patternLiteral.insert((int)((Integer)packageIndices.get(i2)), "?");
                        --i2;
                    }
                    this.packagePattern = Pattern.compile(patternLiteral.toString());
                } else {
                    this.packagePattern = null;
                }
            }
        }

        protected boolean wordMatches(String text) {
            if (this.pattern == null) {
                return true;
            }
            if (text == null) {
                return false;
            }
            return this.pattern.matcher(text).matches();
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            Item item = (Item)((Object)element);
            String text = item.getName();
            if (text == null) {
                text = item.getText();
            }
            return this.wordMatches(text);
        }

        public boolean shouldExpand(Object element) {
            return !this.isLeafMatch(null, element);
        }
    }

    private static enum OpenLinkStyle {
        EXTERNAL,
        EDITOR,
        VIEW,
        JAVA;

    }

    private class ToolTipLabelProvider
    extends DecoratingColumLabelProvider.StyledLabelProvider {
        private final ColumnViewerInformationControlToolTipSupport toolTipSupport;

        public ToolTipLabelProvider(AdapterFactory adapterFactory, Viewer viewer, ColumnViewerInformationControlToolTipSupport toolTipSupport) {
            super((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, viewer), (ILabelDecorator)new IStyledLabelDecorator(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String decorateText(String text, Object element) {
                    return text;
                }

                public Image decorateImage(Image image, Object element) {
                    return image;
                }

                public org.eclipse.jface.viewers.StyledString decorateStyledText(org.eclipse.jface.viewers.StyledString styledString, Object element) {
                    return styledString;
                }
            });
            this.toolTipSupport = toolTipSupport;
        }

        public String getToolTipText(Object element) {
            Item item = (Item)((Object)element);
            StringBuilder result = new StringBuilder();
            result.append("<span style='white-space: nowrap;'>");
            result.append(DiagnosticDecorator.enquote((String)("<img style='padding-right: 2pt; margin-top: 2px; margin-bottom: -2pt;' src='" + ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage(item.getImage())) + "'/> ")));
            result.append(URI.decode((String)item.getName()));
            result.append("</span>");
            List<URI> projectSetups = OpenDiscoveredType.this.getProjectSetups(item);
            String decoration = item.getDecoration();
            Item parent = item.getParent();
            while (decoration == null && parent != null) {
                decoration = parent.getDecoration();
                parent = parent.getParent();
            }
            if (decoration != null && decoration.indexOf(32) == -1) {
                Iterator<URI> it = projectSetups.iterator();
                while (it.hasNext()) {
                    URI uri = it.next();
                    if (decoration.equals(uri.lastSegment())) continue;
                    it.remove();
                }
            }
            if (!projectSetups.isEmpty()) {
                HashSet<URI> uris = new HashSet<URI>();
                for (URI uri : projectSetups) {
                    uris.add(uri.trimFragment());
                }
                if (uris.size() == 1) {
                    projectSetups.clear();
                    projectSetups.add(((URI)uris.iterator().next()).trimFragment().appendFragment("/"));
                }
            }
            if (projectSetups.size() == 1) {
                URI projectSetupURI = projectSetups.get(0);
                result.append("<br/>");
                result.append("<span style='white-space: nowrap;'>");
                result.append(String.valueOf(DiagnosticDecorator.enquote((String)("<img style='padding-right: 2pt; margin-top: 2px; margin-bottom: -2pt;' src='" + ImageURIRegistry.INSTANCE.getImageURI(Item.SETUP_IMAGE)))) + "'/> ");
                result.append("<a href=\"");
                result.append(projectSetupURI);
                result.append("\">");
                result.append(projectSetupURI.lastSegment());
                result.append("</a>");
                result.append("</span>");
            }
            String toolTip = result.toString();
            AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)this.toolTipSupport);
            Point size = UIUtil.caclcuateSize((String)toolTip);
            hoverInformationControlManager.setSizeConstraints(size.x + 4, size.y + 1, true, false);
            return result.toString();
        }
    }
}

