/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.actions.SimpleWildcardTester;

public class MarkerPropertyTester
extends PropertyTester {
    public static final String PRIORITY = "priority";
    public static final String SEVERITY = "severity";
    public static final String DONE = "done";
    public static final String MESSAGE = "message";
    public static final String TYPE = "type";
    public static final String SUPER_TYPE = "superType";
    public static final String RESOURCE_TYPE = "resourceType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return MarkerPropertyTester.test((IMarker)receiver, property, expectedValue.toString());
    }

    private static boolean testIntegerAttribute(IMarker marker, String attrName, String value) {
        Integer i2;
        Integer i1;
        try {
            i1 = (Integer)marker.getAttribute(attrName);
            if (i1 == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        try {
            i2 = Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return i1.equals(i2);
    }

    public static boolean test(IMarker marker, String attributeName, String expectedValue) {
        if (TYPE.equals(attributeName)) {
            try {
                return expectedValue.equals(marker.getType());
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (SUPER_TYPE.equals(attributeName)) {
            try {
                return marker.isSubtypeOf(expectedValue);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (PRIORITY.equals(attributeName)) {
            return MarkerPropertyTester.testIntegerAttribute(marker, PRIORITY, expectedValue);
        }
        if (SEVERITY.equals(attributeName)) {
            return MarkerPropertyTester.testIntegerAttribute(marker, SEVERITY, expectedValue);
        }
        if (MESSAGE.equals(attributeName)) {
            String msg;
            block20: {
                try {
                    msg = (String)marker.getAttribute(MESSAGE);
                    if (msg != null) break block20;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return SimpleWildcardTester.testWildcardIgnoreCase((String)expectedValue, (String)msg);
        }
        if (DONE.equals(attributeName)) {
            Boolean done;
            block21: {
                try {
                    expectedValue = expectedValue.toLowerCase();
                    done = (Boolean)marker.getAttribute(DONE);
                    if (done != null) break block21;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return done.booleanValue() == expectedValue.equals("true");
        }
        if (RESOURCE_TYPE.equals(attributeName)) {
            int desiredType = 0;
            try {
                desiredType = Integer.parseInt(expectedValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (desiredType != 1 && desiredType != 2 && desiredType != 4 && desiredType != 8) {
                return false;
            }
            return (marker.getResource().getType() & desiredType) > 0;
        }
        return false;
    }
}

