/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.oomph.base.provider.BaseEditPlugin;
import org.eclipse.oomph.setup.internal.core.StringFilterRegistry;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class SetupCorePlugin
extends OomphPlugin {
    private static final String DEFAULT_UPDATE_URL = "https://download.eclipse.org/oomph/updates/milestone/latest";
    public static final String UPDATE_URL = PropertiesUtil.getProperty((String)"oomph.update.url", (String)"https://download.eclipse.org/oomph/updates/milestone/latest").replace('\\', '/');
    public static final SetupCorePlugin INSTANCE = new SetupCorePlugin();
    private static Implementation plugin;

    public SetupCorePlugin() {
        super(new ResourceLocator[]{BaseEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public Map<String, String> getImplicitWorkspaceVariables() {
        return SetupCorePlugin.getImplicitVariables(this.getInstancePreferences().node("variables"));
    }

    public void setImplicitWorkspaceVariables(Map<String, String> implicitVariables) {
        SetupCorePlugin.setImplicitVariables(this.getInstancePreferences().node("variables"), implicitVariables);
    }

    public Map<String, String> getImplicitInstallationVariables() {
        return SetupCorePlugin.getImplicitVariables(this.getConfigurationPreferences().node("variables"));
    }

    public void setImplicitInstallationVariables(Map<String, String> implicitVariables) {
        SetupCorePlugin.setImplicitVariables(this.getConfigurationPreferences().node("variables"), implicitVariables);
    }

    private static Map<String, String> getImplicitVariables(Preferences variables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            String[] stringArray = variables.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = variables.get(key, null);
                if (value != null) {
                    result.put(key, value);
                }
                ++n2;
            }
        }
        catch (BackingStoreException ex) {
            INSTANCE.log(ex);
        }
        return result;
    }

    private static void setImplicitVariables(Preferences variables, Map<String, String> implicitVariables) {
        try {
            String[] stringArray = variables.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                variables.remove(key);
                ++n2;
            }
            for (Map.Entry<String, String> entry : implicitVariables.entrySet()) {
                variables.put(entry.getKey(), entry.getValue());
            }
            variables.flush();
        }
        catch (BackingStoreException ex) {
            INSTANCE.log(ex);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            StringFilterRegistry.INSTANCE.initContributions();
        }
    }
}

