/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.PreloadingRepositoryHandler;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RemedyConfig;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UpdateHandler
extends PreloadingRepositoryHandler {
    boolean hasNoRepos = false;
    UpdateOperation operation;

    @Override
    protected void doExecute(LoadMetadataRepositoryJob job) {
        if (this.hasNoRepos) {
            boolean goToSites;
            if (this.getProvisioningUI().getPolicy().getRepositoriesVisible() && (goToSites = MessageDialog.openQuestion((Shell)this.getShell(), (String)ProvSDKMessages.UpdateHandler_NoSitesTitle, (String)ProvSDKMessages.UpdateHandler_NoSitesMessage))) {
                this.getProvisioningUI().manipulateRepositories(this.getShell());
            }
            return;
        }
        job.reportAccumulatedStatus();
        if (this.getProvisioningUI().getPolicy().continueWorkingWithOperation((ProfileChangeOperation)this.operation, this.getShell())) {
            if (this.operation.getResolutionResult() == Status.OK_STATUS) {
                this.getProvisioningUI().openUpdateWizard(false, this.operation, job);
            } else {
                final RemediationOperation remediationOperation = new RemediationOperation(this.getProvisioningUI().getSession(), this.operation.getProfileChangeRequest(), RemedyConfig.getCheckForUpdateRemedyConfigs());
                ProvisioningJob job2 = new ProvisioningJob(ProvSDKMessages.RemediationOperation_ResolveJobName, this.getProvisioningUI().getSession()){

                    public IStatus runModal(IProgressMonitor monitor) {
                        monitor.beginTask(ProvSDKMessages.RemediationOperation_ResolveJobTask, RemedyConfig.getAllRemedyConfigs().length);
                        return remediationOperation.resolveModal(monitor);
                    }
                };
                job2.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (PlatformUI.isWorkbenchRunning()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                                int n = UpdateHandler.this.getProvisioningUI().openUpdateWizard(true, UpdateHandler.this.operation, remediationOperation, null);
                            });
                        }
                    }
                });
                this.getProvisioningUI().schedule(job2, 3);
            }
        }
    }

    @Override
    protected void doPostLoadBackgroundWork(IProgressMonitor monitor) throws OperationCanceledException {
        this.operation = this.getProvisioningUI().getUpdateOperation(null, null);
        IStatus resolveStatus = this.operation.resolveModal(monitor);
        if (resolveStatus.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
    }

    @Override
    protected boolean preloadRepositories() {
        this.hasNoRepos = false;
        RepositoryTracker repoMan = this.getProvisioningUI().getRepositoryTracker();
        if (repoMan.getKnownRepositories(this.getProvisioningUI().getSession()).length == 0) {
            this.hasNoRepos = true;
            return false;
        }
        return super.preloadRepositories();
    }

    @Override
    protected String getProgressTaskName() {
        return ProvSDKMessages.UpdateHandler_ProgressTaskName;
    }
}

