/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.util.table;

import java.text.Format;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.oomph.internal.util.table.AbstractRange;
import org.eclipse.oomph.internal.util.table.Coordinate;
import org.eclipse.oomph.internal.util.table.Formula;
import org.eclipse.oomph.internal.util.table.Generator;
import org.eclipse.oomph.internal.util.table.Range;
import org.eclipse.oomph.internal.util.table.Table;

public final class Cell
extends AbstractRange {
    final Table table;
    int col;
    int row;
    Object value;
    Format format;
    Range.Alignment alignment;

    Cell(Table table, int col, int row) {
        this.table = table;
        this.col = col;
        this.row = row;
    }

    @Override
    public Table table() {
        return this.table;
    }

    public int col() {
        return this.col;
    }

    public int row() {
        return this.row;
    }

    public Coordinate coordinate() {
        return new Coordinate(this.col, this.row);
    }

    @Override
    public Cell offset(int cols, int rows) {
        return this.table.cell(this.coordinate().offset(cols, rows));
    }

    public Object value() {
        if (this.value instanceof Formula) {
            Formula formula = (Formula)this.value;
            return formula.evaluate();
        }
        return this.value;
    }

    @Override
    public Cell value(Object value) {
        if (value instanceof Generator) {
            Generator generator = (Generator)value;
            value = generator.nextValue();
        }
        this.value = value;
        return this;
    }

    public Object unevaluated() {
        return this.value;
    }

    public Number number() {
        Object value = this.value();
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    public Formula formula() {
        if (this.value instanceof Formula) {
            return (Formula)this.value;
        }
        return null;
    }

    public Cell formula(String formula) {
        return this;
    }

    public Format format() {
        return this.format;
    }

    @Override
    public Range format(Format format) {
        this.format = format;
        return this;
    }

    public Range.Alignment alignment() {
        return this.alignment;
    }

    @Override
    public Range alignment(Range.Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public Iterator<Cell> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + this.row;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || Cell.class != obj.getClass()) {
            return false;
        }
        Cell other = (Cell)obj;
        return this.col == other.col && this.row == other.row;
    }

    public String toString() {
        return "Cell" + this.coordinate() + " = " + this.value;
    }

    String applyFormat(Object value) {
        try {
            if (this.format != null) {
                return this.format.format(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    Range.Alignment alignmentFor(Object value) {
        if (this.alignment == null) {
            if (value instanceof Number) {
                return Range.Alignment.RIGHT;
            }
            return Range.Alignment.LEFT;
        }
        return this.alignment;
    }

    public static interface Visitor {
        public boolean visit(Cell var1, int var2) throws Exception;
    }
}

