/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.bouncycastle.pqc.crypto.picnic.KMatrices;
import org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.bouncycastle.util.Exceptions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LowmcConstantsL1
extends LowmcConstants {
    LowmcConstantsL1() {
        InputStream inputStream = LowmcConstants.class.getResourceAsStream("lowmcL1.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw Exceptions.illegalStateException("unable to load Picnic properties: " + iOException.getMessage(), iOException);
        }
        this.linearMatrices = LowmcConstantsL1.ReadFromProperty(properties, "linearMatrices", 40960);
        this.roundConstants = LowmcConstantsL1.ReadFromProperty(properties, "roundConstants", 320);
        this.keyMatrices = LowmcConstantsL1.ReadFromProperty(properties, "keyMatrices", 43008);
        this.LMatrix = new KMatrices(20, 128, 4, this.linearMatrices);
        this.KMatrix = new KMatrices(21, 128, 4, this.keyMatrices);
        this.RConstants = new KMatrices(0, 1, 4, this.roundConstants);
        this.linearMatrices_full = LowmcConstantsL1.ReadFromProperty(properties, "linearMatrices_full", 12800);
        this.keyMatrices_full = LowmcConstantsL1.ReadFromProperty(properties, "keyMatrices_full", 12900);
        this.keyMatrices_inv = LowmcConstantsL1.ReadFromProperty(properties, "keyMatrices_inv", 2850);
        this.linearMatrices_inv = LowmcConstantsL1.ReadFromProperty(properties, "linearMatrices_inv", 12800);
        this.roundConstants_full = LowmcConstantsL1.ReadFromProperty(properties, "roundConstants_full", 80);
        this.LMatrix_full = new KMatrices(4, 129, 5, this.linearMatrices_full);
        this.LMatrix_inv = new KMatrices(4, 129, 5, this.linearMatrices_inv);
        this.KMatrix_full = new KMatrices(5, 129, 5, this.keyMatrices_full);
        this.KMatrix_inv = new KMatrices(1, 129, 5, this.keyMatrices_inv);
        this.RConstants_full = new KMatrices(4, 1, 5, this.roundConstants_full);
    }
}

