/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;

class DPIUtil {
    static final int DPI_ZOOM_200 = 192;
    static final int DPI_ZOOM_150 = 144;

    DPIUtil() {
    }

    static int mapDPIToZoom(int dpi) {
        int zoom = dpi >= 192 ? 200 : (dpi >= 144 ? 150 : 100);
        return zoom;
    }

    static String validateAndGetImagePathAtZoom(ImageFileNameProvider provider, int zoom, boolean[] found) {
        String filename;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (filename = provider.getImagePath(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            filename = provider.getImagePath(100);
        }
        if (filename == null) {
            SWT.error(5);
        }
        return filename;
    }

    static ImageData validateAndGetImageDataAtZoom(ImageDataProvider provider, int zoom, boolean[] found) {
        ImageData data;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (data = provider.getImageData(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            data = provider.getImageData(100);
        }
        if (data == null) {
            SWT.error(5);
        }
        return data;
    }
}

