/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public abstract class ButtonAnimator
implements Runnable {
    private final OomphUIPlugin plugin;
    private final ToolItem button;
    private final String imagePrefix;
    protected final int additionalImages;
    private final boolean rotate;
    private int index;
    private boolean backward;
    protected Image[] images;

    public ButtonAnimator(OomphUIPlugin plugin, ToolItem button, String imagePrefix, int additionalImages) {
        this(plugin, button, imagePrefix, additionalImages, false);
    }

    public ButtonAnimator(OomphUIPlugin plugin, ToolItem button, String imagePrefix, int additionalImages, boolean rotate) {
        this.plugin = plugin;
        this.button = button;
        this.imagePrefix = imagePrefix;
        this.additionalImages = additionalImages;
        this.rotate = rotate;
    }

    public void run() {
        block12: {
            Shell shell = this.getShell();
            if (!this.button.isDisposed() && shell != null && !shell.isDisposed()) {
                try {
                    if (this.images == null) {
                        this.initImages();
                    }
                    if (this.shouldAnimate()) {
                        this.button.setImage(this.images[Math.max(0, this.index)]);
                        if (this.backward) {
                            if (--this.index == -this.getQuietCycles()) {
                                this.backward = false;
                            }
                        } else if (++this.index == this.images.length) {
                            if (this.rotate) {
                                this.index = -this.getQuietCycles();
                            } else {
                                this.index = this.images.length - 2;
                                this.backward = true;
                            }
                        }
                        shell.getDisplay().timerExec(this.rotate ? 80 : 40, (Runnable)this);
                    } else {
                        this.index = 0;
                        this.backward = false;
                        this.button.setImage(this.images[this.index]);
                    }
                }
                catch (SWTException ex) {
                    if (this.button.isDisposed()) break block12;
                    throw ex;
                }
            }
        }
    }

    protected int getQuietCycles() {
        if (this.rotate) {
            return 8;
        }
        return 10;
    }

    public abstract Shell getShell();

    public final boolean shouldAnimate() {
        return this.button != null && !this.button.isDisposed() && this.button.isEnabled() && this.doAnimate();
    }

    protected abstract boolean doAnimate();

    private void initImages() {
        this.images = new Image[1 + this.additionalImages];
        this.images[0] = this.button.getImage();
        String prefix = this.imagePrefix;
        String suffix = "";
        if (this.imagePrefix.endsWith(".png")) {
            prefix = prefix.substring(0, prefix.length() - 4);
            suffix = ".png";
        }
        int i = 0;
        while (i < this.images.length - 1) {
            this.images[i + 1] = this.plugin.getSWTImage(String.valueOf(prefix) + i + suffix);
            ++i;
        }
    }
}

