/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;

public class MarkerViewUtil {
    public static final String PATH_ATTRIBUTE = "org.eclipse.ui.views.markers.path";
    public static final String NAME_ATTRIBUTE = "org.eclipse.ui.views.markers.name";

    public static String getViewId(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return "org.eclipse.ui.views.TaskList";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return "org.eclipse.ui.views.ProblemView";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return "org.eclipse.ui.views.BookmarkView";
        }
        return null;
    }

    public static boolean showMarker(IWorkbenchPage page, IMarker marker, boolean showView) {
        return MarkerViewUtil.showMarkers(page, new IMarker[]{marker}, showView);
    }

    public static boolean showMarkers(IWorkbenchPage page, IMarker[] markers, boolean showView) {
        if (markers == null || markers.length == 0 || markers[0] == null) {
            return false;
        }
        boolean returnValue = false;
        try {
            IViewPart view;
            String viewId = MarkerViewUtil.getViewId(markers[0]);
            IMarker[] markersSameView = MarkerViewUtil.getMarkersOfView(viewId, markers);
            if (viewId == null) {
                viewId = "org.eclipse.ui.views.ProblemView";
            }
            IViewPart iViewPart = view = showView ? page.showView(viewId) : page.findView(viewId);
            if (view != null) {
                returnValue = MarkerSupportInternalUtilities.showMarkers(view, markersSameView);
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
        return returnValue;
    }

    private static IMarker[] getMarkersOfView(String viewId, IMarker[] markers) throws CoreException {
        if (viewId == null) {
            return markers;
        }
        ArrayList<IMarker> markersOfView = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != null && viewId.equals(MarkerViewUtil.getViewId(marker))) {
                markersOfView.add(marker);
            }
            ++n2;
        }
        return markersOfView.toArray(new IMarker[markersOfView.size()]);
    }
}

