/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class ExportDialog
extends Dialog {
    protected Text field;
    protected String target = null;
    protected String title = null;
    protected String message = null;

    public ExportDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void create() {
        super.create();
        this.field.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            messageLabel.setLayoutData((Object)data);
        }
        this.createTargetFields(main);
        Dialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createTargetFields(Composite parent) {
        new Label(parent, 0).setText(Messages.CVSSSH2PreferencePage_125);
        this.field = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.field.setLayoutData((Object)data);
    }

    public String getTarget() {
        return this.target;
    }

    protected void okPressed() {
        String _target = this.field.getText();
        if (_target == null || _target.length() == 0) {
            return;
        }
        this.target = _target;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.target = null;
        super.cancelPressed();
    }
}

