/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TaskItemDecorator {
    private static final IWorkbench WORKBENCH = PlatformUI.getWorkbench();
    private static final TaskBar SYSTEM_TASK_BAR = WORKBENCH.getDisplay().getSystemTaskBar();
    public static final String IDE_NODE = "org.eclipse.ui.ide";
    public static final String WORKSPACE_NAME = "WORKSPACE_NAME";
    private static final String SHOW_LOCATION_NAME = "SHOW_LOCATION_NAME";
    private static final IEclipsePreferences DEFAULT_IDE_PREFERENCES = DefaultScope.INSTANCE.getNode("org.eclipse.ui.ide");
    private static final IEclipsePreferences IDE_PREFERENCES = InstanceScope.INSTANCE.getNode("org.eclipse.ui.ide");

    public TaskItemDecorator() {
        if (SYSTEM_TASK_BAR != null) {
            IDE_PREFERENCES.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    String key = event.getKey();
                    if (TaskItemDecorator.WORKSPACE_NAME.equals(key) || TaskItemDecorator.SHOW_LOCATION_NAME.equals(key)) {
                        TaskItemDecorator.this.update(TaskItemDecorator.this.getWorkspaceName());
                    }
                }
            });
            WORKBENCH.addWindowListener(new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                    Shell shell = window.getShell();
                    if (shell != null && !shell.isDisposed()) {
                        TaskItemDecorator.this.update(shell, TaskItemDecorator.this.getWorkspaceName());
                    }
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                }
            });
            this.update(this.getWorkspaceName());
        }
    }

    private String getWorkspaceName() {
        if (IDE_PREFERENCES.getBoolean(SHOW_LOCATION_NAME, DEFAULT_IDE_PREFERENCES.getBoolean(SHOW_LOCATION_NAME, true))) {
            return IDE_PREFERENCES.get(WORKSPACE_NAME, DEFAULT_IDE_PREFERENCES.get(WORKSPACE_NAME, ""));
        }
        return "";
    }

    private void update(String label) {
        IWorkbenchWindow[] iWorkbenchWindowArray = WORKBENCH.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            Shell shell = workbenchWindow.getShell();
            if (shell != null && !shell.isDisposed()) {
                this.update(shell, label);
            }
            ++n2;
        }
    }

    private void update(Shell shell, String label) {
        TaskItem item = SYSTEM_TASK_BAR.getItem(shell);
        if (item == null) {
            item = SYSTEM_TASK_BAR.getItem(null);
        }
        if (item != null) {
            item.setOverlayText(label);
        }
    }
}

