/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedColorRegistry;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.internal.ui.ToggleSwitchButton;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.ui.AgentManagerDialog;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.IndexManager;
import org.eclipse.oomph.setup.internal.installer.AboutDialog;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.Installer;
import org.eclipse.oomph.setup.internal.installer.InstallerUI;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.ProductCatalogsDialog;
import org.eclipse.oomph.setup.internal.installer.SelfUpdate;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallLaunchButton;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallationLogPage;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerMenu;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerMenuButton;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleKeepInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleMessageOverlay;
import org.eclipse.oomph.setup.internal.installer.SimpleProductPage;
import org.eclipse.oomph.setup.internal.installer.SimpleReadmePage;
import org.eclipse.oomph.setup.internal.installer.SimpleVariablePage;
import org.eclipse.oomph.setup.internal.installer.TrustDialog;
import org.eclipse.oomph.setup.internal.installer.URISchemeUtil;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.ConfigurationProcessor;
import org.eclipse.oomph.setup.ui.wizards.ExtensionsDialog;
import org.eclipse.oomph.setup.ui.wizards.MarketPlaceListingProcessor;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.StatusDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ExceptionHandler;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class SimpleInstallerDialog
extends AbstractSimpleDialog
implements InstallerUI {
    private static final String CATALOGS_MENU_ITEM_TEXT = ProductCatalogsDialog.TITLE.toUpperCase() + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String APPLY_CONFIGURATION_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_AppyConfiguration_label;
    private static final String APPLY_CONFIGURATION_MENU_ITEM_DESCRIPTION = Messages.SimpleInstallerDialog_ApplyConfiguration_message;
    private static final String APPLY_MARKET_PLACE_LISTING_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_ApplyMarketplaceListing_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String APPLY_MARKET_PLACE_LISTING_MENU_ITEM_DESCRIPTION = Messages.SimpleInstallerDialog_ApplyMarketplaceListing_message;
    private static final String EXTENSIONS_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Extensions_label + StringUtil.HORIZONTAL_ELLIPSIS;
    static final String EXTENSIONS_MENU_ITEM_DESCRIPTION = Messages.SimpleInstallerDialog_Extensions_message;
    private static final String SWITCH_CATALOG_INDEX_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_SwitchIndex_label;
    private static final String BUNDLE_POOLS_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_BundlePools_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String UPDATE_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Update_label;
    private static final String ADVANCED_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_AdvancedMode_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String WEB_LINKS_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_WebLinks_label + StringUtil.HORIZONTAL_ELLIPSIS;
    static final String WEB_LINKS_MENU_ITEM_DESCRIPTION = Messages.SimpleInstallerDialog_WebLinks_message;
    private static final String TRUST_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Trust_label + StringUtil.HORIZONTAL_ELLIPSIS;
    static final String TRUST_MENU_ITEM_DESCRIPTION = Messages.SimpleInstallerDialog_Trust_message;
    private static final String MARKET_PLACE_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Marketplace_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String ASK_A_QUESTION_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_AskQuestion_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String REPORT_A_PROBLEM_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_ReportProblem_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String CONTRIBUTE_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Contribute_label + StringUtil.HORIZONTAL_ELLIPSIS;
    private static final String ABOUT_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_About_label;
    private static final String EXIT_MENU_ITEM_TEXT = Messages.SimpleInstallerDialog_Exit_label;
    private static final OomphPlugin.Preference PREF_POOL_ENABLED = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("poolEnabled");
    private static final boolean MARKETPLACE_MENU_ITEM_ENABLED = !"false".equals(PropertiesUtil.getProperty((String)"oomph.setup.installer.marketplace"));
    private static final String HOST = PropertiesUtil.getProperty((String)"oomph.setup.installer.host", (String)"https://www.eclipse.org/setups/installer");
    private static final String PROBLEM_REPORT_URL = PropertiesUtil.getProperty((String)"oomph.setup.installer.problem.report", (String)(HOST + "/problem/"));
    private static final String FORUM_URL = PropertiesUtil.getProperty((String)"oomph.setup.installer.forum", (String)(HOST + "/question/"));
    private static final String CONTRIBUTE_URL = PropertiesUtil.getProperty((String)"oomph.setup.installer.contribute", (String)(HOST + "/notification/"));
    private static final File FILE_BRANDING_NOTIFICTION_URIS = new File(SetupInstallerPlugin.INSTANCE.getUserLocation().toFile(), "brandingNotificationURIs.txt");
    private static Font defaultFont;
    private static Point defaultSize;
    private static String css;
    private static String pageTemplate;
    private static String productTemplate;
    private static String productTemplateLarge;
    private final Installer installer;
    private final boolean restarted;
    private final CatalogManager catalogManager;
    private final PageStack pageStack = new PageStack();
    private Composite stack;
    private StackLayout stackLayout;
    private SimpleProductPage productPage;
    private SimpleVariablePage variablePage;
    private SimpleReadmePage readmePage;
    private SimpleInstallationLogPage installationLogPage;
    private SimpleKeepInstallerPage keepInstallerPage;
    private SimpleInstallerMenu installerMenu;
    private SimpleInstallerMenuButton menuButton;
    private NotifictionButton notificationButton;
    private boolean poolEnabled;
    private BundlePool pool;
    private ProfileTransaction.Resolution updateResolution;
    private SimpleMessageOverlay currentMessage;
    private ToggleSwitchButton bundlePoolSwitch;
    private ToggleSwitchButton webLinksSwitch;
    private boolean showProductCatalogsItem;

    public SimpleInstallerDialog(Display display, Installer installer, boolean restarted) {
        super(display, 8, SimpleInstallerDialog.getDefaultSize((Drawable)display).x, SimpleInstallerDialog.getDefaultSize((Drawable)display).y);
        this.setMinimumSize(385, 75);
        this.installer = installer;
        this.restarted = restarted;
        this.catalogManager = installer.getCatalogManager();
    }

    protected void applyConfiguration() {
        MarketPlaceListingProcessor marketPlaceListingProcessor = new MarketPlaceListingProcessor((SetupWizard)this.installer);
        if (marketPlaceListingProcessor.isMarketPlaceListing()) {
            marketPlaceListingProcessor.processMarketPlaceListing();
            IStatus status = marketPlaceListingProcessor.getStatus();
            if (!status.isOK()) {
                new StatusDialog(this.getShell(), Messages.SimpleInstallerDialog_MPCProblems_title, null, status, 4).open();
            }
        } else {
            IStatus status;
            ConfigurationProcessor configurationProcessor = new ConfigurationProcessor(this.installer){

                protected void handleSwitchToAdvancedMode() {
                    SimpleInstallerDialog.this.switchToAdvancedMode();
                }

                protected boolean applyEmptyProductVersion() {
                    this.applyInstallation();
                    return true;
                }

                protected boolean applyProductVersion(ProductVersion productVersion) {
                    this.applyInstallation();
                    SimpleInstallerDialog.this.productPage.handleFilter("");
                    SimpleInstallerDialog.this.productPage.productSelected(productVersion.getProduct());
                    SimpleInstallerDialog.this.variablePage.setProductVersion(productVersion);
                    return true;
                }
            };
            if (configurationProcessor.processWorkspace()) {
                configurationProcessor.processInstallation();
            }
            if (!(status = configurationProcessor.getStatus()).isOK()) {
                new StatusDialog(this.getShell(), Messages.SimpleInstallerDialog_ConfigurationProblems_title, null, status, 4).open();
            }
        }
    }

    @Override
    protected IDialogSettings getDialogSizeSettings() {
        return SetupInstallerPlugin.INSTANCE.getDialogSettings("SimpleInstaller");
    }

    @Override
    protected int getTitleColumnCount() {
        return super.getTitleColumnCount() + 1;
    }

    @Override
    protected GridData createTitleImageGridData() {
        GridData gridData = super.createTitleImageGridData();
        gridData.grabExcessHorizontalSpace = false;
        return gridData;
    }

    @Override
    protected void createUI(Composite titleComposite) {
        Composite notificationContainer = new Composite(titleComposite, 0);
        GridLayout notificationContainerLayout = UIUtil.createGridLayout((int)1);
        notificationContainerLayout.marginRight = 20;
        notificationContainer.setLayout((Layout)notificationContainerLayout);
        notificationContainer.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(0x1000008, 1).create());
        this.notificationButton = new NotifictionButton(notificationContainer){

            @Override
            protected void handleWidgetSelected() {
                super.handleWidgetSelected();
                SimpleInstallerDialog.this.handleBrandingNotificationURIOpen(this.getURI());
            }

            @Override
            protected boolean hasOpenedBrandingNotificationURI(URI uri) {
                return SimpleInstallerDialog.this.hasOpenedBrandingNotificationURI(uri);
            }
        };
        this.notificationButton.setLayoutData(GridDataFactory.swtDefaults().align(0x1000000, 1).create());
        this.notificationButton.setVisible(false);
        Composite exitMenuButtonContainer = new Composite(titleComposite, 0);
        exitMenuButtonContainer.setLayout((Layout)UIUtil.createGridLayout((int)1));
        exitMenuButtonContainer.setLayoutData((Object)GridDataFactory.swtDefaults().grab(false, true).align(0x1000000, 4).create());
        ImageHoverButton exitButton = new ImageHoverButton(exitMenuButtonContainer, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exit.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exit_hover.png"));
        exitButton.setShowButtonDownState(false);
        exitButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 1).create());
        exitButton.setToolTipText(Messages.SimpleInstallerDialog_Exit_message);
        exitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.exitSelected();
            }
        });
        this.menuButton = new SimpleInstallerMenuButton(exitMenuButtonContainer);
        this.menuButton.setLayoutData(GridDataFactory.swtDefaults().grab(false, true).align(0x1000000, 1).indent(11, 0).create());
        this.menuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.toggleMenu();
            }
        });
        this.stackLayout = new StackLayout();
        this.stack = new Composite((Composite)this, 0);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stack.setLayout((Layout)this.stackLayout);
        SetupWizard.SelectionMemento selectionMemento = this.installer.getSelectionMemento();
        this.productPage = new SimpleProductPage(this.stack, this, selectionMemento);
        this.variablePage = new SimpleVariablePage(this.stack, this, selectionMemento);
        if (UIUtil.isBrowserAvailable()) {
            this.readmePage = new SimpleReadmePage(this.stack, this);
        }
        this.installationLogPage = new SimpleInstallationLogPage(this.stack, this);
        this.keepInstallerPage = new SimpleKeepInstallerPage(this.stack, this);
        this.switchToPage(this.productPage);
        Display display = this.getDisplay();
        if (!this.restarted) {
            UpdateSearcher updateSearcher = new UpdateSearcher(display);
            updateSearcher.start();
        }
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                SimpleInstallerDialog.this.installer.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                SimpleInstallerDialog.this.installer.loadIndex();
            }
        });
        this.getInstallerMenu();
        final PropertyChangeListener catalogManagerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("PROPERTY_INDEX".equals(evt.getPropertyName())) {
                    SimpleInstallerDialog.this.indexLoaded((Index)evt.getNewValue());
                }
            }
        };
        this.catalogManager.addPropertyChangeListener(catalogManagerListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleInstallerDialog.this.catalogManager.removePropertyChangeListener(catalogManagerListener);
            }
        });
        this.enablePool(SHOW_BUNDLE_POOL_UI && PREF_POOL_ENABLED.get(true));
        this.updateAvailable(false);
        titleComposite.layout(true);
    }

    private void indexLoaded(Index index) {
        List productCatalogs = this.catalogManager.getCatalogs(true);
        int count = 0;
        if (productCatalogs != null) {
            for (ProductCatalog productCatalog : productCatalogs) {
                if (!SimpleProductPage.isIncluded(productCatalog)) continue;
                ++count;
            }
        }
        this.showProductCatalogsItem = count > 1 || StringUtil.isEmpty((String)SimpleInstallerPage.PRODUCT_CATALOG_FILTER.pattern()) && StringUtil.isEmpty((String)SimpleInstallerPage.PRODUCT_FILTER.pattern()) && StringUtil.isEmpty((String)SimpleInstallerPage.PRODUCT_VERSION_FILTER.pattern()) && new IndexManager().getIndexNames(false).size() > 1;
        this.notificationButton.setBrandingNotificationScope(productCatalogs);
    }

    public void setBrandingNotificationScope(Scope scope) {
        this.notificationButton.setBrandingNotificationScope(scope);
    }

    private void toggleMenu() {
        SimpleInstallerMenu installerMenu = this.getInstallerMenu();
        boolean show = !installerMenu.isVisible();
        Installer installer = this.getInstaller();
        if (show) {
            installer.setConfigurationResources(Collections.emptySet());
            SimpleInstallerPage topPage = this.getTopPage();
            if (topPage != null) {
                topPage.menuAboutToShow(installerMenu);
            }
            SimpleInstallerMenu.InstallerMenuItem extensionsItem = installerMenu.findMenuItemByName(EXTENSIONS_MENU_ITEM_TEXT);
            extensionsItem.setVisible(!installer.getAppliedConfigurationResources().isEmpty());
            SimpleInstallerMenu.InstallerMenuItem switchCatalogIndexItem = installerMenu.findMenuItemByName(SWITCH_CATALOG_INDEX_MENU_ITEM_TEXT);
            SimpleInstallerMenu.InstallerMenuItem catalogsMenuItem = installerMenu.findMenuItemByName(CATALOGS_MENU_ITEM_TEXT);
            SimpleInstallerMenu.InstallerMenuItem marketPlaceItem = installerMenu.findMenuItemByName(MARKET_PLACE_MENU_ITEM_TEXT);
            SimpleInstallerMenu.InstallerMenuItem applyConfigurationMenuItem = installerMenu.findMenuItemByName(APPLY_CONFIGURATION_MENU_ITEM_TEXT);
            if (applyConfigurationMenuItem == null) {
                applyConfigurationMenuItem = installerMenu.findMenuItemByName(APPLY_MARKET_PLACE_LISTING_MENU_ITEM_TEXT);
            }
            if (topPage == this.productPage) {
                boolean visible;
                Collection configurationResources = installer.getUnappliedConfigurationResources();
                URI indexLocation = ProjectPage.ConfigurationListener.getIndexURI((Collection)configurationResources);
                boolean bl = visible = !configurationResources.isEmpty() && indexLocation == null;
                if (visible) {
                    boolean isMarketPlaceListing = false;
                    for (Resource resource : configurationResources) {
                        if (!MarketPlaceListing.isMarketPlaceListing((URI)resource.getURI())) continue;
                        isMarketPlaceListing = true;
                        break;
                    }
                    applyConfigurationMenuItem.setText(isMarketPlaceListing ? APPLY_MARKET_PLACE_LISTING_MENU_ITEM_TEXT : APPLY_CONFIGURATION_MENU_ITEM_TEXT);
                    applyConfigurationMenuItem.setToolTipText(isMarketPlaceListing ? APPLY_MARKET_PLACE_LISTING_MENU_ITEM_DESCRIPTION : APPLY_CONFIGURATION_MENU_ITEM_DESCRIPTION);
                }
                applyConfigurationMenuItem.setVisible(visible);
                boolean switchCatalogVisible = indexLocation != null && !this.catalogManager.isCurrentIndex(indexLocation);
                switchCatalogIndexItem.setVisible(switchCatalogVisible);
                if (switchCatalogVisible) {
                    switchCatalogIndexItem.setToolTipText(NLS.bind((String)Messages.SimpleInstallerDialog_SwitchCatalogIndex_message, (Object)IndexManager.getUnderlyingLocation((URI)indexLocation)));
                }
                catalogsMenuItem.setVisible(this.showProductCatalogsItem);
                if (marketPlaceItem != null) {
                    marketPlaceItem.setVisible(true);
                }
            } else {
                catalogsMenuItem.setVisible(false);
                applyConfigurationMenuItem.setVisible(false);
                switchCatalogIndexItem.setVisible(false);
                if (marketPlaceItem != null) {
                    marketPlaceItem.setVisible(false);
                }
            }
        }
        installerMenu.layout(true, true);
        installerMenu.setVisible(show);
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public void setButtonsEnabled(boolean enabled) {
        this.menuButton.setEnabled(enabled);
    }

    private void enablePool(boolean poolEnabled) {
        if (this.poolEnabled != poolEnabled) {
            this.poolEnabled = poolEnabled;
            PREF_POOL_ENABLED.set(poolEnabled);
        }
        this.pool = poolEnabled ? P2Util.getAgentManager().getDefaultBundlePool(SetupUIPlugin.INSTANCE.getSymbolicName()) : null;
        if (this.bundlePoolSwitch != null) {
            this.bundlePoolSwitch.setSelected(poolEnabled);
        }
    }

    public BundlePool getPool() {
        return this.pool;
    }

    private SimpleInstallerMenu getInstallerMenu() {
        if (this.installerMenu == null) {
            this.installerMenu = this.createInstallerMenu();
        }
        return this.installerMenu;
    }

    private SimpleInstallerMenu createInstallerMenu() {
        SimpleInstallerMenu.InstallerMenuItem reportAProblemItem;
        SimpleInstallerMenu menu = new SimpleInstallerMenu(this);
        SimpleInstallerMenu.InstallerMenuItem updateInstallerItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        updateInstallerItem.setDefaultImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exclamation_circle.png"));
        updateInstallerItem.setHoverImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/exclamation_circle_hover.png"));
        updateInstallerItem.setText(UPDATE_MENU_ITEM_TEXT);
        updateInstallerItem.setToolTipText(Messages.SimpleInstallerDialog_InstallUpdates_message);
        updateInstallerItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Runnable successRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SimpleInstallerDialog.this.restart();
                    }
                };
                ExceptionHandler<CoreException> exceptionHandler = new ExceptionHandler<CoreException>(){

                    public void handleException(CoreException ex) {
                        ErrorDialog.open((Throwable)ex);
                    }
                };
                SelfUpdate.update(SimpleInstallerDialog.this.getShell(), SimpleInstallerDialog.this.updateResolution, successRunnable, exceptionHandler, null);
            }
        });
        SimpleInstallerMenu.InstallerMenuItem applyConfigurationItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        applyConfigurationItem.setText(APPLY_CONFIGURATION_MENU_ITEM_TEXT);
        applyConfigurationItem.setToolTipText(APPLY_CONFIGURATION_MENU_ITEM_DESCRIPTION);
        applyConfigurationItem.setVisible(false);
        applyConfigurationItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.applyConfiguration();
            }
        });
        SimpleInstallerMenu.InstallerMenuItem extensionsItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        extensionsItem.setDefaultImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/extension_circle.png"));
        extensionsItem.setHoverImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/extension_circle_hover.png"));
        extensionsItem.setText(EXTENSIONS_MENU_ITEM_TEXT);
        extensionsItem.setToolTipText(EXTENSIONS_MENU_ITEM_DESCRIPTION);
        extensionsItem.setVisible(false);
        extensionsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection appliedConfigurationResources = SimpleInstallerDialog.this.installer.getAppliedConfigurationResources();
                ExtensionsDialog extensionsDialog = new ExtensionsDialog(SimpleInstallerDialog.this.getShell(), appliedConfigurationResources);
                if (extensionsDialog.open() == 0) {
                    Collection result = extensionsDialog.getResult();
                    for (Resource resource : appliedConfigurationResources) {
                        if (result.contains(resource)) continue;
                        SimpleInstallerDialog.this.installer.removeAppliedConfigurationResource(resource);
                    }
                }
            }
        });
        SimpleInstallerMenu.InstallerMenuItem switchCatalogIndexItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        switchCatalogIndexItem.setText(SWITCH_CATALOG_INDEX_MENU_ITEM_TEXT);
        switchCatalogIndexItem.setVisible(false);
        switchCatalogIndexItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.applyConfiguration();
            }
        });
        SimpleInstallerMenu.InstallerMenuItem catalogsItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        catalogsItem.setText(CATALOGS_MENU_ITEM_TEXT);
        catalogsItem.setToolTipText(ProductCatalogsDialog.DESCRIPTION);
        catalogsItem.setVisible(false);
        catalogsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductCatalogsDialog productCatalogsDialog = new ProductCatalogsDialog(SimpleInstallerDialog.this, SimpleInstallerDialog.this.getInstaller(), SimpleInstallerDialog.this.catalogManager);
                productCatalogsDialog.open();
            }
        });
        AccessUtil.setKey((Widget)catalogsItem, (Object)"catalogs");
        SimpleInstallerMenu.InstallerMenuItem advancedModeItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        advancedModeItem.setText(ADVANCED_MENU_ITEM_TEXT);
        advancedModeItem.setToolTipText(Messages.SimpleInstallerDialog_SwitchToAdvancedMode_message);
        advancedModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.switchToAdvancedMode();
            }
        });
        if (SHOW_BUNDLE_POOL_UI) {
            SimpleInstallerMenu.InstallerMenuItemWithToggle bundlePoolsItem = new SimpleInstallerMenu.InstallerMenuItemWithToggle(menu);
            bundlePoolsItem.setText(BUNDLE_POOLS_MENU_ITEM_TEXT);
            bundlePoolsItem.setToolTipText(AgentManagerDialog.MESSAGE);
            bundlePoolsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleInstallerDialog.this.manageBundlePools();
                }
            });
            this.bundlePoolSwitch = bundlePoolsItem.getToggleSwitch();
            this.bundlePoolSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleInstallerDialog.this.enablePool(SimpleInstallerDialog.this.bundlePoolSwitch.isSelected());
                }
            });
        }
        SimpleInstallerMenu.InstallerMenuItemWithToggle webLinksItem = new SimpleInstallerMenu.InstallerMenuItemWithToggle(menu);
        webLinksItem.setText(WEB_LINKS_MENU_ITEM_TEXT);
        webLinksItem.setToolTipText(WEB_LINKS_MENU_ITEM_DESCRIPTION);
        webLinksItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (URISchemeUtil.manageRegistrations(SimpleInstallerDialog.this.getShell()) == URISchemeUtil.RegistrationConfirmation.KEEP_INSTALLER) {
                    SimpleInstallerDialog.this.close();
                } else {
                    SimpleInstallerDialog.this.webLinksSwitch.setSelected(URISchemeUtil.isRegistered());
                }
            }
        });
        this.webLinksSwitch = webLinksItem.getToggleSwitch();
        this.webLinksSwitch.setSelected(URISchemeUtil.isRegistered());
        this.webLinksSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = SimpleInstallerDialog.this.webLinksSwitch.isSelected();
                if (enable) {
                    switch (URISchemeUtil.confirmRegistration(SimpleInstallerDialog.this.getShell())) {
                        case KEEP_INSTALLER: {
                            SimpleInstallerDialog.this.showKeepInstaller(true);
                            break;
                        }
                        case OK: {
                            URISchemeUtil.setRegistered(true);
                            break;
                        }
                    }
                } else {
                    URISchemeUtil.setRegistered(false);
                }
                SimpleInstallerDialog.this.webLinksSwitch.setSelected(URISchemeUtil.isRegistered());
            }
        });
        SimpleInstallerMenu.InstallerMenuItem trustMenuItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        trustMenuItem.setText(TRUST_MENU_ITEM_TEXT);
        trustMenuItem.setToolTipText(TRUST_MENU_ITEM_DESCRIPTION);
        trustMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrustDialog dialog = new TrustDialog(SimpleInstallerDialog.this.getShell());
                dialog.open();
            }
        });
        if (MARKETPLACE_MENU_ITEM_ENABLED) {
            SimpleInstallerMenu.InstallerMenuItem marketPlaceItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
            marketPlaceItem.setText(MARKET_PLACE_MENU_ITEM_TEXT);
            marketPlaceItem.setToolTipText(Messages.SimpleInstallerDialog_BrowseMPC_message);
            marketPlaceItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser("https://marketplace.eclipse.org");
                }
            });
        }
        if (!StringUtil.isEmpty((String)FORUM_URL)) {
            SimpleInstallerMenu.InstallerMenuItem askAQuestionItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
            askAQuestionItem.setText(ASK_A_QUESTION_MENU_ITEM_TEXT);
            askAQuestionItem.setToolTipText(Messages.SimpleInstallerDialog_AskQuestion_message);
            askAQuestionItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser(FORUM_URL + "?version=" + URI.encodeQuery((String)SelfUpdate.getProductVersion(), (boolean)false));
                }
            });
        }
        if (!StringUtil.isEmpty((String)PROBLEM_REPORT_URL)) {
            reportAProblemItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
            reportAProblemItem.setText(REPORT_A_PROBLEM_MENU_ITEM_TEXT);
            reportAProblemItem.setToolTipText(Messages.SimpleInstallerDialog_ReportProblem_message);
            reportAProblemItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser(PROBLEM_REPORT_URL + "?version=" + URI.encodeQuery((String)SelfUpdate.getProductVersion(), (boolean)false));
                }
            });
        }
        if (!StringUtil.isEmpty((String)CONTRIBUTE_URL)) {
            reportAProblemItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
            reportAProblemItem.setText(CONTRIBUTE_MENU_ITEM_TEXT);
            reportAProblemItem.setToolTipText(Messages.SimpleInstallerDialog_Contribute_message);
            reportAProblemItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OS.INSTANCE.openSystemBrowser(CONTRIBUTE_URL + "?version=" + URI.encodeQuery((String)SelfUpdate.getProductVersion(), (boolean)false));
                }
            });
        }
        SimpleInstallerMenu.InstallerMenuItem aboutItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        aboutItem.setText(ABOUT_MENU_ITEM_TEXT);
        aboutItem.setToolTipText(Messages.SimpleInstallerDialog_ShowAbout_message);
        aboutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.showAbout();
            }
        });
        SimpleInstallerMenu.InstallerMenuItem exitItem = new SimpleInstallerMenu.InstallerMenuItem(menu);
        exitItem.setText(EXIT_MENU_ITEM_TEXT);
        exitItem.setDividerVisible(false);
        exitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleInstallerDialog.this.exitSelected();
            }
        });
        return menu;
    }

    public void setExtensionsAvailable(boolean available) {
        this.menuButton.setExtensionVisible(available);
    }

    private void updateAvailable(boolean available) {
        this.menuButton.setNotificationVisible(available);
        this.installerMenu.findMenuItemByName(UPDATE_MENU_ITEM_TEXT).setVisible(available);
        this.installerMenu.layout();
    }

    private void manageBundlePools() {
        final boolean[] enabled = new boolean[]{this.poolEnabled};
        AgentManagerDialog dialog = new AgentManagerDialog(this.getShell()){

            protected void createUI(Composite parent) {
                final Button enabledButton = new Button(parent, 32);
                enabledButton.setText(Messages.SimpleInstallerDialog_EnableBundlePool_label);
                enabledButton.setSelection(SimpleInstallerDialog.this.poolEnabled);
                enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        enabled[0] = enabledButton.getSelection();
                        this.getComposite().setEnabled(enabled[0]);
                    }
                });
                new Label(parent, 0);
                super.createUI(parent);
                this.getComposite().setEnabled(SimpleInstallerDialog.this.poolEnabled);
            }

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            }

            protected void elementChanged(Object element) {
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(this.getSelectedBundlePool() != null || !enabled[0]);
                }
            }
        };
        if (this.pool != null) {
            dialog.setSelectedPool(this.pool);
        }
        if (dialog.open() == 0) {
            this.enablePool(enabled[0]);
            this.pool = dialog.getSelectedBundlePool();
        }
    }

    @Override
    public boolean refreshJREs() {
        if (this.variablePage != null) {
            return this.variablePage.refreshJREs();
        }
        return false;
    }

    @Override
    public void showAbout() {
        String version = SelfUpdate.getProductVersion();
        new AboutDialog(this.getShell(), version).open();
    }

    @Override
    protected void runEventLoop() {
        this.getInstaller().runEventLoop(this.getShell());
    }

    public void productSelected(Product product) {
        this.variablePage.setProduct(product);
        this.switchToPage(this.variablePage);
    }

    public SimpleInstallerPage getTopPage() {
        return (SimpleInstallerPage)this.stackLayout.topControl;
    }

    private void doSwitch(SimpleInstallerPage oldPage, SimpleInstallerPage newPage) {
        if (oldPage != null) {
            oldPage.aboutToHide();
            if (newPage instanceof SimpleProductPage) {
                List productCatalogs = this.catalogManager.getCatalogs(true);
                this.notificationButton.setBrandingNotificationScope(productCatalogs);
            }
        }
        this.stackLayout.topControl = newPage;
        this.stack.layout();
        this.clearMessage();
        newPage.aboutToShow();
        newPage.setFocus();
    }

    private void switchToPage(SimpleInstallerPage newPage) {
        SimpleInstallerPage oldPage;
        if (newPage != null && ((oldPage = this.pageStack.peek()) == null || oldPage != newPage)) {
            this.pageStack.push(newPage);
            this.doSwitch(oldPage, newPage);
        }
    }

    public void switchToAdvancedMode() {
        this.installer.setConfigurationResources(Collections.emptySet());
        this.setReturnCode(3);
        this.exitSelected();
    }

    public void restart() {
        this.setReturnCode(-4);
        this.exitSelected();
    }

    protected void exitQuiet() {
        super.exitSelected();
    }

    @Override
    protected void exitSelected() {
        for (SimpleInstallerPage page : this.pageStack) {
            if (!(page instanceof SimpleVariablePage)) continue;
            SimpleVariablePage variablePage = (SimpleVariablePage)page;
            if (variablePage.promptLaunchProduct(Messages.SimpleInstallerDialog_AboutToExit_message)) break;
            return;
        }
        this.exitQuiet();
    }

    public void backSelected() {
        if (this.pageStack.size() <= 1) {
            return;
        }
        SimpleInstallerPage oldPage = this.pageStack.pop();
        SimpleInstallerPage newPage = this.pageStack.peek();
        this.doSwitch(oldPage, newPage);
    }

    public void showMessage(String message, SimpleMessageOverlay.Type type, boolean dismissAutomatically) {
        this.showMessage(message, type, dismissAutomatically, null);
    }

    public void showMessage(String message, SimpleMessageOverlay.Type type, boolean dismissAutomatically, Runnable action) {
        this.showMessage(message, type, dismissAutomatically, action, null);
    }

    public void showMessage(String message, SimpleMessageOverlay.Type type, boolean dismissAutomatically, Runnable action, Runnable closeAction) {
        if (this.currentMessage == null || this.currentMessage.getType() != type || this.currentMessage.isDismissAutomatically() != dismissAutomatically || this.currentMessage.getAction() != action || this.currentMessage.getCloseAction() != closeAction) {
            this.clearMessage();
            final Control originalFocusControl = this.getShell().getDisplay().getFocusControl();
            if (originalFocusControl != null) {
                UIUtil.asyncExec((Control)originalFocusControl, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Control focusControl = SimpleInstallerDialog.this.getShell().getDisplay().getFocusControl();
                        if (focusControl != originalFocusControl) {
                            originalFocusControl.setFocus();
                        }
                    }
                });
            }
            this.currentMessage = new SimpleMessageOverlay(this, type, new SimpleMessageOverlay.ControlRelocator(){

                @Override
                public void relocate(Control control) {
                    Rectangle bounds = SimpleInstallerDialog.this.getBounds();
                    int x = bounds.x + 5;
                    int y = bounds.y + 24;
                    int width = bounds.width - 9;
                    int height = SimpleInstallerDialog.this.pageStack.peek() instanceof SimpleProductPage ? 87 : 70;
                    control.setBounds(x, y, width, height);
                }
            }, dismissAutomatically, action, closeAction);
        }
        this.currentMessage.setMessage(message);
        this.currentMessage.setVisible(true);
    }

    public void clearMessage() {
        if (this.currentMessage != null) {
            if (!this.currentMessage.isDisposed()) {
                this.currentMessage.close();
            }
            this.currentMessage = null;
        }
    }

    public void showReadme(java.net.URI readmeURI) {
        if (this.readmePage != null) {
            this.readmePage.setReadmeURI(readmeURI);
            this.switchToPage(this.readmePage);
        } else {
            OS.INSTANCE.openSystemBrowser(readmeURI.toString());
        }
    }

    public void showInstallationLog(File installationLogFile) {
        this.installationLogPage.setInstallationLogFile(installationLogFile);
        this.switchToPage(this.installationLogPage);
    }

    public void showKeepInstaller(boolean startPermanentInstaller) {
        this.keepInstallerPage.setStartPermanentInstaller(startPermanentInstaller);
        this.switchToPage(this.keepInstallerPage);
    }

    public void dispose() {
        this.menuButton.setFocus();
        super.dispose();
    }

    protected void handleBrandingNotificationURIOpen(URI uri) {
        LinkedHashSet<String> brandingNotificationURIs = new LinkedHashSet<String>();
        try {
            if (FILE_BRANDING_NOTIFICTION_URIS.isFile()) {
                brandingNotificationURIs.addAll(IOUtil.readLines((File)FILE_BRANDING_NOTIFICTION_URIS, (String)"UTF-8"));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        brandingNotificationURIs.add(uri.toString());
        try {
            IOUtil.writeLines((File)FILE_BRANDING_NOTIFICTION_URIS, (String)"UTF-8", new ArrayList(brandingNotificationURIs));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected boolean hasOpenedBrandingNotificationURI(URI uri) {
        try {
            if (FILE_BRANDING_NOTIFICTION_URIS.isFile()) {
                return IOUtil.readLines((File)FILE_BRANDING_NOTIFICTION_URIS, (String)"UTF-8").contains(uri.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    static URI getBrandingSiteURI(Scope scope) {
        if (scope != null) {
            String detail;
            Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"siteURI")) != null) {
                return URI.createURI((String)detail);
            }
            return SimpleInstallerDialog.getBrandingSiteURI(scope.getParentScope());
        }
        return null;
    }

    public static Font getFont(int relativeHeight, String style) {
        String height = relativeHeight == 0 ? "" : (relativeHeight > 0 ? "+" + relativeHeight : Integer.toString(relativeHeight));
        return SetupInstallerPlugin.getFont((Font)SimpleInstallerDialog.getDefaultFont(), (Object)URI.createURI((String)("font:///" + height + "/" + style)));
    }

    static Font getDefaultFont() {
        if (defaultFont == null && (defaultFont = JFaceResources.getFont((String)"font-open-sans.label-default")) == null) {
            defaultFont = UIUtil.getDisplay().getSystemFont();
        }
        return defaultFont;
    }

    static Point getDefaultSize(Drawable drawable) {
        if (defaultSize == null) {
            defaultSize = SimpleInstallerDialog.computeSize(drawable, SimpleInstallerDialog.getDefaultFont(), 45, 38);
        }
        return defaultSize;
    }

    static Point computeSize(Drawable drawable, Font font, int x, int y) {
        GC gc = new GC(drawable);
        gc.setFont(font);
        try {
            int height = gc.getFontMetrics().getHeight();
            int totalWidth = height * x;
            int totalHeight = height * y;
            Rectangle monitorArea = Display.getCurrent().getPrimaryMonitor().getClientArea();
            Point point = new Point(Math.min(totalWidth, monitorArea.width / 3), Math.min(totalHeight, 2 * monitorArea.height / 3));
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    static String getCSS() {
        if (css == null) {
            try {
                css = SimpleInstallerDialog.readBundleResource("html/css/simpleInstaller.css");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return css;
    }

    static String getPageTemplate() {
        if (pageTemplate == null) {
            try {
                pageTemplate = SimpleInstallerDialog.readBundleResource("html/PageTemplate.html");
                pageTemplate = pageTemplate.replace("%INSTALLER_CSS%", SimpleInstallerDialog.getCSS());
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return pageTemplate;
    }

    static String getProductTemplate() {
        if (productTemplate == null) {
            try {
                productTemplate = SimpleInstallerDialog.readBundleResource("html/ProductTemplate.html");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return productTemplate;
    }

    static String getProductTemplateLarge() {
        if (productTemplateLarge == null) {
            try {
                productTemplateLarge = SimpleInstallerDialog.readBundleResource("html/ProductTemplateLarge.html");
            }
            catch (IOException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        return productTemplateLarge;
    }

    private static String readBundleResource(String name) throws IOException {
        try {
            OomphPlugin.BundleFile root = SetupInstallerPlugin.INSTANCE.getRootFile();
            OomphPlugin.BundleFile child = root.getChild(name);
            return child.getContentsString();
        }
        catch (Exception ex) {
            throw new IOExceptionWithCause((Throwable)ex);
        }
    }

    private static class NotifictionButton
    extends FlatButton {
        private static final Color COLOR_INTENSE = SimpleInstallLaunchButton.COLOR_INSTALL;
        private static final Color COLOR_SUBTLE = SetupInstallerPlugin.getColor((int)210, (int)210, (int)210);
        private static final int CORNER_WIDTH = 10;
        private static final int MAX_OFFSET = 22;
        private int offset = 22;
        private AnimationStyle animationStyle;
        private Runnable animator;
        private URI uri;
        private int direction = -1;
        private Color buttonColor = COLOR_INTENSE;
        private boolean highlight;
        private String scopeLabel;

        public NotifictionButton(Composite parent) {
            super(parent, 8);
            this.setShowButtonDownState(false);
            this.setCornerWidth(10);
            this.setAlignment(0x1000000);
            this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/star_white.png"));
            this.setForeground(COLOR_WHITE);
            this.setBackground(COLOR_SUBTLE);
            this.setFont(SimpleInstallerDialog.getFont(1, "bold"));
            this.setVisible(false);
            this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.handleWidgetSelected();
                }
            });
        }

        protected void handleWidgetSelected() {
            String resolvedURI = this.uri.toString().replace("${installer.version}", URI.encodeQuery((String)SelfUpdate.getProductVersion(), (boolean)true)).replace("${scope}", URI.encodeQuery((String)StringUtil.safe((String)this.scopeLabel), (boolean)false).replace("+", "%2B").replace("&", "%26"));
            OS.INSTANCE.openSystemBrowser(resolvedURI);
            this.update(this.getURI(), this.getText(), this.getToolTipText(), AnimationStyle.NONE, false, this.buttonColor, this.scopeLabel);
        }

        public URI getURI() {
            return this.uri;
        }

        public void update(URI uri, String text, String tooltip, AnimationStyle animationStyle, boolean highlight, Color color, String scopeLabel) {
            this.scopeLabel = scopeLabel;
            if (!(ObjectUtil.equals((Object)uri, (Object)this.uri) && this.animationStyle == animationStyle && ObjectUtil.equals((Object)text, (Object)this.getText()) && ObjectUtil.equals((Object)tooltip, (Object)this.getToolTipText()) && ObjectUtil.equals((Object)color, (Object)this.buttonColor) && this.highlight == highlight)) {
                this.uri = uri;
                this.highlight = highlight;
                this.animator = null;
                this.animationStyle = animationStyle;
                this.buttonColor = color;
                this.offset = animationStyle != AnimationStyle.NONE ? 22 : 0;
                this.setVisible(uri != null);
                this.setBackground(highlight ? this.buttonColor : COLOR_SUBTLE);
                this.setText(text);
                this.setToolTipText(tooltip);
                this.getParent().getParent().layout(true);
                this.redraw();
            }
        }

        protected void onHover() {
            if (this.isHover()) {
                this.animator = null;
                this.offset = 0;
                this.setBackground(this.buttonColor);
                this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/star_black.png"));
            } else {
                this.setBackground(this.highlight ? this.buttonColor : COLOR_SUBTLE);
                this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/star_white.png"));
                this.offset = this.animationStyle == AnimationStyle.REPEAT ? 22 : 0;
            }
        }

        protected void onFocusIn(Event event) {
            this.animator = null;
            this.offset = 0;
            this.setBackground(this.buttonColor);
            this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/star_black.png"));
        }

        protected void onFocusOut(Event event) {
            this.setBackground(this.highlight ? this.buttonColor : COLOR_SUBTLE);
            this.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/star_white.png"));
            this.offset = this.animationStyle == AnimationStyle.REPEAT ? 22 : 0;
            this.redraw();
        }

        protected Point getTotalSize() {
            Point totalSize = super.getTotalSize();
            totalSize.x += 20;
            totalSize.y += 8;
            return totalSize;
        }

        private int getEffectiveOffset() {
            return this.isHover() || this.isFocusControl() ? (this.direction == 1 ? 0 : -10) : (this.direction == 1 ? this.offset * this.direction : this.offset * this.direction - 10);
        }

        protected void drawFocusState(GC gc, int x, int y, int width, int height) {
            super.drawFocusState(gc, x, y + this.getEffectiveOffset(), width, height + 10);
        }

        public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
            if (this.animationStyle != AnimationStyle.NONE && this.animator == null) {
                this.animator = new Animator();
                UIUtil.timerExec((int)1000, (Runnable)this.animator);
            }
            super.drawBackground(gc, x, y + this.getEffectiveOffset(), width, height + 10, offsetX, offsetY);
        }

        protected void drawText(GC gc, int x, int y) {
            int effectiveOffset = this.getEffectiveOffset();
            if (effectiveOffset != 22) {
                super.drawText(gc, x + 10, y + effectiveOffset + (this.direction == 0 ? 0 : 9));
            }
        }

        protected void drawImage(GC gc, int x, int y) {
            int effectiveOffset = this.getEffectiveOffset();
            if (effectiveOffset != 22) {
                super.drawImage(gc, x + 10, y + effectiveOffset + (this.direction == 0 ? 0 : 9));
            }
        }

        protected boolean hasOpenedBrandingNotificationURI(URI uri) {
            return false;
        }

        public void setBrandingNotificationScope(List<ProductCatalog> productCatalogs) {
            if (productCatalogs != null) {
                int targetPriority = Integer.MAX_VALUE;
                ProductCatalog targetProductCatalog = null;
                for (ProductCatalog productCatalog : productCatalogs) {
                    int priority;
                    if (!SimpleProductPage.isIncluded(productCatalog) || (priority = NotifictionButton.getBrandingNotificationPriority((Scope)productCatalog)) >= targetPriority && (targetProductCatalog != null || NotifictionButton.getBrandingNotificationURI((Scope)productCatalog) == null)) continue;
                    targetPriority = priority;
                    targetProductCatalog = productCatalog;
                }
                if (targetProductCatalog != null) {
                    this.setBrandingNotificationScope((Scope)targetProductCatalog);
                }
            }
        }

        public void setBrandingNotificationScope(Scope scope) {
            boolean hasOpenedBrandingNotificationURI;
            URI notificationURI = NotifictionButton.getBrandingNotificationURI(scope);
            String notificationLabel = NotifictionButton.getBrandingNotificationLabel(scope);
            String notificationTooltip = NotifictionButton.getBrandingNotificationTooltip(scope);
            String brandingNotificationScopeLabel = NotifictionButton.getBrandingNotificationScopeLabel(scope);
            if (brandingNotificationScopeLabel == null) {
                brandingNotificationScopeLabel = NotifictionButton.getImplicitBrandingNotificationLabel(scope);
            }
            this.update(notificationURI, notificationLabel, notificationTooltip, (hasOpenedBrandingNotificationURI = this.hasOpenedBrandingNotificationURI(notificationURI)) ? AnimationStyle.NONE : NotifictionButton.getBrandingNotificationAnimationStyle(scope), !hasOpenedBrandingNotificationURI, NotifictionButton.getBrandingNotificationColor(scope), brandingNotificationScopeLabel);
        }

        private static int getBrandingNotificationPriority(Scope scope) {
            String detail;
            Annotation annotation;
            if (scope != null && (annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo")) != null && (detail = (String)annotation.getDetails().get((Object)"notificationPriority")) != null) {
                try {
                    return Integer.parseInt(detail);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return Integer.MAX_VALUE;
        }

        private static URI getBrandingNotificationURI(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationURI")) != null) {
                    return URI.createURI((String)detail);
                }
                return NotifictionButton.getBrandingNotificationURI(scope.getParentScope());
            }
            return null;
        }

        private static String getBrandingNotificationLabel(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationLabel")) != null) {
                    return detail;
                }
                return NotifictionButton.getBrandingNotificationLabel(scope.getParentScope());
            }
            return null;
        }

        private static String getImplicitBrandingNotificationLabel(Scope scope) {
            String label;
            if (scope != null && (label = scope.getLabel()) != null) {
                String projectLabel;
                Scope parentScope = scope.getParentScope();
                if (parentScope instanceof Product && (projectLabel = parentScope.getLabel()) != null) {
                    return projectLabel + "-" + label;
                }
                return label;
            }
            return null;
        }

        private static String getBrandingNotificationScopeLabel(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationScope")) != null) {
                    return detail;
                }
                return NotifictionButton.getBrandingNotificationScopeLabel(scope.getParentScope());
            }
            return null;
        }

        private static Color getBrandingNotificationColor(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationColor")) != null) {
                    try {
                        return ExtendedColorRegistry.INSTANCE.getColor(COLOR_WHITE, COLOR_DEFAULT_FOCUS_FOREGROUND, (Object)URI.createURI((String)detail));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return NotifictionButton.getBrandingNotificationColor(scope.getParentScope());
            }
            return COLOR_INTENSE;
        }

        private static String getBrandingNotificationTooltip(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationTooltip")) != null) {
                    return detail;
                }
                return NotifictionButton.getBrandingNotificationTooltip(scope.getParentScope());
            }
            return null;
        }

        private static AnimationStyle getBrandingNotificationAnimationStyle(Scope scope) {
            if (scope != null) {
                String detail;
                Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"notificationAnimationStyle")) != null) {
                    try {
                        return AnimationStyle.valueOf(detail);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return NotifictionButton.getBrandingNotificationAnimationStyle(scope.getParentScope());
            }
            return AnimationStyle.NONE;
        }

        private static enum AnimationStyle {
            NONE,
            ONCE,
            REPEAT;

        }

        private class Animator
        implements Runnable {
            private Animator() {
            }

            @Override
            public void run() {
                if (NotifictionButton.this.animator == this && !NotifictionButton.this.isDisposed()) {
                    NotifictionButton.this.redraw();
                    --NotifictionButton.this.offset;
                    if (NotifictionButton.this.offset == -1) {
                        if (NotifictionButton.this.animationStyle == AnimationStyle.REPEAT) {
                            NotifictionButton.this.offset = 22;
                            UIUtil.timerExec((int)500, (Runnable)NotifictionButton.this.animator);
                        } else {
                            NotifictionButton.this.offset = 0;
                        }
                    } else if (NotifictionButton.this.offset == 0) {
                        if (NotifictionButton.this.animationStyle == AnimationStyle.REPEAT) {
                            UIUtil.timerExec((int)2000, (Runnable)NotifictionButton.this.animator);
                        }
                    } else {
                        UIUtil.timerExec((int)100, (Runnable)NotifictionButton.this.animator);
                    }
                }
            }
        }
    }

    private static final class PageStack
    extends LinkedList<SimpleInstallerPage> {
        private static final long serialVersionUID = 1L;

        private PageStack() {
        }

        @Override
        public void push(SimpleInstallerPage page) {
            this.addLast(page);
        }

        @Override
        public SimpleInstallerPage pop() {
            return (SimpleInstallerPage)((Object)this.removeLast());
        }

        @Override
        public SimpleInstallerPage peek() {
            return this.isEmpty() ? null : (SimpleInstallerPage)((Object)this.getLast());
        }
    }

    private final class UpdateSearcher
    extends Thread {
        private Display display;

        public UpdateSearcher(Display display) {
            super(Messages.SimpleInstallerDialog_UpdateSearcher_job);
            this.display = display;
        }

        @Override
        public void run() {
            try {
                User user = SimpleInstallerDialog.this.getInstaller().getUser();
                SimpleInstallerDialog.this.updateResolution = SelfUpdate.resolve(user, null);
                if (SimpleInstallerDialog.this.updateResolution != null && !this.display.isDisposed()) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SimpleInstallerDialog.this.updateAvailable(true);
                        }
                    });
                }
            }
            catch (CoreException ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
    }
}

