/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.Storage;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.util.StringUtil;

public final class StorageServiceRegistry
implements IStorageService.Registry {
    public static final StorageServiceRegistry INSTANCE = new StorageServiceRegistry();
    private static final ExtensionPointHandler HANDLER = new ExtensionPointHandler();
    private static final String PREFIX = "org.eclipse.userstorage.";
    private static final String SERVICE_LABEL = "serviceLabel";
    private static final String SERVICE_URI = "serviceURI";
    private static final String CREATE_ACCOUNT_URI = "createAccountURI";
    private static final String EDIT_ACCOUNT_URI = "editAccountURI";
    private static final String RECOVER_PASSWORD_URI = "recoverPasswordURI";
    private static final String TERMS_OF_USE_LINK = "termsOfUseLink";
    private static final String DEFAULT_SERVICE_LABEL = "Eclipse.org";
    private static final String DEFAULT_SERVICE_URI = "https://api.eclipse.org/";
    private static final String STAGING_SERVICE_URI = "https://api-staging.eclipse.org/";
    private final List<IStorageService.Registry.Listener> listeners = new CopyOnWriteArrayList<IStorageService.Registry.Listener>();
    private final Set<WeakReference<Storage>> storages = new HashSet<WeakReference<Storage>>();
    private final Map<URI, IStorageService> services = new LinkedHashMap<URI, IStorageService>();
    private boolean running;

    private StorageServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStorageService[] getServices() {
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            this.start();
            return this.services.values().toArray(new IStorageService[this.services.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageService getService(URI serviceURI) {
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            this.start();
            return (StorageService)this.services.get(serviceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageService getFirstService() {
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            block4: {
                this.start();
                if (!this.services.isEmpty()) break block4;
                return null;
            }
            return (StorageService)this.services.values().iterator().next();
        }
    }

    @Override
    public IStorageService.Dynamic addService(String serviceLabel, URI serviceURI, URI createAccountURI, URI editAccountURI, URI recoverPasswordURI, String termsOfUseLink) throws IllegalStateException {
        StorageService.DynamicService service = new StorageService.DynamicService(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
        this.addService(service);
        ISecurePreferences securePreferences = service.getSecurePreferences();
        if (securePreferences != null) {
            try {
                securePreferences.put(SERVICE_LABEL, serviceLabel, false);
                securePreferences.put(SERVICE_URI, serviceURI.toString(), false);
                StorageServiceRegistry.setSecurePreference(securePreferences, CREATE_ACCOUNT_URI, createAccountURI);
                StorageServiceRegistry.setSecurePreference(securePreferences, EDIT_ACCOUNT_URI, editAccountURI);
                StorageServiceRegistry.setSecurePreference(securePreferences, RECOVER_PASSWORD_URI, recoverPasswordURI);
                securePreferences.flush();
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
        return service;
    }

    @Override
    public IStorageService.Dynamic addService(String serviceLabel, URI serviceURI) throws IllegalStateException {
        return this.addService(serviceLabel, serviceURI, null, null, null, null);
    }

    @Override
    public IStorageService.Dynamic[] refresh() {
        ArrayList<StorageService.DynamicService> result = new ArrayList<StorageService.DynamicService>();
        ISecurePreferences securePreferences = Activator.getSecurePreferences();
        if (securePreferences != null) {
            String[] stringArray = securePreferences.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    URI serviceURI;
                    ISecurePreferences child = securePreferences.node(name);
                    String serviceLabel = child.get(SERVICE_LABEL, null);
                    if (!StringUtil.isEmpty(serviceLabel) && (serviceURI = StringUtil.newURI(child.get(SERVICE_URI, null))) != null && StringUtil.encodeURI(serviceURI).equals(name)) {
                        URI createAccountURI = StringUtil.newURI(child.get(CREATE_ACCOUNT_URI, null));
                        URI editAccountURI = StringUtil.newURI(child.get(EDIT_ACCOUNT_URI, null));
                        URI recoverPasswordURI = StringUtil.newURI(child.get(RECOVER_PASSWORD_URI, null));
                        String termsOfUseLink = child.get(TERMS_OF_USE_LINK, null);
                        StorageService.DynamicService service = new StorageService.DynamicService(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
                        this.addService(service);
                        result.add(service);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return result.toArray(new IStorageService.Dynamic[result.size()]);
    }

    @Override
    public void addListener(IStorageService.Registry.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IStorageService.Registry.Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStorage(Storage storage) {
        Set<WeakReference<Storage>> set = this.storages;
        synchronized (set) {
            this.storages.add(new WeakReference<Storage>(storage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addService(IStorageService service) throws IllegalStateException {
        URI serviceURI = service.getServiceURI();
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            this.start();
            IStorageService registered = this.services.get(serviceURI);
            if (registered != null) {
                throw new IllegalStateException("Service already registered: " + registered);
            }
            this.services.put(serviceURI, service);
        }
        for (IStorageService.Registry.Listener listener : this.listeners) {
            try {
                listener.serviceAdded(service);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeService(IStorageService service) {
        URI serviceURI = service.getServiceURI();
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            this.start();
            this.services.remove(serviceURI);
        }
        for (IStorageService.Registry.Listener listener : this.listeners) {
            try {
                listener.serviceRemoved(service);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
        ArrayList<Storage> storagesToNotify = new ArrayList<Storage>();
        Set<WeakReference<Storage>> set = this.storages;
        synchronized (set) {
            Iterator<WeakReference<Storage>> it = this.storages.iterator();
            while (it.hasNext()) {
                WeakReference<Storage> ref = it.next();
                Storage storage = (Storage)ref.get();
                if (storage != null) {
                    storagesToNotify.add(storage);
                    continue;
                }
                it.remove();
            }
        }
        for (Storage storage : storagesToNotify) {
            storage.serviceRemoved(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            if (!this.running) {
                this.running = true;
                try {
                    URI serviceURI = StringUtil.newURI(System.getProperty("org.eclipse.userstorage.serviceURI", null));
                    if (serviceURI == null) {
                        serviceURI = Boolean.getBoolean("org.eclipse.userstorage.staging") ? StringUtil.newURI(STAGING_SERVICE_URI) : StringUtil.newURI(DEFAULT_SERVICE_URI);
                    }
                    if (serviceURI != null) {
                        String serviceLabel = System.getProperty("org.eclipse.userstorage.serviceLabel", DEFAULT_SERVICE_LABEL);
                        URI createAccountURI = StringUtil.newURI(StorageServiceRegistry.getValue(serviceURI, CREATE_ACCOUNT_URI, "https://dev.eclipse.org/site_login/"));
                        URI editAccountURI = StringUtil.newURI(StorageServiceRegistry.getValue(serviceURI, EDIT_ACCOUNT_URI, "https://dev.eclipse.org/site_login/myaccount.php"));
                        URI recoverPasswordURI = StringUtil.newURI(StorageServiceRegistry.getValue(serviceURI, RECOVER_PASSWORD_URI, "https://dev.eclipse.org/site_login/password_recovery.php"));
                        String termsOfUseLink = StorageServiceRegistry.getValue(serviceURI, TERMS_OF_USE_LINK, "I agree the use of this service is governed by the Eclipse Foundation <a href='http://www.eclipse.org/legal/services/termsofuse.php'>Terms of Use</a> and the Eclipse Foundation <a href='http://www.eclipse.org/legal/services/privacy.php'>Privacy Policy</a>.");
                        StorageService eclipseStorage = new StorageService(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
                        this.services.put(eclipseStorage.getServiceURI(), eclipseStorage);
                    }
                    if (Activator.PLATFORM_RUNNING) {
                        HANDLER.start();
                    }
                    this.refresh();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Map<URI, IStorageService> map = this.services;
        synchronized (map) {
            if (this.running) {
                this.running = false;
                try {
                    if (Activator.PLATFORM_RUNNING) {
                        HANDLER.stop();
                    }
                    this.services.clear();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        }
    }

    private static String getValue(URI serviceURI, String property, String defaultValue) {
        String authority;
        String value = System.getProperty(PREFIX + property);
        if (StringUtil.isEmpty(value) && (authority = serviceURI.getAuthority()) != null && authority.endsWith(".eclipse.org")) {
            value = defaultValue;
        }
        return value;
    }

    private static void setSecurePreference(ISecurePreferences securePreferences, String key, URI uri) throws StorageException {
        if (uri != null) {
            securePreferences.put(key, uri.toString(), false);
        } else {
            securePreferences.remove(key);
        }
    }

    private static final class ExtensionPointHandler
    implements IRegistryEventListener {
        private static final String EXTENSION_POINT = "org.eclipse.userstorage.storages";

        public void start() throws Exception {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                this.added(configurationElement);
                ++n2;
            }
            extensionRegistry.addListener((IRegistryEventListener)this, EXTENSION_POINT);
        }

        public void stop() throws Exception {
            Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this);
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.added(configurationElement);
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.removed(configurationElement);
                    ++n4;
                }
                ++n2;
            }
        }

        private void added(IConfigurationElement configurationElement) {
            try {
                StorageService storage = this.createStorage(configurationElement);
                INSTANCE.addService(storage);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }

        private void removed(IConfigurationElement configurationElement) {
            try {
                StorageService storage = this.createStorage(configurationElement);
                INSTANCE.removeService(storage);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }

        private StorageService createStorage(IConfigurationElement configurationElement) {
            String serviceLabel = configurationElement.getAttribute(StorageServiceRegistry.SERVICE_LABEL);
            URI serviceURI = StringUtil.newURI(configurationElement.getAttribute(StorageServiceRegistry.SERVICE_URI));
            URI createAccountURI = StringUtil.newURI(configurationElement.getAttribute(StorageServiceRegistry.CREATE_ACCOUNT_URI));
            URI editAccountURI = StringUtil.newURI(configurationElement.getAttribute(StorageServiceRegistry.EDIT_ACCOUNT_URI));
            URI recoverPasswordURI = StringUtil.newURI(configurationElement.getAttribute(StorageServiceRegistry.RECOVER_PASSWORD_URI));
            String termsOfUseLink = configurationElement.getAttribute(StorageServiceRegistry.TERMS_OF_USE_LINK);
            return new StorageService(serviceLabel, serviceURI, createAccountURI, editAccountURI, recoverPasswordURI, termsOfUseLink);
        }
    }
}

