/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.e4.ui.internal.workspace.markers.Translation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionRelevance;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class QuickFixPage
extends WizardPage {
    private Map<IMarkerResolution, Collection<IMarker>> resolutions;
    private TableViewer resolutionsList;
    private CheckboxTableViewer markersTable;
    private IMarker[] selectedMarkers;
    private final Consumer<StructuredViewer> showMarkers;
    private final Consumer<Control> bindHelp;

    public QuickFixPage(String problemDescription, IMarker[] selectedMarkers, Map<IMarkerResolution, Collection<IMarker>> resolutions, Consumer<StructuredViewer> showMarkers, Consumer<Control> bindHelp) {
        super(problemDescription);
        this.selectedMarkers = selectedMarkers;
        this.resolutions = resolutions;
        this.showMarkers = showMarkers;
        this.bindHelp = bindHelp;
        this.setTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
        this.setMessage(problemDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        this.bindHelp.accept((Control)control);
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.spacing = this.convertHorizontalDLUsToPixels(4);
        control.setLayout((Layout)layout);
        Label resolutionsLabel = new Label(control, 0);
        resolutionsLabel.setText(MarkerMessages.MarkerResolutionDialog_Resolutions_List_Title);
        resolutionsLabel.setLayoutData((Object)new FormData());
        this.createResolutionsList(control);
        FormData listData = new FormData();
        listData.top = new FormAttachment((Control)resolutionsLabel, 0);
        listData.left = new FormAttachment(0);
        listData.right = new FormAttachment(100, 0);
        listData.height = this.convertHeightInCharsToPixels(10);
        this.resolutionsList.getControl().setLayoutData((Object)listData);
        Label title = new Label(control, 0);
        title.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Title);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(this.resolutionsList.getControl(), 0);
        labelData.left = new FormAttachment(0);
        title.setLayoutData((Object)labelData);
        this.createMarkerTable(control);
        Composite buttons = this.createTableButtons(control);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)title, 0);
        buttonData.right = new FormAttachment(100);
        buttonData.height = this.convertHeightInCharsToPixels(10);
        buttons.setLayoutData((Object)buttonData);
        FormData tableData = new FormData();
        tableData.top = new FormAttachment((Control)buttons, 0, 128);
        tableData.left = new FormAttachment(0);
        tableData.bottom = new FormAttachment(100);
        tableData.right = new FormAttachment((Control)buttons, 0);
        tableData.height = this.convertHeightInCharsToPixels(10);
        this.markersTable.getControl().setLayoutData((Object)tableData);
        Dialog.applyDialogFont((Control)control);
        this.resolutionsList.setSelection((ISelection)new StructuredSelection(this.resolutionsList.getElementAt(0)));
        this.markersTable.setCheckedElements((Object[])this.selectedMarkers);
        this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
    }

    private Composite createTableButtons(Composite control) {
        Composite buttonComposite = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(MarkerMessages.selectAllAction_title);
        selectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                QuickFixPage.this.markersTable.setAllChecked(true);
                QuickFixPage.this.setPageComplete(!QuickFixPage.this.resolutionsList.getStructuredSelection().isEmpty());
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText(MarkerMessages.filtersDialog_deselectAll);
        deselectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                QuickFixPage.this.markersTable.setAllChecked(false);
                QuickFixPage.this.setPageComplete(false);
            }
        });
        return buttonComposite;
    }

    private void createResolutionsList(Composite control) {
        this.resolutionsList = new TableViewer(control, 2564);
        this.resolutionsList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMarkerResolution)element).getLabel();
            }

            public Image getImage(Object element) {
                return element instanceof IMarkerResolution2 ? ((IMarkerResolution2)element).getImage() : null;
            }
        });
        this.resolutionsList.setInput((Object)this.resolutions.keySet().toArray());
        this.resolutionsList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int relevanceMarker2;
                int relevanceMarker1 = e1 instanceof IMarkerResolutionRelevance ? ((IMarkerResolutionRelevance)e1).getRelevanceForResolution() : 0;
                int c = Integer.compare(relevanceMarker1, relevanceMarker2 = e2 instanceof IMarkerResolutionRelevance ? ((IMarkerResolutionRelevance)e2).getRelevanceForResolution() : 0);
                if (c != 0) {
                    return c;
                }
                return ((IMarkerResolution)e1).getLabel().compareTo(((IMarkerResolution)e2).getLabel());
            }
        });
        this.resolutionsList.addSelectionChangedListener(event -> {
            this.markersTable.refresh();
            this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
        });
    }

    private void createMarkerTable(Composite control) {
        this.markersTable = CheckboxTableViewer.newCheckList((Composite)control, (int)2564);
        this.createTableColumns();
        this.markersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private final IMarker[] noMarkers = new IMarker[0];

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IMarkerResolution resolution;
                Optional<IMarkerResolution> selected = QuickFixPage.this.getSelectedMarkerResolution();
                if (selected.isPresent() && QuickFixPage.this.resolutions.containsKey(resolution = selected.get())) {
                    return QuickFixPage.this.resolutions.get(resolution).toArray();
                }
                return this.noMarkers;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.markersTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            private final Translation translation = new Translation();

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return Util.getImage(((IMarker)element).getAttribute("severity", -1));
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IMarker marker = (IMarker)element;
                if (columnIndex == 0) {
                    return this.translation.name(marker).orElse("");
                }
                String locationString = marker.getAttribute("location", "");
                if (!"".equals(locationString)) {
                    return locationString;
                }
                int lineNumber = marker.getAttribute("lineNumber", -1);
                String lineNumberString = null;
                lineNumberString = lineNumber < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(lineNumber));
                return lineNumberString;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.markersTable.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
            }
        });
        this.showMarkers.accept((StructuredViewer)this.markersTable);
        this.markersTable.setInput((Object)this);
    }

    private void createTableColumns() {
        TableLayout layout = new TableLayout();
        Table table = this.markersTable.getTable();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Location);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tc = new TableColumn(table, 0, 0);
        tc.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Resource);
    }

    public IMarker getSelectedMarker() {
        IStructuredSelection struct;
        IStructuredSelection selection = this.markersTable.getStructuredSelection();
        if (!selection.isEmpty() && (struct = selection).size() == 1) {
            return (IMarker)struct.getFirstElement();
        }
        return null;
    }

    Optional<IMarkerResolution> getSelectedMarkerResolution() {
        return Optional.ofNullable((IMarkerResolution)this.resolutionsList.getStructuredSelection().getFirstElement());
    }

    IMarker[] getCheckedMarkers() {
        Object[] checked = this.markersTable.getCheckedElements();
        IMarker[] markers = new IMarker[checked.length];
        System.arraycopy(checked, 0, markers, 0, checked.length);
        return markers;
    }
}

