/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.edit.BaseAdapterFactoryEditingDomain;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.util.StringUtil;

public class SetupTaskContainerItemProvider
extends ModelElementItemProvider {
    public SetupTaskContainerItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        return this.getString("_UI_SetupTaskContainer_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(SetupTaskContainer.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private void collectNewChildDescriptorsGen(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createInstallationTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createWorkspaceTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createCompoundTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createVariableTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createStringSubstitutionTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createRedirectionTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createEclipseIniTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createLinkLocationTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createPreferenceTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createResourceCopyTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createResourceCreationTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createTextModifyTask()));
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.SETUP_TASK_CONTAINER__SETUP_TASKS, SetupFactory.eINSTANCE.createMacroTask()));
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        this.collectNewChildDescriptorsGen(newChildDescriptors, object);
        SetupTaskContainerItemProvider.removeUnwantedTasks(newChildDescriptors, object);
    }

    public static void removeUnwantedTasks(Collection<Object> newChildDescriptors, Object object) {
        boolean catalog = object instanceof ProductCatalog || object instanceof ProjectCatalog;
        Iterator<Object> it = newChildDescriptors.iterator();
        while (it.hasNext()) {
            Object newChildDescriptor = it.next();
            if (!(newChildDescriptor instanceof CommandParameter)) continue;
            Object value = ((CommandParameter)newChildDescriptor).getValue();
            if (SetupTaskContainerItemProvider.isDeprecated(value)) {
                it.remove();
                continue;
            }
            if (catalog || !(value instanceof InstallationTask) && !(value instanceof WorkspaceTask)) continue;
            it.remove();
        }
    }

    public static boolean isDeprecated(Object value) {
        Deprecated annotation;
        return value != null && (annotation = value.getClass().getAnnotation(Deprecated.class)) != null;
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        return super.factorAddCommand(domain, SetupTaskContainerItemProvider.transformCommandParameter(domain, commandParameter));
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return SetupTaskContainerItemProvider.createAddCommandWithMacroTaskSupport(domain, owner, feature, collection, index);
    }

    public static Command createAddCommandWithMacroTaskSupport(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return new AddCommand(domain, owner, feature, collection, index){

            public void doExecute() {
                super.doExecute();
                if (this.domain instanceof BaseAdapterFactoryEditingDomain) {
                    ((BaseAdapterFactoryEditingDomain)this.domain).handledAdditions(this.collection);
                }
            }
        };
    }

    public static CommandParameter transformCommandParameter(EditingDomain domain, CommandParameter commandParameter) {
        EObject eOwner;
        Collection collection = commandParameter.getCollection();
        if (collection != null && !collection.isEmpty() && (eOwner = commandParameter.getEOwner()) != null) {
            ArrayList<Object> augmentedCollection = new ArrayList<Object>();
            for (Object object : collection) {
                Object unwrappedObject = AdapterFactoryEditingDomain.unwrap(object);
                if (unwrappedObject instanceof Macro) {
                    Macro macro = (Macro)unwrappedObject;
                    if (macro.eResource() != null) {
                        MacroTask macroTask = SetupTaskContainerItemProvider.createMacroTask((SetupTaskContainer)eOwner, macro);
                        augmentedCollection.add(macroTask);
                        continue;
                    }
                    augmentedCollection.add(macro);
                    continue;
                }
                augmentedCollection.add(object);
            }
            return new CommandParameter(commandParameter.getOwner(), commandParameter.getFeature(), commandParameter.getValue(), augmentedCollection, commandParameter.getIndex());
        }
        return commandParameter;
    }

    private static String getID(String label) {
        if (StringUtil.isEmpty((String)label)) {
            return "macro";
        }
        String lowerCaseLabel = label.toLowerCase();
        List explode = StringUtil.explode((String)lowerCaseLabel.replaceAll("[^\\p{IsAlphabetic}\\p{Digit}]", "."), (String)".");
        explode.removeAll(Collections.singleton(""));
        String implode = StringUtil.implode((List)explode, (char)'.');
        if (StringUtil.isEmpty((String)implode)) {
            return "macro";
        }
        if (!Character.isAlphabetic(implode.charAt(0))) {
            return "_" + implode;
        }
        return implode;
    }

    public static MacroTask createMacroTask(SetupTaskContainer setupTaskContainer, Macro macro) {
        MacroTask macroTask = SetupFactory.eINSTANCE.createMacroTask();
        macroTask.setMacro(macro);
        String id = SetupTaskContainerItemProvider.getID(macro.getName());
        Object uniqueID = id;
        Resource resource = setupTaskContainer.eResource();
        if (resource != null) {
            int count = 0;
            while (resource.getEObject((String)uniqueID) != null) {
                uniqueID = Character.isDigit(id.charAt(id.length() - 1)) ? id + "_" + ++count : id + ++count;
            }
        }
        macroTask.setID((String)uniqueID);
        EList parameters = macro.getParameters();
        if (!parameters.isEmpty()) {
            EList arguments = macroTask.getArguments();
            for (Parameter parameter : parameters) {
                Argument argument = SetupFactory.eINSTANCE.createArgument();
                argument.setParameter(parameter);
                if (parameter.getDefaultValue() == null) {
                    String parameterName = parameter.getName();
                    argument.setValue(parameterName + "_value");
                }
                arguments.add(argument);
            }
        }
        return macroTask;
    }
}

