/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ConfigurationActivator
implements BundleActivator,
IBundleGroupProvider,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    public static String OPTION_DEBUG = PI_CONFIGURATOR + "/debug";
    public static boolean DEBUG = false;
    private static BundleContext context;
    private ServiceRegistration<IPlatformConfigurationFactory> configurationFactorySR;
    ServiceRegistration<?> bundleGroupProviderSR;
    private PlatformConfiguration configuration;
    private Location configLocation;
    private static ConfigurationActivator configurator;

    public ConfigurationActivator() {
        configurator = this;
    }

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
        try {
            this.initialize();
        }
        catch (Exception e) {
            Utils.shutdown();
            throw e;
        }
        Utils.debug("Starting update configurator...");
    }

    private void initialize() throws Exception {
        this.configLocation = Utils.getConfigurationLocation();
        if (!this.configLocation.isReadOnly()) {
            try {
                URL privateURL = new URL(this.configLocation.getURL(), NAME_SPACE);
                File f = new File(privateURL.getFile());
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.configurationFactorySR = context.registerService(IPlatformConfigurationFactory.class, (Object)new PlatformConfigurationFactory(), null);
        this.configuration = this.getPlatformConfiguration(Utils.getInstallURL(), this.configLocation);
        if (this.configuration == null) {
            throw Utils.newCoreException(NLS.bind((String)Messages.ConfigurationActivator_createConfig, (Object[])new String[]{this.configLocation.getURL().toExternalForm()}), null);
        }
    }

    public void stop(BundleContext ctx) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configurationFactorySR.unregister();
        if (this.bundleGroupProviderSR != null) {
            this.bundleGroupProviderSR.unregister();
        }
        Utils.shutdown();
    }

    private PlatformConfiguration getPlatformConfiguration(URL installURL, Location configLocation) {
        try {
            PlatformConfiguration.startup(installURL, configLocation);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            Utils.log(Utils.newStatus(message, e));
        }
        return PlatformConfiguration.getCurrent();
    }

    private void loadOptions() {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class);
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public String getName() {
        return Messages.BundleGroupProvider;
    }

    public IBundleGroup[] getBundleGroups() {
        if (this.configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] features = this.configuration.getConfiguredFeatureEntries();
        ArrayList<IBundleGroup> bundleGroups = new ArrayList<IBundleGroup>(features.length);
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformConfiguration.IFeatureEntry feature = iFeatureEntryArray[n2];
            if (feature instanceof FeatureEntry && ((FeatureEntry)feature).hasBranding()) {
                bundleGroups.add((IBundleGroup)feature);
            }
            ++n2;
        }
        return bundleGroups.toArray(new IBundleGroup[bundleGroups.size()]);
    }

    public static ConfigurationActivator getConfigurator() {
        return configurator;
    }

    private void acquireFrameworkLogService() {
        ServiceReference logServiceReference = context.getServiceReference(FrameworkLog.class);
        if (logServiceReference == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }
}

