/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.presentation.sync;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.provider.PreferencesEditPlugin;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.presentation.ProjectConfigEditorPlugin;
import org.eclipse.oomph.projectconfig.presentation.sync.Messages;
import org.eclipse.oomph.projectconfig.presentation.sync.ProjectConfigSynchronizerPreferences;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ProjectConfigSynchronizerDialog
extends TitleAreaDialog {
    private WorkspaceConfiguration workspaceConfiguration;
    private InputItem managedPropertiesInput;
    private TreeViewer managedPropertiesViewer;
    private InputItem unmanagedPropertiesInput;
    private TreeViewer unmanagedPropertiesViewer;
    private Composite container;
    private boolean propagate = ProjectConfigSynchronizerPreferences.isPropagate();
    private boolean edit = ProjectConfigSynchronizerPreferences.isEdit();

    public ProjectConfigSynchronizerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68656);
    }

    public boolean hasUnmanagedProperties() {
        return this.unmanagedPropertiesInput != null;
    }

    public boolean hasManagedProperties() {
        return this.managedPropertiesInput != null;
    }

    public int open() {
        if (this.managedPropertiesInput != null || this.unmanagedPropertiesInput != null) {
            return super.open();
        }
        return 0;
    }

    protected Point getInitialSize() {
        Point size = this.getParentShell().getSize();
        size.x = size.x * 3 / 4;
        size.y = size.y * 3 / 4;
        return size;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point size = this.getParentShell().getSize();
        size.x /= 4;
        size.y /= 4;
        return size;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public void setWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration) {
        this.workspaceConfiguration = workspaceConfiguration;
        if (this.managedPropertiesInput != null) {
            this.managedPropertiesInput.setWorkspaceConfiguration(workspaceConfiguration);
        }
        if (this.unmanagedPropertiesInput != null) {
            this.unmanagedPropertiesInput.setWorkspaceConfiguration(workspaceConfiguration);
        }
    }

    public void unmanagedProperty(Property property, Property oldProperty) {
        if (this.unmanagedPropertiesInput == null) {
            this.unmanagedPropertiesInput = new InputItem(this.workspaceConfiguration);
        }
        this.unmanagedPropertiesInput.getProperty(property, oldProperty);
        if (this.unmanagedPropertiesViewer != null) {
            this.unmanagedPropertiesViewer.setInput((Object)this.unmanagedPropertiesInput);
            this.unmanagedPropertiesViewer.expandAll();
        } else if (this.container != null) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            this.createUI(this.container);
            this.container.layout();
        }
    }

    public void managedProperty(Property managedProperty, Property managingProperty) {
        if (this.managedPropertiesInput == null) {
            this.managedPropertiesInput = new InputItem(this.workspaceConfiguration);
        }
        this.managedPropertiesInput.getProperty(managedProperty, managingProperty);
        if (this.managedPropertiesViewer != null) {
            this.managedPropertiesViewer.setInput((Object)this.managedPropertiesInput);
            this.managedPropertiesViewer.expandAll();
        } else if (this.container != null) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            this.createUI(this.container);
            this.container.layout();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.ProjectConfigSynchronizerDialog_ModificationProblem_label);
        shell.setImage(ExtendedImageRegistry.INSTANCE.getImage(ProjectConfigEditorPlugin.INSTANCE.getImage("full/obj16/ProjectConfigModelFile")));
        this.setTitle("bar");
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.container = new Composite(area, 0);
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.ProjectConfigSynchronizerDialog_ProjectSpecificPreferenceModification_label);
        this.setErrorMessage(Messages.ProjectConfigSynchronizerDialog_UnmanagedPropertyModified_message);
        this.createUI(this.container);
        shell.setActive();
        return area;
    }

    protected void createUI(Composite container) {
        Label label;
        if (this.managedPropertiesInput != null) {
            label = new Label(container, 0);
            label.setText(Messages.ProjectConfigSynchronizerDialog_ModifiedManagedProperties_label);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Composite composite = new Composite(container, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Button overWriteButton = new Button(composite, 16);
            overWriteButton.setText(Messages.ProjectConfigSynchronizerDialog_Overwite_message);
            if (!this.propagate) {
                overWriteButton.setSelection(true);
            }
            overWriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectConfigSynchronizerDialog.this.propagate = false;
                    ProjectConfigSynchronizerPreferences.setPropagate(false);
                    ProjectConfigSynchronizerPreferences.flush();
                }
            });
            Button propogateButton = new Button(composite, 16);
            propogateButton.setText(Messages.ProjectConfigSynchronizerDialog_Propagate_label);
            if (this.propagate) {
                propogateButton.setSelection(true);
            }
            propogateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectConfigSynchronizerDialog.this.propagate = true;
                    ProjectConfigSynchronizerPreferences.setPropagate(true);
                    ProjectConfigSynchronizerPreferences.flush();
                }
            });
            this.managedPropertiesViewer = new TreeViewer(container, 66304);
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            this.managedPropertiesViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.managedPropertiesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            final Tree tree = this.managedPropertiesViewer.getTree();
            tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            tree.setLinesVisible(true);
            tree.setHeaderVisible(true);
            this.managedPropertiesViewer.setColumnProperties(new String[]{"property", "newValue", "profile", "profileValue"});
            TreeViewerColumn propertyViewerColumn = new TreeViewerColumn(this.managedPropertiesViewer, 0);
            final TreeColumn propertyColumn = propertyViewerColumn.getColumn();
            propertyViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)new DialogLabelDecorator()));
            propertyColumn.setText(Messages.ProjectConfigSynchronizerDialog_Property_label);
            propertyColumn.setResizable(true);
            TreeViewerColumn newValueViewerColumn = new TreeViewerColumn(this.managedPropertiesViewer, 0);
            newValueViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, new DialogLabelDecorator()){

                public String getText(Object element) {
                    if (element instanceof PropertyItem) {
                        PropertyItem propertyItem = (PropertyItem)((Object)element);
                        return PreferencesFactory.eINSTANCE.convertEscapedString(propertyItem.getProperty().getValue());
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
            final TreeColumn newValueColumn = newValueViewerColumn.getColumn();
            newValueColumn.setText(Messages.ProjectConfigSynchronizerDialog_NewValue_label);
            newValueColumn.setResizable(true);
            TreeViewerColumn profileViewerColumn = new TreeViewerColumn(this.managedPropertiesViewer, 0);
            profileViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, new DialogLabelDecorator()){

                public String getText(Object element) {
                    PropertyItem propertyItem;
                    Property managingProperty;
                    PreferenceFilter managingFilter;
                    if (element instanceof PropertyItem && (managingFilter = this.getManagingFilter(managingProperty = (propertyItem = (PropertyItem)((Object)element)).getOtherProperty())) != null) {
                        PreferenceProfile preferenceProfile = managingFilter.getPreferenceProfile();
                        Project project = preferenceProfile.getProject();
                        return project.getPreferenceNode().getName() + "/" + preferenceProfile.getName();
                    }
                    return "";
                }

                private PreferenceFilter getManagingFilter(Property managingProperty) {
                    String name = managingProperty.getName();
                    PreferenceNode preferenceNode = managingProperty.getParent();
                    WorkspaceConfiguration workspaceConfiguration = (WorkspaceConfiguration)managingProperty.eResource().getContents().get(0);
                    String projectName = managingProperty.getScope().getName();
                    Project project = workspaceConfiguration.getProject(projectName);
                    for (PreferenceProfile preferenceProfile : project.getPreferenceProfiles()) {
                        for (PreferenceFilter preferenceFilter : preferenceProfile.getPreferenceFilters()) {
                            if (preferenceFilter.getPreferenceNode() != preferenceNode || !preferenceFilter.matches(name)) continue;
                            return preferenceFilter;
                        }
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    PropertyItem propertyItem;
                    PreferenceFilter managingFilter;
                    if (element instanceof PropertyItem && (managingFilter = this.getManagingFilter((propertyItem = (PropertyItem)((Object)element)).getOtherProperty())) != null) {
                        return this.labelProvider.getImage((Object)managingFilter.getPreferenceProfile());
                    }
                    return null;
                }
            });
            final TreeColumn profileColumn = profileViewerColumn.getColumn();
            profileColumn.setText(Messages.ProjectConfigSynchronizerDialog_Profile_label);
            profileColumn.setResizable(true);
            TreeViewerColumn profileValueViewerColumn = new TreeViewerColumn(this.managedPropertiesViewer, 0);
            profileValueViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, new DialogLabelDecorator()){

                public String getText(Object element) {
                    if (element instanceof PropertyItem) {
                        PropertyItem propertyItem = (PropertyItem)((Object)element);
                        return PreferencesFactory.eINSTANCE.convertEscapedString(propertyItem.getOtherProperty().getValue());
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
            final TreeColumn profileValueColumn = profileValueViewerColumn.getColumn();
            profileValueColumn.setText(Messages.ProjectConfigSynchronizerDialog_ProfileValue_label);
            profileValueColumn.setResizable(true);
            ControlAdapter columnResizer = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    int width = tree.getSize().x;
                    ScrollBar bar = tree.getVerticalBar();
                    if (bar != null && bar.isVisible()) {
                        width -= bar.getSize().x;
                    }
                    int columnWidth = width * 4 / 9;
                    propertyColumn.setWidth(columnWidth);
                    int remainingWidth = width - columnWidth;
                    columnWidth = remainingWidth * 4 / 9;
                    profileColumn.setWidth(columnWidth);
                    newValueColumn.setWidth((remainingWidth -= columnWidth) / 2);
                    profileValueColumn.setWidth(remainingWidth - remainingWidth / 2);
                    tree.removeControlListener((ControlListener)this);
                }
            };
            tree.addControlListener((ControlListener)columnResizer);
            this.managedPropertiesViewer.setInput((Object)this.managedPropertiesInput);
            this.managedPropertiesViewer.expandAll();
            Label separator = new Label(container, 258);
            separator.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        }
        if (this.unmanagedPropertiesInput != null) {
            label = new Label(container, 0);
            label.setText(Messages.ProjectConfigSynchronizerDialog_UnmanagedPoperties_label);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Button editButton = new Button(container, 32);
            editButton.setText(Messages.ProjectConfigSynchronizerDialog_Edit_label);
            editButton.setSelection(this.edit);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectConfigSynchronizerDialog.this.edit = !ProjectConfigSynchronizerDialog.this.edit;
                    ProjectConfigSynchronizerPreferences.setEdit(ProjectConfigSynchronizerDialog.this.edit);
                    ProjectConfigSynchronizerPreferences.flush();
                }
            });
            editButton.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.unmanagedPropertiesViewer = new TreeViewer(container, 66304);
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            this.unmanagedPropertiesViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.unmanagedPropertiesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            final Tree tree = this.unmanagedPropertiesViewer.getTree();
            tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            tree.setLinesVisible(true);
            tree.setHeaderVisible(true);
            this.unmanagedPropertiesViewer.setColumnProperties(new String[]{"property", "newValue", "oldValue"});
            TreeViewerColumn propertyViewerColumn = new TreeViewerColumn(this.unmanagedPropertiesViewer, 0);
            final TreeColumn propertyColumn = propertyViewerColumn.getColumn();
            propertyViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)new DialogLabelDecorator()));
            propertyColumn.setText(Messages.ProjectConfigSynchronizerDialog_Property_label);
            propertyColumn.setResizable(true);
            TreeViewerColumn newValueViewerColumn = new TreeViewerColumn(this.unmanagedPropertiesViewer, 0);
            newValueViewerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, new DialogLabelDecorator()){

                public String getText(Object element) {
                    if (element instanceof PropertyItem) {
                        PropertyItem propertyItem = (PropertyItem)((Object)element);
                        return PreferencesFactory.eINSTANCE.convertEscapedString(propertyItem.getProperty().getValue());
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
            final TreeColumn newValueColumn = newValueViewerColumn.getColumn();
            newValueColumn.setText(Messages.ProjectConfigSynchronizerDialog_NewValue_label);
            newValueColumn.setResizable(true);
            TreeViewerColumn oldValueValuerColumn = new TreeViewerColumn(this.unmanagedPropertiesViewer, 0);
            oldValueValuerColumn.setLabelProvider((CellLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)labelProvider, new DialogLabelDecorator()){

                public String getText(Object element) {
                    PropertyItem propertyItem;
                    Property otherProperty;
                    if (element instanceof PropertyItem && (otherProperty = (propertyItem = (PropertyItem)((Object)element)).getOtherProperty()) != null) {
                        return PreferencesFactory.eINSTANCE.convertEscapedString(otherProperty.getValue());
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
            final TreeColumn oldValueColumn = oldValueValuerColumn.getColumn();
            oldValueColumn.setText(Messages.ProjectConfigSynchronizerDialog_OldValue_label);
            oldValueColumn.setResizable(true);
            ControlAdapter columnResizer = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    int width = tree.getSize().x;
                    ScrollBar bar = tree.getVerticalBar();
                    if (bar != null && bar.isVisible()) {
                        width -= bar.getSize().x;
                    }
                    int columnWidth = width / 2;
                    propertyColumn.setWidth(columnWidth);
                    int remainingWidth = width - columnWidth;
                    columnWidth = remainingWidth * 2;
                    newValueColumn.setWidth(remainingWidth / 2);
                    oldValueColumn.setWidth(remainingWidth - remainingWidth / 2);
                    tree.removeControlListener((ControlListener)this);
                }
            };
            tree.addControlListener((ControlListener)columnResizer);
            this.unmanagedPropertiesViewer.setInput((Object)this.unmanagedPropertiesInput);
            this.unmanagedPropertiesViewer.expandAll();
            Label separator = new Label(container, 258);
            separator.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        }
    }

    private static final class DialogLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        private DialogLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }
    }

    public static class InputItem
    extends ItemProvider {
        private WorkspaceConfiguration workspaceConfiguration;

        public void setWorkspaceConfiguration(WorkspaceConfiguration workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration;
        }

        public InputItem(WorkspaceConfiguration workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration;
        }

        public ProjectItem getProject(Project project) {
            String name = project.getPreferenceNode().getName();
            EList children = this.getChildren();
            for (Object child : children) {
                ProjectItem projectItem = (ProjectItem)((Object)child);
                if (!name.equals(projectItem.getText())) continue;
                return projectItem;
            }
            ProjectItem projectItem = new ProjectItem(project);
            this.getChildren().add((Object)projectItem);
            return projectItem;
        }

        public PreferenceNodeItem getPreferenceNode(PreferenceNode preferenceNode) {
            PreferenceNode parentPreferenceNode;
            PreferenceNode projectPreferenceNode = preferenceNode.getScope();
            ItemProvider parentItem = projectPreferenceNode == (parentPreferenceNode = preferenceNode.getParent()) ? this.getProject(this.workspaceConfiguration.getProject(projectPreferenceNode.getName())) : this.getPreferenceNode(parentPreferenceNode);
            String name = preferenceNode.getName();
            EList children = parentItem.getChildren();
            for (Object child : children) {
                PreferenceNodeItem preferenceNodeItem;
                if (!(child instanceof PreferenceNodeItem) || !name.equals((preferenceNodeItem = (PreferenceNodeItem)((Object)child)).getText())) continue;
                return preferenceNodeItem;
            }
            PreferenceNodeItem preferenceNodeItem = new PreferenceNodeItem(preferenceNode);
            children.add((Object)preferenceNodeItem);
            return preferenceNodeItem;
        }

        public PropertyItem getProperty(Property property, Property otherProperty) {
            PreferenceNodeItem preferenceNodeItem = this.getPreferenceNode(property.getParent());
            String name = property.getName();
            EList children = preferenceNodeItem.getChildren();
            for (Object child : children) {
                PropertyItem propertyItem;
                if (!(child instanceof PropertyItem) || !name.equals((propertyItem = (PropertyItem)((Object)child)).getText())) continue;
                return propertyItem;
            }
            PropertyItem propertyItem = new PropertyItem(property, otherProperty);
            children.add((Object)propertyItem);
            return propertyItem;
        }
    }

    public static class PreferenceNodeItem
    extends ItemProvider {
        private static final Object IMAGE = PreferencesEditPlugin.INSTANCE.getImage("full/obj16/PreferenceNode");
        private PreferenceNode preferenceNode;

        public PreferenceNodeItem(PreferenceNode preferenceNode) {
            super(preferenceNode.getName(), IMAGE);
            this.preferenceNode = preferenceNode;
        }

        public PreferenceNode getPreferenceNode() {
            return this.preferenceNode;
        }
    }

    public static class ProjectItem
    extends ItemProvider {
        private static final Object IMAGE = ProjectConfigEditPlugin.INSTANCE.getImage("full/obj16/Project");
        private Project project;

        public ProjectItem(Project project) {
            super(project.getPreferenceNode().getName(), IMAGE);
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }
    }

    public static class PropertyItem
    extends ItemProvider {
        private static final Object IMAGE = PreferencesEditPlugin.INSTANCE.getImage("full/obj16/Property");
        private Property property;
        private Property otherProperty;

        public PropertyItem(Property property, Property otherProperty) {
            super(property.getName(), IMAGE);
            this.property = property;
            this.otherProperty = otherProperty;
        }

        public Property getProperty() {
            return this.property;
        }

        public Property getOtherProperty() {
            return this.otherProperty;
        }
    }
}

