/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workingsets.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.workingsets.SetupWorkingSetsPackage;
import org.eclipse.oomph.setup.workingsets.WorkingSetTask;
import org.eclipse.oomph.setup.workingsets.impl.Messages;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetGroup;
import org.eclipse.oomph.workingsets.util.WorkingSetsUtil;

public class WorkingSetTaskImpl
extends SetupTaskImpl
implements WorkingSetTask {
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected EList<WorkingSet> workingSets;

    protected WorkingSetTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupWorkingSetsPackage.Literals.WORKING_SET_TASK;
    }

    @Override
    public String getPrefix() {
        return this.prefix == null ? this.getWorkingSetPrefix() : this.prefix;
    }

    @Override
    public void setPrefix(String newPrefix) {
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    @Override
    public EList<WorkingSet> getWorkingSets() {
        if (this.workingSets == null) {
            this.workingSets = new EObjectContainmentEList(WorkingSet.class, (InternalEObject)this, 11);
        }
        return this.workingSets;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getWorkingSets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getPrefix();
            }
            case 11: {
                return this.getWorkingSets();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setPrefix((String)newValue);
                return;
            }
            case 11: {
                this.getWorkingSets().clear();
                this.getWorkingSets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 11: {
                this.getWorkingSets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 11: {
                return this.workingSets != null && !this.workingSets.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (prefix: ");
        result.append(this.prefix);
        result.append(')');
        return result.toString();
    }

    private String getWorkingSetPrefix() {
        EObject eContainer = this.eContainer();
        while (eContainer != null) {
            if (eContainer instanceof Scope) {
                Scope scope = (Scope)eContainer;
                return scope.getQualifiedName().replace(' ', '.') + "-";
            }
            eContainer = eContainer.eContainer();
        }
        throw new IllegalStateException(Messages.WorkingSetTaskImpl_NoContainingScope_exception);
    }

    public Object getOverrideToken() {
        return this.getPrefix();
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        WorkingSetTask workingSetTask = (WorkingSetTask)overriddenSetupTask;
        EList<WorkingSet> workingSets = this.getWorkingSets();
        int count = 0;
        block0: for (WorkingSet overriddenWorkingSet : new ArrayList<WorkingSet>((Collection<WorkingSet>)workingSetTask.getWorkingSets())) {
            for (WorkingSet workingSet : workingSets) {
                if (EcoreUtil.equals((EObject)workingSet, (EObject)overriddenWorkingSet)) continue block0;
            }
            workingSets.add(count++, (Object)overriddenWorkingSet);
        }
    }

    private Map<String, WorkingSet> getExistingWorkingSets(String prefix, EList<WorkingSet> workingSets) {
        HashMap<String, WorkingSet> existingWorkingSets = new HashMap<String, WorkingSet>();
        for (WorkingSet workingSet : workingSets) {
            String id = workingSet.getID();
            if (id == null || !id.startsWith(prefix)) continue;
            existingWorkingSets.put(id, workingSet);
        }
        return existingWorkingSets;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        String prefix = this.getPrefix();
        WorkingSetGroup defaultWorkingSetGroup = WorkingSetsUtil.getWorkingSetGroup();
        Map<String, WorkingSet> existingWorkingSets = this.getExistingWorkingSets(prefix, (EList<WorkingSet>)defaultWorkingSetGroup.getWorkingSets());
        for (WorkingSet workingSet : this.getWorkingSets()) {
            String id = prefix + workingSet.getName();
            workingSet.setID(id);
        }
        for (WorkingSet workingSet : this.getWorkingSets()) {
            context.checkCancelation();
            WorkingSet existingWorkingSet = existingWorkingSets.remove(workingSet.getID());
            if (existingWorkingSet != null && EcoreUtil.equals((List)workingSet.getPredicates(), (List)existingWorkingSet.getPredicates())) continue;
            return true;
        }
        return !existingWorkingSets.isEmpty();
    }

    public void perform(SetupTaskContext context) throws Exception {
        WorkingSet existingWorkingSet;
        String id;
        String prefix = this.getPrefix();
        WorkingSetGroup defaultWorkingSetGroup = WorkingSetsUtil.getWorkingSetGroup();
        EList workingSets = defaultWorkingSetGroup.getWorkingSets();
        Map<String, WorkingSet> existingWorkingSets = this.getExistingWorkingSets(prefix, (EList<WorkingSet>)workingSets);
        EList<WorkingSet> newWorkingSetGroups = this.getWorkingSets();
        int insertionPoint = workingSets.size();
        for (WorkingSet workingSet : newWorkingSetGroups) {
            int index;
            context.checkCancelation();
            id = workingSet.getID();
            existingWorkingSet = existingWorkingSets.get(id);
            if (existingWorkingSet == null || (index = workingSets.indexOf((Object)existingWorkingSet)) >= insertionPoint) continue;
            insertionPoint = index;
        }
        for (WorkingSet workingSet : new ArrayList<WorkingSet>((Collection<WorkingSet>)newWorkingSetGroups)) {
            context.checkCancelation();
            id = workingSet.getID();
            existingWorkingSet = existingWorkingSets.remove(id);
            workingSets.remove((Object)existingWorkingSet);
            workingSets.add(insertionPoint++, (Object)workingSet);
        }
        workingSets.removeAll(existingWorkingSets.values());
        Resource resource = defaultWorkingSetGroup.eResource();
        resource.save(Map.of("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER", "PROCESS_DANGLING_HREF", "DISCARD"));
    }

    public int getPriority() {
        return 600;
    }
}

