/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverCP;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class PBSolverWithImpliedClause
extends PBSolverCP {
    private static final long serialVersionUID = 1L;

    public PBSolverWithImpliedClause(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, IOrder order) {
        super(learner, dsf, order);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt literals, IVec<BigInteger> coeffs, boolean moreThan, BigInteger degree) throws ContradictionException {
        IVecInt clits;
        IVecInt vlits = this.dimacs2internal(literals);
        assert (vlits.size() == literals.size());
        assert (literals.size() == coeffs.size());
        Constr result = ((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(vlits, coeffs, moreThan, degree);
        if (result != null && result != Constr.TAUTOLOGY && (clits = ((PBConstr)result).computeAnImpliedClause()) != null) {
            this.addConstr(((PBDataStructureFactory)this.dsfactory).createClause(clits));
        }
        return this.addConstr(result);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + "\n" + prefix + "Add implied clauses in preprocessing";
    }
}

