/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.osgi.service.prefs.BackingStoreException;

public class TabAdvanced {
    private static final String PREFERENCES_PLUGIN = "org.eclipse.equinox.security";
    private Map<String, ?> availableCiphers = null;
    private Combo cipherSelector = null;
    private IEclipsePreferences eclipseNode = null;
    private String defaultCipherAlgorithm;

    public TabAdvanced(TabFolder folder, int index, Shell shell) {
        TabItem tab = new TabItem(folder, 0, index);
        tab.setText(SecUIMessages.tabAdvanced);
        Composite page = new Composite((Composite)folder, 0);
        tab.setControl((Control)page);
        Label cipherLabel = new Label(page, 0);
        cipherLabel.setText(SecUIMessages.selectCipher);
        this.cipherSelector = new Combo(page, 12);
        GridData gridDataSelector = new GridData(4, 1, true, false);
        this.cipherSelector.setLayoutData((Object)gridDataSelector);
        this.eclipseNode = ConfigurationScope.INSTANCE.getNode(PREFERENCES_PLUGIN);
        this.defaultCipherAlgorithm = this.eclipseNode.get("org.eclipse.equinox.security.preferences.cipher", "PBEWithHmacSHA512AndAES_256");
        this.availableCiphers = InternalExchangeUtils.ciphersDetectAvailable();
        int position = 0;
        for (String cipherAlgorithm : this.availableCiphers.keySet()) {
            this.cipherSelector.add(cipherAlgorithm, position);
            if (this.defaultCipherAlgorithm.equals(cipherAlgorithm)) {
                this.cipherSelector.select(position);
            }
            ++position;
        }
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(1).generateLayout(page);
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.cipherSelector.getItemCount()) {
            String item = this.cipherSelector.getItem(i);
            if (item.equals("PBEWithHmacSHA512AndAES_256")) {
                this.cipherSelector.select(i);
            }
            ++i;
        }
    }

    public void performOk() {
        String selectedCipherAlgorithm = this.cipherSelector.getText();
        if (!this.defaultCipherAlgorithm.equals(selectedCipherAlgorithm)) {
            this.eclipseNode.put("org.eclipse.equinox.security.preferences.cipher", selectedCipherAlgorithm);
            String keyFactory = (String)this.availableCiphers.get(selectedCipherAlgorithm);
            this.eclipseNode.put("org.eclipse.equinox.security.preferences.keyFactory", keyFactory);
            this.defaultCipherAlgorithm = selectedCipherAlgorithm;
            try {
                this.eclipseNode.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }
}

