/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class EclipseProjectConfigurator
implements ProjectConfigurator {
    @Override
    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        LinkedHashSet<File> projectFiles = new LinkedHashSet<File>();
        HashSet<String> visitedDirectories = new HashSet<String>();
        WizardProjectsImportPage.collectProjectFilesFromDirectory(projectFiles, root, visitedDirectories, true, monitor);
        LinkedHashSet<File> res = new LinkedHashSet<File>();
        for (File projectFile : projectFiles) {
            res.add(projectFile.getParentFile());
        }
        return res;
    }

    @Override
    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return container.getFile(IPath.fromOSString((String)".project")).exists();
    }

    @Override
    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void removeDirtyDirectories(Map<File, List<ProjectConfigurator>> proposals) {
    }

    @Override
    public void configure(IProject project, Set<IPath> excludedDirectories, IProgressMonitor monitor) {
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException ex) {
            IDEWorkbenchPlugin.log(ex.getMessage(), ex);
        }
    }
}

