/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.installer.InstallerDialog;
import org.eclipse.oomph.setup.ui.EnablementComposite;
import org.eclipse.oomph.setup.ui.EnablementDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExtensionPage
extends SetupWizardPage {
    private EnablementComposite enablementComposite;
    private EnablementComposite.InstallOperation installOperation;

    protected ExtensionPage() {
        super("ExtensionPage");
        this.setTitle("Extensions");
        this.setDescription(EnablementDialog.getDescription((String)"the installer", (String)"Finish"));
    }

    protected Control createUI(Composite parent) {
        this.enablementComposite = new EnablementComposite(parent, 2048);
        this.enablementComposite.setLayoutData((Object)new GridData(1808));
        return this.enablementComposite;
    }

    public SetupWizardPage.WizardFinisher getWizardFinisher() {
        return new SetupWizardPage.WizardFinisher(){

            public boolean performFinish() {
                ExtensionPage.this.install();
                return false;
            }
        };
    }

    public void enterPage(boolean forward) {
        block5: {
            if (forward) {
                try {
                    SetupTaskPerformer performer = this.createPerformer(SetupPrompter.OK, false);
                    EList triggeredSetupTasks = performer.getTriggeredSetupTasks();
                    if (this.enablementComposite.setInput(triggeredSetupTasks) != null) {
                        this.setPageComplete(false);
                        break block5;
                    }
                    this.setPageComplete(true);
                    this.gotoNextPage();
                }
                catch (Throwable t) {
                    ErrorDialog.open((Throwable)t);
                }
            } else {
                this.gotoPreviousPage();
            }
        }
    }

    public void leavePage(boolean forward) {
        if (!forward && this.installOperation != null) {
            this.installOperation.cancel();
        }
    }

    public void install() {
        this.setButtonState(16, false);
        this.setButtonState(1, false);
        this.installOperation = this.enablementComposite.install(new EnablementComposite.InstallHandler(){

            public void installSucceeded() {
                ExtensionPage.this.installOperation = null;
                IWizardContainer container = ExtensionPage.this.getContainer();
                if (container instanceof InstallerDialog) {
                    InstallerDialog dialog = (InstallerDialog)container;
                    dialog.restart();
                }
            }

            public void installFailed(Throwable t) {
                ErrorDialog.open((Throwable)t);
                this.installCanceled();
            }

            public void installCanceled() {
                ExtensionPage.this.setButtonState(16, true);
                ExtensionPage.this.setButtonState(1, true);
                ExtensionPage.this.installOperation = null;
            }
        });
    }
}

