/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.ArrayList;
import java.util.List;

public class SimplePatternFormatter {
    private final String patternWithoutPlaceholders;
    private final int placeholderCount;
    private final int[] placeholderIdsOrderedByOffset;

    private SimplePatternFormatter(String pattern, PlaceholdersBuilder builder) {
        this.patternWithoutPlaceholders = pattern;
        this.placeholderIdsOrderedByOffset = builder.getPlaceholderIdsOrderedByOffset();
        this.placeholderCount = builder.getPlaceholderCount();
    }

    public static SimplePatternFormatter compile(CharSequence pattern) {
        PlaceholdersBuilder placeholdersBuilder = new PlaceholdersBuilder();
        PlaceholderIdBuilder idBuilder = new PlaceholderIdBuilder();
        StringBuilder newPattern = new StringBuilder();
        State state = State.INIT;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            switch (state) {
                case INIT: {
                    if (ch == '\'') {
                        state = State.APOSTROPHE;
                        break;
                    }
                    if (ch == '{') {
                        state = State.PLACEHOLDER;
                        idBuilder.reset();
                        break;
                    }
                    newPattern.append(ch);
                    break;
                }
                case APOSTROPHE: {
                    if (ch == '\'') {
                        newPattern.append("'");
                    } else if (ch == '{') {
                        newPattern.append("{");
                    } else {
                        newPattern.append("'");
                        newPattern.append(ch);
                    }
                    state = State.INIT;
                    break;
                }
                case PLACEHOLDER: {
                    if (ch >= '0' && ch <= '9') {
                        idBuilder.add(ch);
                        break;
                    }
                    if (ch == '}' && idBuilder.isValid()) {
                        placeholdersBuilder.add(idBuilder.getId(), newPattern.length());
                        state = State.INIT;
                        break;
                    }
                    newPattern.append('{');
                    idBuilder.appendTo(newPattern);
                    newPattern.append(ch);
                    state = State.INIT;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
        switch (state) {
            case INIT: {
                break;
            }
            case APOSTROPHE: {
                newPattern.append("'");
                break;
            }
            case PLACEHOLDER: {
                newPattern.append('{');
                idBuilder.appendTo(newPattern);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new SimplePatternFormatter(newPattern.toString(), placeholdersBuilder);
    }

    public int getPlaceholderCount() {
        return this.placeholderCount;
    }

    public boolean startsWithPlaceholder(int id) {
        if (this.placeholderIdsOrderedByOffset.length == 0) {
            return false;
        }
        return this.placeholderIdsOrderedByOffset[0] == 0 && this.placeholderIdsOrderedByOffset[1] == id;
    }

    public String format(CharSequence ... values) {
        return this.format(new StringBuilder(), null, values).toString();
    }

    public StringBuilder format(StringBuilder appendTo, int[] offsets, CharSequence ... values) {
        if (values.length < this.placeholderCount) {
            throw new IllegalArgumentException("Too few values.");
        }
        int offsetLen = offsets == null ? 0 : offsets.length;
        int i = 0;
        while (i < offsetLen) {
            offsets[i] = -1;
            ++i;
        }
        if (this.placeholderIdsOrderedByOffset.length == 0) {
            appendTo.append(this.patternWithoutPlaceholders);
            return appendTo;
        }
        if (this.placeholderIdsOrderedByOffset[0] > 0 || appendTo != values[this.placeholderIdsOrderedByOffset[1]]) {
            appendTo.append(this.patternWithoutPlaceholders, 0, this.placeholderIdsOrderedByOffset[0]);
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[1], appendTo.length(), offsets, offsetLen);
            appendTo.append(values[this.placeholderIdsOrderedByOffset[1]]);
        } else {
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[1], 0, offsets, offsetLen);
        }
        i = 2;
        while (i < this.placeholderIdsOrderedByOffset.length) {
            appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[i - 2], this.placeholderIdsOrderedByOffset[i]);
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[i + 1], appendTo.length(), offsets, offsetLen);
            appendTo.append(values[this.placeholderIdsOrderedByOffset[i + 1]]);
            i += 2;
        }
        appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[this.placeholderIdsOrderedByOffset.length - 2], this.patternWithoutPlaceholders.length());
        return appendTo;
    }

    public String toString() {
        CharSequence[] values = new String[this.getPlaceholderCount()];
        int i = 0;
        while (i < values.length) {
            values[i] = String.format("{%d}", i);
            ++i;
        }
        return this.format(new StringBuilder(), null, values).toString();
    }

    private static void setPlaceholderOffset(int placeholderId, int offset, int[] offsets, int offsetLen) {
        if (placeholderId < offsetLen) {
            offsets[placeholderId] = offset;
        }
    }

    public String getPatternWithNoPlaceholders() {
        return this.patternWithoutPlaceholders;
    }

    private static class PlaceholderIdBuilder {
        private int id = 0;
        private int idLen = 0;

        private PlaceholderIdBuilder() {
        }

        public void reset() {
            this.id = 0;
            this.idLen = 0;
        }

        public int getId() {
            return this.id;
        }

        public void appendTo(StringBuilder appendTo) {
            if (this.idLen > 0) {
                appendTo.append(this.id);
            }
        }

        public boolean isValid() {
            return this.idLen > 0;
        }

        public void add(char ch) {
            this.id = this.id * 10 + ch - 48;
            ++this.idLen;
        }
    }

    private static class PlaceholdersBuilder {
        private List<Integer> placeholderIdsOrderedByOffset = new ArrayList<Integer>();
        private int placeholderCount = 0;

        private PlaceholdersBuilder() {
        }

        public void add(int placeholderId, int offset) {
            this.placeholderIdsOrderedByOffset.add(offset);
            this.placeholderIdsOrderedByOffset.add(placeholderId);
            if (placeholderId >= this.placeholderCount) {
                this.placeholderCount = placeholderId + 1;
            }
        }

        public int getPlaceholderCount() {
            return this.placeholderCount;
        }

        public int[] getPlaceholderIdsOrderedByOffset() {
            int[] result = new int[this.placeholderIdsOrderedByOffset.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.placeholderIdsOrderedByOffset.get(i);
                ++i;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        APOSTROPHE,
        PLACEHOLDER;

    }
}

