/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.OomphDragAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralDragAdapter
extends OomphDragAdapter {
    public GeneralDragAdapter(Viewer viewer, DraggedObjectsFactory factory, List<? extends OomphTransferDelegate> delegates) {
        super(GeneralDragAdapter.createEditingDomain(delegates), GeneralDragAdapter.createSelectionProvider(viewer, factory), delegates);
        this.createContextMenu(viewer.getControl());
    }

    private void createContextMenu(Control control) {
        final CopyAction copyAction = new CopyAction(this.domain);
        try {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        }
        catch (RuntimeException runtimeException) {}
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)GeneralDragAdapter.this.selectionProvider.getSelection();
                if (!selection.isEmpty()) {
                    copyAction.updateSelection(selection);
                    manager.add((IAction)copyAction);
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    private static EditingDomain createEditingDomain(List<? extends OomphTransferDelegate> delegates) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        OomphEditingDomain editingDomain = new OomphEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack(), new HashMap<Resource, Boolean>(), delegates);
        return editingDomain;
    }

    private static ISelectionProvider createSelectionProvider(final Viewer viewer, final DraggedObjectsFactory factory) {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                ISelection selection = viewer.getSelection();
                try {
                    List<EObject> objects = factory.createDraggedObjects(selection);
                    if (objects != null && !objects.isEmpty()) {
                        return new StructuredSelection(objects);
                    }
                }
                catch (Exception ex) {
                    UIPlugin.INSTANCE.log(ex);
                }
                return StructuredSelection.EMPTY;
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DraggedObjectsFactory {
        public List<EObject> createDraggedObjects(ISelection var1) throws Exception;
    }
}

