/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.presentation.actions;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.ide.IDE;

public class OpenEditorAction
extends ActionDelegate {
    protected String path;

    public void run(IAction action) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            File file = new File(this.path);
            URI uri = file.toURI();
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (files.length > 0) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)files[0]);
            } else {
                IFileStore fileStore = EFS.getStore((URI)uri);
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof PreferenceNode) {
            this.path = ((PreferenceNode)object).getLocation();
            action.setEnabled(this.path != null);
            return;
        }
        this.path = null;
        action.setEnabled(false);
    }
}

