/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.userstorage.ui.internal.SystemBrowser;

public abstract class MultiLink
extends Composite {
    private static final Pattern PATTERN = Pattern.compile("<a href=[\"']([^\"']+)[\"']>([^<]+)</a>");
    private final Map<String, String> hrefs = new HashMap<String, String>();
    private Link link;
    private String text;

    public MultiLink(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.link = new Link((Composite)this, style);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String label = e.text;
                String href = (String)MultiLink.this.hrefs.get(label);
                if (href != null) {
                    MultiLink.this.linkSelected(label, href);
                }
            }
        });
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.hrefs.clear();
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String href = matcher.group(1);
            String label = matcher.group(2);
            this.hrefs.put(label, href);
            matcher.appendReplacement(buffer, "<a>" + label + "</a>");
        }
        matcher.appendTail(buffer);
        this.link.setText(buffer.toString());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.link.setEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.link.setVisible(visible);
    }

    public boolean setFocus() {
        return this.link.setFocus();
    }

    protected abstract void linkSelected(String var1, String var2);

    public static class ForSystemBrowser
    extends MultiLink {
        public ForSystemBrowser(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        protected void linkSelected(String label, String href) {
            SystemBrowser.openSafe(this.getShell(), href, "Go to " + href + " to read the " + label + ".");
        }
    }
}

