/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.actions;

import java.lang.reflect.Field;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.oomph.version.ui.Activator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.osgi.framework.Bundle;

public class ToggleApiBuilderAction
implements IWorkbenchWindowActionDelegate {
    private Field buildDisabledField;

    public ToggleApiBuilderAction() {
        try {
            Bundle bundle = Activator.getPlugin().getBundle();
            Class c = bundle.loadClass("org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder");
            this.buildDisabledField = c.getDeclaredField("buildDisabled");
            this.buildDisabledField.setAccessible(true);
        }
        catch (Throwable throwable) {}
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateCheckState(action);
    }

    public void run(IAction action) {
        boolean disabled = this.isDisabled();
        this.setDisabled(!disabled);
        this.updateCheckState(action);
    }

    private void updateCheckState(IAction action) {
        boolean disabled = this.isDisabled();
        boolean checked = action.isChecked();
        if (checked != disabled) {
            action.setChecked(disabled);
        }
    }

    private boolean isDisabled() {
        if (this.buildDisabledField != null) {
            try {
                return (Boolean)this.buildDisabledField.get(null);
            }
            catch (Throwable ex) {
                Activator.log(ex);
            }
        }
        return false;
    }

    private void setDisabled(boolean disabled) {
        if (this.buildDisabledField != null) {
            try {
                this.buildDisabledField.set(null, disabled);
            }
            catch (Throwable ex) {
                Activator.log(ex);
            }
        }
    }
}

