/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringExpander {
    public static final Pattern STRING_EXPANSION_PATTERN = Pattern.compile("\\$(\\{([^${}|/]+)(([\\|/][^{}|/]*)*)}|\\$)");
    static final String[] CONTROL_CHARACTER_REPLACEMENTS = new String[]{"${0x0}", "${0x1}", "${0x2}", "${0x3}", "${0x4}", "${0x5}", "${0x6}", "${0x7}", "${0x8}", "${0x9}", "${0xA}", "${0xB}", "${0xC}", "${0xD}", "${0xE}", "${0xF}", "${0x10}", "${0x11}", "${0x12}", "${0x13}", "${0x14}", "${0x15}", "${0x16}", "${0x17}", "${0x18}", "${0x19}", "${0x1A}", "${0x1B}", "${0x1C}", "${0x1D}", "${0x1E}", "${0x1F}"};
    protected static final Map<String, String> CONTROL_CHARACTER_VALUES = new HashMap<String, String>();

    static {
        int i = 0;
        int length = CONTROL_CHARACTER_REPLACEMENTS.length;
        while (i < length) {
            String controlCharacterReplacement = CONTROL_CHARACTER_REPLACEMENTS[i];
            CONTROL_CHARACTER_VALUES.put(controlCharacterReplacement.substring(2, controlCharacterReplacement.length() - 1), Character.toString((char)i));
            ++i;
        }
    }

    protected static String resolve(StringExpander stringExpander, String key) {
        return stringExpander.resolve(key);
    }

    protected static boolean isUnexpanded(StringExpander stringExpander, String key) {
        return stringExpander.isUnexpanded(key);
    }

    protected static String filter(StringExpander stringExpander, String value, String filterName) {
        return stringExpander.filter(value, filterName);
    }

    protected abstract String resolve(String var1);

    protected abstract boolean isUnexpanded(String var1);

    protected abstract String filter(String var1, String var2);

    protected String getFileSeparator() {
        return File.separator;
    }

    public String expandString(String string) {
        return this.expandString(string, null);
    }

    public String expandString(String string, Set<String> keys) {
        if (string == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int previous = 0;
        boolean unresolved = false;
        Matcher matcher = STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            result.append(string.substring(previous, matcher.start()));
            String key = matcher.group(1);
            if ("$".equals(key)) {
                result.append('$');
            } else {
                String value;
                key = matcher.group(2);
                boolean isUnexpanded = this.isUnexpanded(key);
                String string2 = value = isUnexpanded ? null : this.resolve(key);
                if (value == null) {
                    if (keys != null) {
                        unresolved = true;
                        if (!isUnexpanded) {
                            keys.add(key);
                        }
                    } else if (!unresolved) {
                        result.append(matcher.group());
                    }
                } else {
                    String extensions = matcher.group(3);
                    if (extensions != null) {
                        Extension extension;
                        ExtensionParser parser = new ExtensionParser(extensions);
                        while ((extension = parser.parseNext()) != null) {
                            if (extension.filter) {
                                if (extension.name.length() == 0 || (value = this.filter(value, extension.name)) != null) continue;
                                if (keys != null) {
                                    unresolved = true;
                                    if (isUnexpanded) continue;
                                    keys.add(key);
                                    continue;
                                }
                                if (unresolved) continue;
                                result.append(matcher.group());
                                continue;
                            }
                            if (!value.endsWith("/") && !value.endsWith("\\")) {
                                value = String.valueOf(value) + this.getFileSeparator();
                            }
                            value = String.valueOf(value) + extension.name;
                        }
                    }
                    if (!unresolved) {
                        result.append(value);
                    }
                }
            }
            previous = matcher.end();
        }
        if (unresolved) {
            return null;
        }
        result.append(string.substring(previous));
        return result.toString();
    }

    private static final class Extension {
        public final boolean filter;
        public final String name;

        public Extension(boolean filter, String name) {
            this.filter = filter;
            this.name = name;
        }
    }

    private static final class ExtensionParser {
        private final String input;
        private final int length;
        private int next;

        public ExtensionParser(String input) {
            this.input = input;
            this.length = input.length();
        }

        public Extension parseNext() {
            if (this.next < this.input.length()) {
                boolean filter = this.input.charAt(this.next) == '|';
                StringBuilder name = new StringBuilder();
                while (++this.next < this.length) {
                    char c = this.input.charAt(this.next);
                    if (c == '/' || c == '|') {
                        return new Extension(filter, name.toString());
                    }
                    name.append(c);
                }
                return new Extension(filter, name.toString());
            }
            return null;
        }
    }
}

