/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.MainActionGroup;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;
import org.eclipse.ui.views.navigator.NavigatorFrameSource;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;

@Deprecated
public class ResourceNavigator
extends ViewPart
implements ISetSelectionTarget,
IResourceNavigator {
    private TreeViewer viewer;
    private IDialogSettings settings;
    private IMemento memento;
    private FrameList frameList;
    private ResourceNavigatorActionGroup actionGroup;
    private ResourcePatternFilter patternFilter = new ResourcePatternFilter();
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private boolean linkingEnabled;
    private boolean dragDetected;
    private Listener dragDetectListener;
    private IWorkingSet workingSet;
    private boolean emptyWorkingSet = false;
    private static final String STORE_SECTION = "ResourceNavigator";
    private static final String STORE_SORT_TYPE = "ResourceViewer.STORE_SORT_TYPE";
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    @Deprecated
    public static final String NAVIGATOR_VIEW_HELP_ID = "org.eclipse.ui.resource_view_context";
    private boolean linkScheduled = false;
    private static final String TAG_SORTER = "sorter";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String TAG_PATH = "path";
    private static final String TAG_CURRENT_FRAME = "currentFrame";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                ResourceNavigator.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                ResourceNavigator.this.editorActivated((IEditorPart)part);
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private IPropertyChangeListener propertyChangeListener = event -> {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        if ("workingSetRemove".equals(property) && oldValue == this.workingSet) {
            this.setWorkingSet(null);
        } else if ("workingSetNameChange".equals(property) && newValue == this.workingSet) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property) && newValue == this.workingSet) {
            if (this.workingSet.isAggregateWorkingSet() && this.workingSet.isEmpty()) {
                if (!this.emptyWorkingSet) {
                    this.emptyWorkingSet = true;
                    this.workingSetFilter.setWorkingSet(null);
                }
            } else if (this.emptyWorkingSet) {
                this.emptyWorkingSet = false;
                this.workingSetFilter.setWorkingSet(this.workingSet);
            }
            this.getViewer().refresh();
        }
    };
    private CollapseAllHandler collapseAllHandler;
    private OpenAndLinkWithEditorHelper openAndLinkWithEditorHelper;

    public ResourceNavigator() {
        IDialogSettings viewsSettings = this.getPlugin().getDialogSettings();
        this.settings = viewsSettings.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(STORE_SECTION);
        }
        this.initLinkingEnabled();
    }

    private StructuredSelection convertSelection(ISelection selection) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object o : ssel) {
                IResource resource = (IResource)Adapters.adapt(o, IResource.class);
                if (resource == null) continue;
                list.add(resource);
            }
        }
        return new StructuredSelection(list);
    }

    public void createPartControl(Composite parent) {
        TreeViewer viewer;
        this.viewer = viewer = this.createViewer(parent);
        if (this.memento != null) {
            this.restoreFilters();
            this.restoreLinkingEnabled();
        }
        this.frameList = this.createFrameList();
        this.initDragAndDrop();
        this.updateTitle();
        this.initContextMenu();
        this.initResourceComparator();
        this.initWorkingSetFilter();
        viewer.setInput((Object)this.getInitialInput());
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)viewer.getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        IWorkingSetManager workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        workingSetManager.addPropertyChangeListener(this.propertyChangeListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(viewer.getControl(), this.getHelpContextId());
    }

    protected String getHelpContextId() {
        return NAVIGATOR_VIEW_HELP_ID;
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        TreeViewer viewer = this.getTreeViewer();
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.setUseHashlookup(true);
        this.initContentProvider(viewer);
        this.initLabelProvider(viewer);
        this.initFilters(viewer);
        this.initListeners(viewer);
        return viewer;
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    protected void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.patternFilter);
        viewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    private void initLinkingEnabled() {
        String setting = this.settings.get("LINK_NAVIGATOR_TO_EDITOR");
        if (setting != null) {
            this.linkingEnabled = setting.equals("true");
            return;
        }
        this.linkingEnabled = PlatformUI.getPreferenceStore().getBoolean("LINK_NAVIGATOR_TO_EDITOR");
    }

    protected void initListeners(final TreeViewer viewer) {
        viewer.addSelectionChangedListener(event -> this.handleSelectionChanged(event));
        viewer.addDoubleClickListener(event -> this.handleDoubleClick(event));
        this.openAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper((StructuredViewer)viewer){

            protected void activate(ISelection selection) {
                Object selectedElement = ResourceNavigator.getSingleElement(selection);
                if (selectedElement instanceof IFile) {
                    FileEditorInput input = new FileEditorInput((IFile)selectedElement);
                    IWorkbenchPage page = ResourceNavigator.this.getSite().getPage();
                    IEditorPart editor = page.findEditor((IEditorInput)input);
                    if (editor != null) {
                        page.activate((IWorkbenchPart)editor);
                    }
                }
            }

            protected void linkToEditor(ISelection selection) {
                if (!ResourceNavigator.this.linkScheduled) {
                    ResourceNavigator.this.linkScheduled = true;
                    ResourceNavigator.this.getSite().getShell().getDisplay().asyncExec(() -> {
                        ResourceNavigator.this.linkScheduled = false;
                        if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (!ResourceNavigator.this.dragDetected) {
                            ResourceNavigator.this.linkToEditor(viewer.getSelection());
                        }
                    });
                }
            }

            protected void open(ISelection selection, boolean activate) {
                ResourceNavigator.this.handleOpen(selection);
            }
        };
        viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                ResourceNavigator.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                ResourceNavigator.this.handleKeyReleased(event);
            }
        });
        this.openAndLinkWithEditorHelper.setLinkWithEditor(this.linkingEnabled);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        IWorkingSetManager workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        workingSetManager.removePropertyChangeListener(this.propertyChangeListener);
        if (this.collapseAllHandler != null) {
            this.collapseAllHandler.dispose();
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        Control control = this.viewer.getControl();
        if (this.dragDetectListener != null && control != null && !control.isDisposed()) {
            control.removeListener(29, this.dragDetectListener);
        }
        super.dispose();
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IFile file = ResourceUtil.getFile(editor.getEditorInput());
        if (file != null) {
            StructuredSelection newSelection = new StructuredSelection((Object)file);
            if (this.getTreeViewer().getStructuredSelection().equals(newSelection)) {
                this.getTreeViewer().getTree().showSelection();
            } else {
                this.getTreeViewer().setSelection((ISelection)newSelection, true);
            }
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup().setContext(new ActionContext((ISelection)selection));
        this.getActionGroup().fillContextMenu(menu);
    }

    @Override
    public FrameList getFrameList() {
        return this.frameList;
    }

    protected IAdaptable getInitialInput() {
        IResource resource = (IResource)Adapters.adapt((Object)this.getSite().getPage().getInput(), IResource.class);
        if (resource != null) {
            switch (resource.getType()) {
                case 1: {
                    return resource.getParent();
                }
                case 2: 
                case 4: 
                case 8: {
                    return resource;
                }
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public ResourcePatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    @Override
    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public AbstractUIPlugin getPlugin() {
        return IDEWorkbenchPlugin.getDefault();
    }

    @Override
    @Deprecated
    public ResourceSorter getSorter() {
        ViewerSorter sorter = this.getTreeViewer().getSorter();
        if (sorter instanceof ResourceSorter) {
            return (ResourceSorter)sorter;
        }
        return null;
    }

    @Override
    public ResourceComparator getComparator() {
        ViewerComparator comparator = this.getTreeViewer().getComparator();
        if (comparator instanceof ResourceComparator) {
            return (ResourceComparator)comparator;
        }
        return null;
    }

    @Override
    public TreeViewer getViewer() {
        return this.viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    @Deprecated
    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    protected String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof IResource) {
                return ((IResource)o).getFullPath().makeRelative().toString();
            }
            return ResourceNavigatorMessages.ResourceNavigator_oneItemSelected;
        }
        if (selection.size() > 1) {
            return NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_statusLine, (Object)String.valueOf(selection.size()));
        }
        return "";
    }

    String getFrameName(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        String text = ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    String getFrameToolTipText(Object element) {
        if (element instanceof IResource) {
            IPath path = ((IResource)element).getFullPath();
            if (path.isRoot()) {
                return ResourceNavigatorMessages.ResourceManager_toolTip;
            }
            return path.makeRelative().toString();
        }
        String text = ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    @Deprecated
    protected void handleOpen(OpenEvent event) {
        this.handleOpen(event.getSelection());
    }

    protected void handleOpen(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.getActionGroup().runDefaultAction((IStructuredSelection)selection);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        TreeViewer viewer = this.getTreeViewer();
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        } else if (selection.size() == 1 && element instanceof IResource && ((IResource)element).getType() == 4) {
            OpenResourceAction ora = new OpenResourceAction((IShellProvider)this.getSite());
            ora.selectionChanged((IStructuredSelection)viewer.getSelection());
            if (ora.isEnabled()) {
                ora.run();
            }
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
        this.updateActionBars(sel);
        this.dragDetected = false;
    }

    protected void handleKeyPressed(KeyEvent event) {
        this.getActionGroup().handleKeyPressed(event);
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TreeViewer viewer = this.getTreeViewer();
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
        NavigatorDropAdapter adapter = new NavigatorDropAdapter((StructuredViewer)viewer);
        adapter.setFeedbackEnabled(false);
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
        this.dragDetectListener = event -> {
            boolean bl = this.dragDetected = true;
        };
        viewer.getControl().addListener(29, this.dragDetectListener);
    }

    protected FrameList createFrameList() {
        NavigatorFrameSource frameSource = new NavigatorFrameSource(this);
        FrameList frameList = new FrameList(frameSource);
        frameSource.connectTo(frameList);
        return frameList;
    }

    @Deprecated
    protected void initResourceSorter() {
        int sortType = 1;
        try {
            int sortInt = 0;
            if (this.memento != null) {
                String sortStr = this.memento.getString(TAG_SORTER);
                if (sortStr != null) {
                    sortInt = Integer.parseInt(sortStr);
                }
            } else {
                sortInt = this.settings.getInt(STORE_SORT_TYPE);
            }
            if (sortInt == 1 || sortInt == 2) {
                sortType = sortInt;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setSorter(new ResourceSorter(sortType));
    }

    protected void initResourceComparator() {
        int sortType = 1;
        try {
            int sortInt = 0;
            if (this.memento != null) {
                String sortStr = this.memento.getString(TAG_SORTER);
                if (sortStr != null) {
                    sortInt = Integer.parseInt(sortStr);
                }
            } else {
                sortInt = this.settings.getInt(STORE_SORT_TYPE);
            }
            if (sortInt == 1 || sortInt == 2) {
                sortType = sortInt;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setComparator(new ResourceComparator(sortType));
    }

    protected void initWorkingSetFilter() {
        String workingSetName = this.settings.get(STORE_WORKING_SET);
        IWorkingSet workingSet = null;
        if (workingSetName != null && !workingSetName.equals("")) {
            IWorkingSetManager workingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
            workingSet = workingSetManager.getWorkingSet(workingSetName);
        } else if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
            workingSet = this.getSite().getPage().getAggregateWorkingSet();
        }
        if (workingSet != null) {
            this.workingSetFilter.setWorkingSet(workingSet);
            this.internalSetWorkingSet(workingSet);
        }
    }

    @Override
    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    @Deprecated
    protected void linkToEditor(IStructuredSelection selection) {
        this.linkToEditor((ISelection)selection);
    }

    protected void linkToEditor(ISelection selection) {
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object obj = ResourceNavigator.getSingleElement(selection);
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            IWorkbenchPage page = this.getSite().getPage();
            IEditorPart editor = ResourceUtil.findEditor(page, file);
            if (editor != null) {
                page.bringToTop((IWorkbenchPart)editor);
                return;
            }
        }
    }

    protected void makeActions() {
        MainActionGroup group = new MainActionGroup(this);
        this.setActionGroup(group);
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        service.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)group.toggleLinkingAction));
        this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.viewer);
        service.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseAllHandler);
    }

    private void restoreFilters() {
        IMemento filtersMem = this.memento.getChild(TAG_FILTERS);
        if (filtersMem != null) {
            IMemento[] children = filtersMem.getChildren(TAG_FILTER);
            if (children.length > 0 && children[0].getString(TAG_IS_ENABLED) != null) {
                ArrayList<String> selectedFilters = new ArrayList<String>();
                ArrayList<String> unSelectedFilters = new ArrayList<String>();
                IMemento[] iMementoArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento memento = iMementoArray[n2];
                    if (memento.getString(TAG_IS_ENABLED).equals(String.valueOf(true))) {
                        selectedFilters.add(memento.getString(TAG_ELEMENT));
                    } else {
                        unSelectedFilters.add(memento.getString(TAG_ELEMENT));
                    }
                    ++n2;
                }
                List pluginFilters = FiltersContentProvider.getDefaultFilters();
                for (String element : pluginFilters) {
                    if (selectedFilters.contains(element) || unSelectedFilters.contains(element)) continue;
                    selectedFilters.add(element);
                }
                String[] patternArray = new String[selectedFilters.size()];
                selectedFilters.toArray(patternArray);
                this.getPatternFilter().setPatterns(patternArray);
            } else {
                String[] filters = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    filters[i] = children[i].getString(TAG_ELEMENT);
                    ++i;
                }
                this.getPatternFilter().setPatterns(filters);
            }
        } else {
            this.getPatternFilter().setPatterns(new String[0]);
        }
    }

    protected void restoreState(IMemento memento) {
        TreeViewer viewer = this.getTreeViewer();
        IMemento frameMemento = memento.getChild(TAG_CURRENT_FRAME);
        if (frameMemento != null) {
            TreeFrame frame = new TreeFrame((AbstractTreeViewer)viewer);
            frame.restoreState(frameMemento);
            frame.setName(this.getFrameName(frame.getInput()));
            frame.setToolTipText(this.getFrameToolTipText(frame.getInput()));
            viewer.setSelection((ISelection)new StructuredSelection(frame.getInput()));
            this.frameList.gotoFrame(frame);
        } else {
            IResource element;
            IMemento mem;
            int n;
            int n2;
            IMemento[] iMementoArray;
            IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
            IMemento childMem = memento.getChild(TAG_EXPANDED);
            if (childMem != null) {
                ArrayList<IResource> elements = new ArrayList<IResource>();
                iMementoArray = childMem.getChildren(TAG_ELEMENT);
                n2 = iMementoArray.length;
                n = 0;
                while (n < n2) {
                    mem = iMementoArray[n];
                    element = container.findMember(mem.getString(TAG_PATH));
                    if (element != null) {
                        elements.add(element);
                    }
                    ++n;
                }
                viewer.setExpandedElements(elements.toArray());
            }
            if ((childMem = memento.getChild(TAG_SELECTION)) != null) {
                ArrayList<IResource> list = new ArrayList<IResource>();
                iMementoArray = childMem.getChildren(TAG_ELEMENT);
                n2 = iMementoArray.length;
                n = 0;
                while (n < n2) {
                    mem = iMementoArray[n];
                    element = container.findMember(mem.getString(TAG_PATH));
                    if (element != null) {
                        list.add(element);
                    }
                    ++n;
                }
                viewer.setSelection((ISelection)new StructuredSelection(list));
            }
        }
    }

    private void restoreLinkingEnabled() {
        Integer val = this.memento.getInteger("LINK_NAVIGATOR_TO_EDITOR");
        if (val != null) {
            this.linkingEnabled = val != 0;
        }
    }

    public void saveState(IMemento memento) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        if (this.getComparator() != null) {
            memento.putInteger(TAG_SORTER, this.getComparator().getCriteria());
        } else if (this.getSorter() != null) {
            memento.putInteger(TAG_SORTER, this.getSorter().getCriteria());
        }
        String[] filters = this.getPatternFilter().getPatterns();
        List<String> selectedFilters = Arrays.asList(filters);
        List allFilters = FiltersContentProvider.getDefinedFilters();
        IMemento filtersMem = memento.createChild(TAG_FILTERS);
        for (String element : allFilters) {
            IMemento child = filtersMem.createChild(TAG_FILTER);
            child.putString(TAG_ELEMENT, element);
            child.putString(TAG_IS_ENABLED, String.valueOf(selectedFilters.contains(element)));
        }
        if (this.frameList.getCurrentIndex() > 0) {
            TreeFrame currentFrame = (TreeFrame)this.frameList.getCurrentFrame();
            IMemento frameMemento = memento.createChild(TAG_CURRENT_FRAME);
            currentFrame.saveState(frameMemento);
        } else {
            Object[] elements;
            int n;
            Object[] expandedElements = viewer.getVisibleExpandedElements();
            if (expandedElements.length > 0) {
                IMemento expandedMem = memento.createChild(TAG_EXPANDED);
                Object[] objectArray = expandedElements;
                n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object expandedElement = objectArray[n2];
                    if (expandedElement instanceof IResource) {
                        IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                        elementMem.putString(TAG_PATH, ((IResource)expandedElement).getFullPath().toString());
                    }
                    ++n2;
                }
            }
            if ((elements = ((IStructuredSelection)viewer.getSelection()).toArray()).length > 0) {
                IMemento selectionMem = memento.createChild(TAG_SELECTION);
                Object[] objectArray = elements;
                int n3 = elements.length;
                n = 0;
                while (n < n3) {
                    Object selectionElement = objectArray[n];
                    if (selectionElement instanceof IResource) {
                        IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                        elementMem.putString(TAG_PATH, ((IResource)selectionElement).getFullPath().toString());
                    }
                    ++n;
                }
            }
        }
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("LINK_NAVIGATOR_TO_EDITOR", this.linkingEnabled ? 1 : 0);
    }

    public void selectReveal(ISelection selection) {
        StructuredSelection ssel = this.convertSelection(selection);
        if (!ssel.isEmpty()) {
            this.getViewer().getControl().setRedraw(false);
            this.getViewer().setSelection((ISelection)ssel, true);
            this.getViewer().getControl().setRedraw(true);
        }
    }

    @Override
    public void setFiltersPreference(String[] patterns) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < patterns.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(patterns[i]);
            ++i;
        }
        this.getPlugin().getPreferenceStore().setValue("resourceFilters", sb.toString());
        IPreferenceStore preferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String storedPatterns = preferenceStore.getString("resourceFilters");
        if (storedPatterns.length() > 0) {
            preferenceStore.setValue("resourceFilters", "");
        }
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
    }

    @Deprecated
    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    @Override
    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.linkingEnabled = enabled;
        this.settings.put("LINK_NAVIGATOR_TO_EDITOR", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
        this.openAndLinkWithEditorHelper.setLinkWithEditor(enabled);
    }

    @Override
    @Deprecated
    public void setSorter(ResourceSorter sorter) {
        TreeViewer viewer = this.getTreeViewer();
        ViewerSorter viewerSorter = viewer.getSorter();
        viewer.getControl().setRedraw(false);
        if (viewerSorter == sorter) {
            viewer.refresh();
        } else {
            viewer.setSorter((ViewerSorter)sorter);
        }
        viewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, sorter.getCriteria());
        this.updateActionBars((IStructuredSelection)viewer.getSelection());
    }

    @Override
    public void setComparator(ResourceComparator comparator) {
        TreeViewer viewer = this.getTreeViewer();
        ViewerComparator viewerComparator = viewer.getComparator();
        viewer.getControl().setRedraw(false);
        if (viewerComparator == comparator) {
            viewer.refresh();
        } else {
            viewer.setComparator((ViewerComparator)comparator);
        }
        viewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, comparator.getCriteria());
        this.updateActionBars((IStructuredSelection)viewer.getSelection());
    }

    @Override
    public void setWorkingSet(IWorkingSet workingSet) {
        TreeViewer treeViewer = this.getTreeViewer();
        Object[] expanded = treeViewer.getExpandedElements();
        ITreeSelection structuredSelection = treeViewer.getStructuredSelection();
        boolean refreshNeeded = this.internalSetWorkingSet(workingSet);
        this.workingSetFilter.setWorkingSet(this.emptyWorkingSet ? null : workingSet);
        if (workingSet != null) {
            this.settings.put(STORE_WORKING_SET, workingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        this.updateTitle();
        if (refreshNeeded) {
            treeViewer.refresh();
        }
        treeViewer.setExpandedElements(expanded);
        if (!structuredSelection.isEmpty()) {
            treeViewer.reveal(structuredSelection.getFirstElement());
        }
    }

    private boolean internalSetWorkingSet(IWorkingSet workingSet) {
        boolean refreshNeeded = !Util.equals((Object)this.workingSet, (Object)workingSet);
        this.workingSet = workingSet;
        this.emptyWorkingSet = workingSet != null && workingSet.isAggregateWorkingSet() && workingSet.isEmpty();
        return refreshNeeded;
    }

    protected void updateActionBars(IStructuredSelection selection) {
        ResourceNavigatorActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    protected void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    public void updateTitle() {
        Object input = this.getViewer().getInput();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkingSet workingSet = this.workingSetFilter.getWorkingSet();
        if (input == null || input.equals(workspace) || input.equals(workspace.getRoot())) {
            this.setContentDescription("");
            if (workingSet != null) {
                this.setTitleToolTip(NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_workingSetToolTip, (Object)workingSet.getLabel()));
            } else {
                this.setTitleToolTip("");
            }
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
            String inputToolTip = this.getFrameToolTipText(input);
            String text = labelProvider.getText(input);
            if (text != null) {
                this.setContentDescription(text);
            }
            if (workingSet != null) {
                this.setTitleToolTip(NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_workingSetInputToolTip, (Object)inputToolTip, (Object)workingSet.getLabel()));
            } else {
                this.setTitleToolTip(inputToolTip);
            }
        }
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(ResourceNavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IShowInSource.class) {
            return adapter.cast(this.getShowInSource());
        }
        if (adapter == IShowInTarget.class) {
            return adapter.cast(this.getShowInTarget());
        }
        return null;
    }

    protected IShowInSource getShowInSource() {
        return () -> new ShowInContext(this.getViewer().getInput(), this.getViewer().getSelection());
    }

    protected IShowInTarget getShowInTarget() {
        return context -> {
            Object input;
            IResource resource;
            ArrayList<IResource> toSelect = new ArrayList<IResource>();
            ISelection sel = context.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)sel;
                for (Object o1 : ssel) {
                    IResource r2;
                    IMarker marker;
                    IResource resource2 = (IResource)Adapters.adapt(o1, IResource.class);
                    if (resource2 != null) {
                        toSelect.add(resource2);
                    }
                    if ((marker = (IMarker)Adapters.adapt(o1, IMarker.class)) == null || (r2 = marker.getResource()).getType() == 8) continue;
                    toSelect.add(r2);
                }
            }
            if (toSelect.isEmpty() && (resource = (IResource)Adapters.adapt((Object)(input = context.getInput()), IResource.class)) != null) {
                toSelect.add(resource);
            }
            if (!toSelect.isEmpty()) {
                this.selectReveal((ISelection)new StructuredSelection(toSelect));
                return true;
            }
            return false;
        };
    }

    protected static final Object getSingleElement(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }
}

